/*
 * Decompiled with CFR 0.152.
 */
package dnl.logging;

public class CallerData {
    private String callerClass;
    private String callingMethod;
    private String fullCallerString;
    private String line;

    public CallerData(String full, String line) {
        this.fullCallerString = full;
        int ind = full.lastIndexOf(46);
        this.callerClass = full.substring(0, ind);
        this.callingMethod = full.substring(ind + 1, full.length());
        this.line = line;
    }

    public CallerData(String full) {
        this.fullCallerString = full;
        int ind = full.lastIndexOf(46);
        this.callerClass = full.substring(0, ind);
        this.callingMethod = full.substring(ind + 1, full.length());
    }

    public Class<?> getCallerClass() {
        Class<?> c;
        try {
            c = Class.forName(this.getCallerClassName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return c;
    }

    public String getCallerClassName() {
        return this.callerClass;
    }

    public String getCallingMethod() {
        return this.callingMethod;
    }

    public String getFullDescription() {
        return this.fullCallerString;
    }

    public String getShortDescription() {
        return String.valueOf(this.getCallerClassShortName()) + "." + this.getCallingMethod() + "()";
    }

    public String getCallerClassShortName() {
        if (this.callerClass != null) {
            int ind = this.callerClass.lastIndexOf(46);
            if (ind == -1) {
                return this.callerClass;
            }
            return this.callerClass.substring(ind + 1);
        }
        return null;
    }

    public String getLine() {
        return this.line;
    }
}

