/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.Kim;
import org.json.zip.BitWriter;
import org.json.zip.Huff;
import org.json.zip.JSONzip;
import org.json.zip.Keep;

public class Zipper
extends JSONzip {
    final BitWriter bitwriter;

    public Zipper(BitWriter bitWriter) {
        this.bitwriter = bitWriter;
    }

    private static int bcd(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        switch (c) {
            case '.': {
                return 10;
            }
            case '-': {
                return 11;
            }
            case '+': {
                return 12;
            }
        }
        return 13;
    }

    public void flush() throws JSONException {
        this.pad(8);
    }

    private void one() throws JSONException {
        this.write(1, 1);
    }

    public void pad(int n) throws JSONException {
        try {
            this.bitwriter.pad(n);
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    private void write(int n, int n2) throws JSONException {
        try {
            this.bitwriter.write(n, n2);
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    private void write(int n, Huff huff) throws JSONException {
        huff.write(n, this.bitwriter);
    }

    private void write(Kim kim, Huff huff, Huff huff2) throws JSONException {
        for (int i = 0; i < kim.length; ++i) {
            int n = kim.get(i);
            this.write(n, huff);
            while ((n & 0x80) == 128) {
                n = kim.get(++i);
                this.write(n, huff2);
            }
        }
    }

    private void write(int n, Keep keep) throws JSONException {
        int n2 = keep.bitsize();
        keep.tick(n);
        this.write(n, n2);
    }

    private void write(JSONArray jSONArray) throws JSONException {
        boolean bl = false;
        int n = jSONArray.length();
        if (n == 0) {
            this.write(1, 3);
        } else {
            Object object = jSONArray.get(0);
            if (object == null) {
                object = JSONObject.NULL;
            }
            if (object instanceof String) {
                bl = true;
                this.write(6, 3);
                this.writeString((String)object);
            } else {
                this.write(7, 3);
                this.writeValue(object);
            }
            for (int i = 1; i < n; ++i) {
                object = jSONArray.get(i);
                if (object == null) {
                    object = JSONObject.NULL;
                }
                if (object instanceof String != bl) {
                    this.zero();
                }
                this.one();
                if (object instanceof String) {
                    this.writeString((String)object);
                    continue;
                }
                this.writeValue(object);
            }
            this.zero();
            this.zero();
        }
    }

    private void writeJSON(Object object) throws JSONException {
        if (JSONObject.NULL.equals(object)) {
            this.write(4, 3);
        } else if (Boolean.FALSE.equals(object)) {
            this.write(3, 3);
        } else if (Boolean.TRUE.equals(object)) {
            this.write(2, 3);
        } else {
            if (object instanceof Map) {
                object = new JSONObject((Map)object);
            } else if (object instanceof Collection) {
                object = new JSONArray((Collection)object);
            } else if (object.getClass().isArray()) {
                object = new JSONArray(object);
            }
            if (object instanceof JSONObject) {
                this.write((JSONObject)object);
            } else if (object instanceof JSONArray) {
                this.write((JSONArray)object);
            } else {
                throw new JSONException("Unrecognized object");
            }
        }
    }

    private void writeName(String string) throws JSONException {
        Kim kim = new Kim(string);
        int n = this.namekeep.find(kim);
        if (n != -1) {
            this.one();
            this.write(n, this.namekeep);
        } else {
            this.zero();
            this.write(kim, this.namehuff, this.namehuffext);
            this.write(256, this.namehuff);
            this.namekeep.register(kim);
        }
    }

    private void write(JSONObject jSONObject) throws JSONException {
        boolean bl = true;
        Iterator<String> iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!(string instanceof String)) continue;
            if (bl) {
                bl = false;
                this.write(5, 3);
            } else {
                this.one();
            }
            this.writeName(string);
            Object object = jSONObject.get(string);
            if (object instanceof String) {
                this.zero();
                this.writeString((String)object);
                continue;
            }
            this.one();
            this.writeValue(object);
        }
        if (bl) {
            this.write(0, 3);
        } else {
            this.zero();
        }
    }

    private void writeString(String string) throws JSONException {
        if (string.length() == 0) {
            this.zero();
            this.write(256, this.stringhuff);
        } else {
            Kim kim = new Kim(string);
            int n = this.stringkeep.find(kim);
            if (n != -1) {
                this.one();
                this.write(n, this.stringkeep);
            } else {
                this.zero();
                this.write(kim, this.stringhuff, this.stringhuffext);
                this.write(256, this.stringhuff);
                this.stringkeep.register(kim);
            }
        }
    }

    private void writeValue(Object object) throws JSONException {
        if (object instanceof Number) {
            long l;
            String string = JSONObject.numberToString((Number)object);
            int n = this.valuekeep.find(string);
            if (n != -1) {
                this.write(2, 2);
                this.write(n, this.valuekeep);
                return;
            }
            if ((object instanceof Integer || object instanceof Long) && (l = ((Number)object).longValue()) >= 0L && l < 16528L) {
                this.write(0, 2);
                if (l < 16L) {
                    this.zero();
                    this.write((int)l, 4);
                    return;
                }
                this.one();
                if (l < 144L) {
                    this.zero();
                    this.write((int)(l - 16L), 7);
                    return;
                }
                this.one();
                this.write((int)(l - 144L), 14);
                return;
            }
            this.write(1, 2);
            for (int i = 0; i < string.length(); ++i) {
                this.write(Zipper.bcd(string.charAt(i)), 4);
            }
            this.write(endOfNumber, 4);
            this.valuekeep.register(string);
        } else {
            this.write(3, 2);
            this.writeJSON(object);
        }
    }

    private void zero() throws JSONException {
        this.write(0, 1);
    }

    public void encode(JSONObject jSONObject) throws JSONException {
        this.generate();
        this.writeJSON(jSONObject);
    }

    public void encode(JSONArray jSONArray) throws JSONException {
        this.generate();
        this.writeJSON(jSONArray);
    }
}

