/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.Kim;
import org.json.zip.BitReader;
import org.json.zip.Huff;
import org.json.zip.JSONzip;
import org.json.zip.Keep;

public class Unzipper
extends JSONzip {
    BitReader bitreader;

    public Unzipper(BitReader bitReader) {
        this.bitreader = bitReader;
    }

    private boolean bit() throws JSONException {
        try {
            boolean bl = this.bitreader.bit();
            return bl;
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    private Object getAndTick(Keep keep, BitReader bitReader) throws JSONException {
        try {
            int n = keep.bitsize();
            int n2 = bitReader.read(n);
            Object object = keep.value(n2);
            if (n2 >= keep.length) {
                throw new JSONException("Deep error.");
            }
            keep.tick(n2);
            return object;
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    public boolean pad(int n) throws JSONException {
        try {
            return this.bitreader.pad(n);
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    private int read(int n) throws JSONException {
        try {
            int n2 = this.bitreader.read(n);
            return n2;
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    private String read(Huff huff, Huff huff2, Keep keep) throws JSONException {
        int n = 0;
        int n2 = 256;
        byte[] byArray = new byte[n2];
        if (this.bit()) {
            return this.getAndTick(keep, this.bitreader).toString();
        }
        while (true) {
            int n3;
            if (n >= n2) {
                byArray = Arrays.copyOf(byArray, n2 *= 2);
            }
            if ((n3 = huff.read(this.bitreader)) == 256) break;
            while ((n3 & 0x80) == 128) {
                byArray[n] = (byte)n3;
                ++n;
                n3 = huff2.read(this.bitreader);
            }
            byArray[n] = (byte)n3;
            ++n;
        }
        if (n == 0) {
            return "";
        }
        Kim kim = new Kim(byArray, n);
        keep.register(kim);
        return kim.toString();
    }

    private JSONArray readArray(boolean bl) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put(bl ? this.read(this.stringhuff, this.stringhuffext, this.stringkeep) : this.readValue());
        while (true) {
            if (!this.bit()) {
                if (!this.bit()) {
                    return jSONArray;
                }
                jSONArray.put(bl ? this.readValue() : this.read(this.stringhuff, this.stringhuffext, this.stringkeep));
                continue;
            }
            jSONArray.put(bl ? this.read(this.stringhuff, this.stringhuffext, this.stringkeep) : this.readValue());
        }
    }

    private Object readJSON() throws JSONException {
        switch (this.read(3)) {
            case 5: {
                return this.readObject();
            }
            case 6: {
                return this.readArray(true);
            }
            case 7: {
                return this.readArray(false);
            }
            case 0: {
                return new JSONObject();
            }
            case 1: {
                return new JSONArray();
            }
            case 2: {
                return Boolean.TRUE;
            }
            case 3: {
                return Boolean.FALSE;
            }
        }
        return JSONObject.NULL;
    }

    private JSONObject readObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        do {
            String string;
            if (jSONObject.opt(string = this.read(this.namehuff, this.namehuffext, this.namekeep)) != null) {
                throw new JSONException("Duplicate key.");
            }
            jSONObject.put(string, !this.bit() ? this.read(this.stringhuff, this.stringhuffext, this.stringkeep) : this.readValue());
        } while (this.bit());
        return jSONObject;
    }

    private Object readValue() throws JSONException {
        switch (this.read(2)) {
            case 0: {
                int n = !this.bit() ? 4 : (!this.bit() ? 7 : 14);
                int n2 = this.read(n);
                switch (n) {
                    case 7: {
                        n2 = (int)((long)n2 + 16L);
                        break;
                    }
                    case 14: {
                        n2 = (int)((long)n2 + 144L);
                    }
                }
                return n2;
            }
            case 1: {
                Object object;
                int n;
                byte[] byArray = new byte[256];
                int n3 = 0;
                while ((n = this.read(4)) != endOfNumber) {
                    byArray[n3] = bcd[n];
                    ++n3;
                }
                try {
                    object = JSONObject.stringToValue(new String(byArray, 0, n3, "US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new JSONException(unsupportedEncodingException);
                }
                this.valuekeep.register(object);
                return object;
            }
            case 2: {
                return this.getAndTick(this.valuekeep, this.bitreader);
            }
            case 3: {
                return this.readJSON();
            }
        }
        throw new JSONException("Impossible.");
    }

    public Object decode() throws JSONException {
        this.generate();
        return this.readJSON();
    }
}

