/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.util.HashMap;
import org.json.Kim;
import org.json.zip.JSONzip;
import org.json.zip.None;
import org.json.zip.PostMortem;

class Keep
implements None,
PostMortem {
    private int capacity;
    protected int length;
    private Object[] list;
    private HashMap<Object, Integer> map;
    private int power;
    private long[] ticks;

    public Keep(int n) {
        this.capacity = 1 << n;
        this.length = 0;
        this.power = 0;
        this.ticks = new long[this.capacity];
        this.list = new Object[this.capacity];
        this.map = new HashMap(this.capacity);
    }

    public static long age(long l) {
        return l >= 32L ? 16L : l / 2L;
    }

    public int bitsize() {
        while (1 << this.power < this.length) {
            ++this.power;
        }
        return this.power;
    }

    public void tick(int n) {
        int n2 = n;
        this.ticks[n2] = this.ticks[n2] + 1L;
    }

    private void compact() {
        int n = 0;
        for (int i = 0; i < this.capacity; ++i) {
            Object object = this.list[i];
            long l = Keep.age(this.ticks[i]);
            if (l > 0L) {
                this.ticks[n] = l;
                this.list[n] = object;
                this.map.put(object, n);
                ++n;
                continue;
            }
            this.map.remove(object);
        }
        if (n < this.capacity) {
            this.length = n;
        } else {
            this.map.clear();
            this.length = 0;
        }
        this.power = 0;
    }

    public int find(Object object) {
        Integer n = this.map.get(object);
        return n instanceof Integer ? n : -1;
    }

    @Override
    public boolean postMortem(PostMortem postMortem) {
        Keep keep = (Keep)postMortem;
        if (this.length != keep.length) {
            JSONzip.log(this.length + " <> " + keep.length);
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            boolean bl;
            if (this.list[i] instanceof Kim) {
                bl = this.list[i].equals(keep.list[i]);
            } else {
                Object object = this.list[i];
                Object object2 = keep.list[i];
                if (object instanceof Number) {
                    object = object.toString();
                }
                if (object2 instanceof Number) {
                    object2 = object2.toString();
                }
                bl = object.equals(object2);
            }
            if (bl) continue;
            JSONzip.log("\n[" + i + "]\n " + this.list[i] + "\n " + keep.list[i] + "\n " + this.ticks[i] + "\n " + keep.ticks[i]);
            return false;
        }
        return true;
    }

    public void register(Object object) {
        if (this.length >= this.capacity) {
            this.compact();
        }
        this.list[this.length] = object;
        this.map.put(object, this.length);
        this.ticks[this.length] = 1L;
        ++this.length;
    }

    public Object value(int n) {
        return this.list[n];
    }
}

