/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XMLTokener;

public class XML {
    public static final Character AMP = Character.valueOf('&');
    public static final Character APOS = Character.valueOf('\'');
    public static final Character BANG = Character.valueOf('!');
    public static final Character EQ = Character.valueOf('=');
    public static final Character GT = Character.valueOf('>');
    public static final Character LT = Character.valueOf('<');
    public static final Character QUEST = Character.valueOf('?');
    public static final Character QUOT = Character.valueOf('\"');
    public static final Character SLASH = Character.valueOf('/');

    public static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static void noSpace(String string) throws JSONException {
        int n = string.length();
        if (n == 0) {
            throw new JSONException("Empty string.");
        }
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            throw new JSONException("'" + string + "' contains a space character.");
        }
    }

    private static boolean parse(XMLTokener xMLTokener, JSONObject jSONObject, String string) throws JSONException {
        String string2;
        JSONObject jSONObject2 = null;
        Object object = xMLTokener.nextToken();
        if (object == BANG) {
            char c = xMLTokener.next();
            if (c == '-') {
                if (xMLTokener.next() == '-') {
                    xMLTokener.skipPast("-->");
                    return false;
                }
                xMLTokener.back();
            } else if (c == '[') {
                object = xMLTokener.nextToken();
                if ("CDATA".equals(object) && xMLTokener.next() == '[') {
                    String string3 = xMLTokener.nextCDATA();
                    if (string3.length() > 0) {
                        jSONObject.accumulate("content", string3);
                    }
                    return false;
                }
                throw xMLTokener.syntaxError("Expected 'CDATA['");
            }
            int n = 1;
            do {
                if ((object = xMLTokener.nextMeta()) == null) {
                    throw xMLTokener.syntaxError("Missing '>' after '<!'.");
                }
                if (object == LT) {
                    ++n;
                    continue;
                }
                if (object != GT) continue;
                --n;
            } while (n > 0);
            return false;
        }
        if (object == QUEST) {
            xMLTokener.skipPast("?>");
            return false;
        }
        if (object == SLASH) {
            object = xMLTokener.nextToken();
            if (string == null) {
                throw xMLTokener.syntaxError("Mismatched close tag " + object);
            }
            if (!object.equals(string)) {
                throw xMLTokener.syntaxError("Mismatched " + string + " and " + object);
            }
            if (xMLTokener.nextToken() != GT) {
                throw xMLTokener.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (object instanceof Character) {
            throw xMLTokener.syntaxError("Misshaped tag");
        }
        String string4 = (String)object;
        object = null;
        jSONObject2 = new JSONObject();
        while (true) {
            if (object == null) {
                object = xMLTokener.nextToken();
            }
            if (!(object instanceof String)) break;
            string2 = (String)object;
            object = xMLTokener.nextToken();
            if (object == EQ) {
                object = xMLTokener.nextToken();
                if (!(object instanceof String)) {
                    throw xMLTokener.syntaxError("Missing value");
                }
                jSONObject2.accumulate(string2, XML.stringToValue((String)object));
                object = null;
                continue;
            }
            jSONObject2.accumulate(string2, "");
        }
        if (object == SLASH) {
            if (xMLTokener.nextToken() != GT) {
                throw xMLTokener.syntaxError("Misshaped tag");
            }
            if (jSONObject2.length() > 0) {
                jSONObject.accumulate(string4, jSONObject2);
            } else {
                jSONObject.accumulate(string4, "");
            }
            return false;
        }
        if (object == GT) {
            while (true) {
                if ((object = xMLTokener.nextContent()) == null) {
                    if (string4 != null) {
                        throw xMLTokener.syntaxError("Unclosed tag " + string4);
                    }
                    return false;
                }
                if (object instanceof String) {
                    string2 = (String)object;
                    if (string2.length() <= 0) continue;
                    jSONObject2.accumulate("content", XML.stringToValue(string2));
                    continue;
                }
                if (object == LT && XML.parse(xMLTokener, jSONObject2, string4)) break;
            }
            if (jSONObject2.length() == 0) {
                jSONObject.accumulate(string4, "");
            } else if (jSONObject2.length() == 1 && jSONObject2.opt("content") != null) {
                jSONObject.accumulate(string4, jSONObject2.opt("content"));
            } else {
                jSONObject.accumulate(string4, jSONObject2);
            }
            return false;
        }
        throw xMLTokener.syntaxError("Misshaped tag");
    }

    public static Object stringToValue(String string) {
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string)) {
            return JSONObject.NULL;
        }
        try {
            Long l;
            char c = string.charAt(0);
            if ((c == '-' || c >= '0' && c <= '9') && (l = new Long(string)).toString().equals(string)) {
                return l;
            }
        }
        catch (Exception exception) {
            try {
                Double d = new Double(string);
                if (d.toString().equals(string)) {
                    return d;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return string;
    }

    public static JSONObject toJSONObject(String string) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        XMLTokener xMLTokener = new XMLTokener(string);
        while (xMLTokener.more() && xMLTokener.skipPast("<")) {
            XML.parse(xMLTokener, jSONObject, null);
        }
        return jSONObject;
    }

    public static String toString(Object object) throws JSONException {
        return XML.toString(object, null);
    }

    public static String toString(Object object, String string) throws JSONException {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        if (object instanceof JSONObject) {
            if (string != null) {
                stringBuilder.append('<');
                stringBuilder.append(string);
                stringBuilder.append('>');
            }
            JSONObject jSONObject = (JSONObject)object;
            Iterator<String> iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                int n;
                int n2;
                JSONArray jSONArray;
                String string3;
                String string4 = iterator.next();
                Object object2 = jSONObject.opt(string4);
                if (object2 == null) {
                    object2 = "";
                }
                String string5 = string3 = object2 instanceof String ? (String)object2 : null;
                if ("content".equals(string4)) {
                    if (object2 instanceof JSONArray) {
                        jSONArray = (JSONArray)object2;
                        n2 = jSONArray.length();
                        for (n = 0; n < n2; ++n) {
                            if (n > 0) {
                                stringBuilder.append('\n');
                            }
                            stringBuilder.append(XML.escape(jSONArray.get(n).toString()));
                        }
                        continue;
                    }
                    stringBuilder.append(XML.escape(object2.toString()));
                    continue;
                }
                if (object2 instanceof JSONArray) {
                    jSONArray = (JSONArray)object2;
                    n2 = jSONArray.length();
                    for (n = 0; n < n2; ++n) {
                        object2 = jSONArray.get(n);
                        if (object2 instanceof JSONArray) {
                            stringBuilder.append('<');
                            stringBuilder.append(string4);
                            stringBuilder.append('>');
                            stringBuilder.append(XML.toString(object2));
                            stringBuilder.append("</");
                            stringBuilder.append(string4);
                            stringBuilder.append('>');
                            continue;
                        }
                        stringBuilder.append(XML.toString(object2, string4));
                    }
                    continue;
                }
                if ("".equals(object2)) {
                    stringBuilder.append('<');
                    stringBuilder.append(string4);
                    stringBuilder.append("/>");
                    continue;
                }
                stringBuilder.append(XML.toString(object2, string4));
            }
            if (string != null) {
                stringBuilder.append("</");
                stringBuilder.append(string);
                stringBuilder.append('>');
            }
            return stringBuilder.toString();
        }
        if (object.getClass().isArray()) {
            object = new JSONArray(object);
        }
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(XML.toString(jSONArray.opt(i), string == null ? "array" : string));
            }
            return stringBuilder.toString();
        }
        String string6 = string2 = object == null ? "null" : XML.escape(object.toString());
        return string == null ? "\"" + string2 + "\"" : (string2.length() == 0 ? "<" + string + "/>" : "<" + string + ">" + string2 + "</" + string + ">");
    }
}

