/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Arrays;
import org.json.JSONException;

public class Kim {
    private byte[] bytes = null;
    private int hashcode = 0;
    public int length = 0;
    private String string = null;

    public Kim(byte[] byArray, int n, int n2) {
        int n3 = 1;
        this.hashcode = 0;
        this.length = n2 - n;
        if (this.length > 0) {
            this.bytes = new byte[this.length];
            for (int i = 0; i < this.length; ++i) {
                int n4 = byArray[i + n] & 0xFF;
                this.hashcode += (n3 += n4);
                this.bytes[i] = (byte)n4;
            }
            this.hashcode += n3 << 16;
        }
    }

    public Kim(byte[] byArray, int n) {
        this(byArray, 0, n);
    }

    public Kim(Kim kim, int n, int n2) {
        this(kim.bytes, n, n2);
    }

    public Kim(String string) throws JSONException {
        int n = string.length();
        this.hashcode = 0;
        this.length = 0;
        if (n > 0) {
            int n2;
            int n3;
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = string.charAt(n4);
                if (n3 <= 127) {
                    ++this.length;
                    continue;
                }
                if (n3 <= 16383) {
                    this.length += 2;
                    continue;
                }
                if (n3 >= 55296 && n3 <= 57343) {
                    n2 = string.charAt(++n4);
                    if (n3 > 56319 || n2 < 56320 || n2 > 57343) {
                        throw new JSONException("Bad UTF16");
                    }
                }
                this.length += 3;
            }
            this.bytes = new byte[this.length];
            n4 = 0;
            n2 = 1;
            for (int i = 0; i < n; ++i) {
                int n5 = string.charAt(i);
                if (n5 <= 127) {
                    this.bytes[n4] = (byte)n5;
                    this.hashcode += (n2 += n5);
                    ++n4;
                    continue;
                }
                if (n5 <= 16383) {
                    n3 = 0x80 | n5 >>> 7;
                    this.bytes[n4] = (byte)n3;
                    this.hashcode += (n2 += n3);
                    n3 = n5 & 0x7F;
                    this.bytes[++n4] = (byte)n3;
                    this.hashcode += (n2 += n3);
                    ++n4;
                    continue;
                }
                if (n5 >= 55296 && n5 <= 56319) {
                    n5 = ((n5 & 0x3FF) << 10 | string.charAt(++i) & 0x3FF) + 65536;
                }
                n3 = 0x80 | n5 >>> 14;
                this.bytes[n4] = (byte)n3;
                this.hashcode += (n2 += n3);
                n3 = 0x80 | n5 >>> 7 & 0xFF;
                this.bytes[++n4] = (byte)n3;
                this.hashcode += (n2 += n3);
                n3 = n5 & 0x7F;
                this.bytes[++n4] = (byte)n3;
                this.hashcode += (n2 += n3);
                ++n4;
            }
            this.hashcode += n2 << 16;
        }
    }

    public int characterAt(int n) throws JSONException {
        int n2 = this.get(n);
        if ((n2 & 0x80) == 0) {
            return n2;
        }
        int n3 = this.get(n + 1);
        if ((n3 & 0x80) == 0) {
            int n4 = (n2 & 0x7F) << 7 | n3;
            if (n4 > 127) {
                return n4;
            }
        } else {
            int n5 = this.get(n + 2);
            int n6 = (n2 & 0x7F) << 14 | (n3 & 0x7F) << 7 | n5;
            if ((n5 & 0x80) == 0 && n6 > 16383 && n6 <= 0x10FFFF && (n6 < 55296 || n6 > 57343)) {
                return n6;
            }
        }
        throw new JSONException("Bad character at " + n);
    }

    public static int characterSize(int n) throws JSONException {
        if (n < 0 || n > 0x10FFFF) {
            throw new JSONException("Bad character " + n);
        }
        return n <= 127 ? 1 : (n <= 16383 ? 2 : 3);
    }

    public int copy(byte[] byArray, int n) {
        System.arraycopy(this.bytes, 0, byArray, n, this.length);
        return n + this.length;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Kim)) {
            return false;
        }
        Kim kim = (Kim)object;
        if (this == kim) {
            return true;
        }
        if (this.hashcode != kim.hashcode) {
            return false;
        }
        return Arrays.equals(this.bytes, kim.bytes);
    }

    public int get(int n) throws JSONException {
        if (n < 0 || n > this.length) {
            throw new JSONException("Bad character at " + n);
        }
        return this.bytes[n] & 0xFF;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() throws JSONException {
        if (this.string == null) {
            int n;
            int n2 = 0;
            char[] cArray = new char[this.length];
            for (int i = 0; i < this.length; i += Kim.characterSize(n)) {
                n = this.characterAt(i);
                if (n < 65536) {
                    cArray[n2] = (char)n;
                    ++n2;
                    continue;
                }
                cArray[n2] = (char)(0xD800 | n - 65536 >>> 10);
                cArray[++n2] = (char)(0xDC00 | n & 0x3FF);
                ++n2;
            }
            this.string = new String(cArray, 0, n2);
        }
        return this.string;
    }
}

