/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import miui.imagefilters.FilterParamType;
import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class TransformFilter
extends IImageFilter.AbstractImageFilter {
    private float[] mPointsMapping;
    private boolean mBasedOnContent = false;
    private boolean mKeepAspectRatio = true;
    private int mMinVisibleAlpha = 10;

    @FilterParamType(value=FilterParamType.ParamType.ICON_SIZE)
    public void setPointsMapping(float[] fArray) {
        if (fArray == null || fArray.length == 8) {
            this.mPointsMapping = fArray;
        }
    }

    public void setBasedOnContent(boolean bl) {
        this.mBasedOnContent = bl;
    }

    public void setContentKeepAspectRatio(boolean bl) {
        this.mKeepAspectRatio = bl;
    }

    public void setMinVisibleAlpha(int n) {
        this.mMinVisibleAlpha = ImageFilterUtils.clamp(0, n, 255);
    }

    @Override
    public void processData(ImageData imageData) {
        int n = imageData.width;
        int n2 = imageData.height;
        int[] nArray = imageData.pixels;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = n;
        float f4 = n2;
        float[] fArray = this.mPointsMapping;
        if (fArray == null) {
            fArray = new float[]{f, f2, f3, f2, f3, f4, f, f4};
        }
        if (this.mBasedOnContent) {
            f = this.scanEdge(n, n2, nArray, true, true);
            f2 = this.scanEdge(n, n2, nArray, false, true);
            f3 = this.scanEdge(n, n2, nArray, true, false);
            f4 = this.scanEdge(n, n2, nArray, false, false);
            if (f == -1.0f || f == f3 || f2 == f4) {
                return;
            }
            if (this.mKeepAspectRatio) {
                float f5 = f3 - f;
                float f6 = f4 - f2;
                if (f5 / (float)n > f6 / (float)n2) {
                    float f7 = f5 / (float)n * (float)n2;
                    f2 -= (f7 - f6) / 2.0f;
                    f4 += (f7 - f6) / 2.0f;
                } else {
                    float f8 = f6 / (float)n2 * (float)n;
                    f -= (f8 - f5) / 2.0f;
                    f3 += (f8 - f5) / 2.0f;
                }
            }
        }
        float[] fArray2 = new float[]{f, f2, f3, f2, f3, f4, f, f4};
    }

    private int scanEdge(int n, int n2, int[] nArray, boolean bl, boolean bl2) {
        int n3 = bl ? n : n2;
        int n4 = bl ? n2 : n;
        int n5 = bl2 ? 0 : n3 - 1;
        int n6 = bl2 ? n3 - 1 : 0;
        int n7 = n5;
        while (n7 != n6) {
            for (int i = 0; i < n4; ++i) {
                int n8;
                int n9 = n8 = bl ? i * n + n7 : i + n7 * n;
                if (nArray[n8] >>> 24 <= this.mMinVisibleAlpha) continue;
                return n7;
            }
            if (bl2) {
                ++n7;
                continue;
            }
            --n7;
        }
        return -1;
    }
}

