/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class SpreadFilter
extends IImageFilter.AbstractImageFilter {
    private int mRadius;
    private boolean mIsSpreadBlack = true;
    private boolean mIsAlphaSpread = false;

    public void setRadius(int n) {
        this.mRadius = n;
    }

    public void setIsSpreadBlack(boolean bl) {
        this.mIsSpreadBlack = bl;
    }

    public void setIsAlphaSpread(boolean bl) {
        this.mIsAlphaSpread = bl;
    }

    @Override
    public void processData(ImageData imageData) {
        int n = imageData.width;
        int n2 = imageData.height;
        int[] nArray = imageData.pixels;
        int[] nArray2 = imageData.getBackPixels();
        for (int i = 0; i <= n2 - 1; ++i) {
            for (int j = 0; j <= n - 1; ++j) {
                int n3 = i * n + j;
                nArray2[n3] = this.processPerPixel(nArray, j, i, n, n2);
            }
        }
        imageData.swapPixels();
    }

    private int processPerPixel(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = this.mRadius * this.mRadius;
        int n6 = this.mIsAlphaSpread ? 255 : 0;
        int n7 = 0;
        int n8 = -1;
        for (int i = -this.mRadius; i <= this.mRadius; ++i) {
            for (int j = -this.mRadius; j <= this.mRadius; ++j) {
                int n9;
                if (i * i + j * j > n5) continue;
                int n10 = SpreadFilter.getColor(nArray, n + j, n2 + i, n3, n4);
                int n11 = this.getLuminance(n10, n9 = n10 >>> 24 & 0xFF);
                n8 = Math.max(n11, n8);
                if (n8 == n11) {
                    n7 = n10;
                }
                n6 = this.mIsAlphaSpread ? Math.min(n6, n9) : Math.max(n6, n9);
            }
        }
        return n6 << 24 | n7 & 0xFFFFFF;
    }

    private int getLuminance(int n, int n2) {
        int n3 = ImageFilterUtils.convertColorToGrayscale(n);
        if (this.mIsSpreadBlack) {
            n3 = 255 - n3;
        }
        return n3 *= n2;
    }

    private static final int getColor(int[] nArray, int n, int n2, int n3, int n4) {
        n = ImageFilterUtils.clamp(0, n, n3 - 1);
        n2 = ImageFilterUtils.clamp(0, n2, n4 - 1);
        return nArray[n2 * n3 + n];
    }
}

