/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class LevelsFilter
extends IImageFilter.AbstractImageFilter {
    private float mInputMin = 0.0f;
    private float mInputMiddle = 1.0f;
    private float mInputMax = 255.0f;
    private float mOutputMin = 0.0f;
    private float mOutputMax = 255.0f;
    private boolean mIsFilterR = true;
    private boolean mIsFilterG = true;
    private boolean mIsFilterB = true;

    public void setInputMin(float f) {
        this.mInputMin = ImageFilterUtils.clamp(0.0f, f, 253.0f);
    }

    public void setInputMiddle(float f) {
        this.mInputMiddle = ImageFilterUtils.clamp(1.0E-4f, f, 9.9999f);
    }

    public void setInputMax(float f) {
        this.mInputMax = ImageFilterUtils.clamp(2.0f, f, 255.0f);
    }

    public void setOutputMin(float f) {
        this.mOutputMin = ImageFilterUtils.clamp(0.0f, f, 255.0f);
    }

    public void setOutputMax(float f) {
        this.mOutputMax = ImageFilterUtils.clamp(0.0f, f, 255.0f);
    }

    public void setChannel(String string) {
        boolean[] blArray = new boolean[3];
        ImageFilterUtils.checkChannelParam(string, blArray);
        this.mIsFilterR = blArray[0];
        this.mIsFilterG = blArray[1];
        this.mIsFilterB = blArray[2];
    }

    @Override
    public void processData(ImageData imageData) {
        int n = imageData.width;
        int n2 = imageData.height;
        int[] nArray = imageData.pixels;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = j * n + i;
                int n4 = nArray[n3];
                int n5 = (n4 & 0xFF0000) >>> 16;
                int n6 = (n4 & 0xFF00) >>> 8;
                int n7 = n4 & 0xFF;
                if (this.mIsFilterR) {
                    n5 = LevelsFilter.interpolate(this.mInputMin, this.mInputMiddle, this.mInputMax, this.mOutputMin, this.mOutputMax, n5);
                }
                if (this.mIsFilterG) {
                    n6 = LevelsFilter.interpolate(this.mInputMin, this.mInputMiddle, this.mInputMax, this.mOutputMin, this.mOutputMax, n6);
                }
                if (this.mIsFilterB) {
                    n7 = LevelsFilter.interpolate(this.mInputMin, this.mInputMiddle, this.mInputMax, this.mOutputMin, this.mOutputMax, n7);
                }
                nArray[n3] = n5 << 16 | n6 << 8 | n7 | n4 & 0xFF000000;
            }
        }
    }

    private static int interpolate(float f, float f2, float f3, float f4, float f5, int n) {
        if ((float)n <= f) {
            return (int)f4;
        }
        if ((float)n >= f3) {
            return (int)f5;
        }
        if (f2 == 1.0f) {
            return (int)(f4 + ((float)n - f) * (f5 - f4) / (f3 - f));
        }
        float f6 = f3 - f;
        float f7 = f5 - f4;
        float f8 = ((float)n - f) / f6;
        f8 = 1.0f - (float)Math.pow(1.0f - f8, f2);
        return (int)(f4 + f7 * f8);
    }
}

