/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import android.graphics.Bitmap;
import android.util.Log;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miui.imagefilters.EdgesFilter;
import miui.imagefilters.GrayScaleFilter;
import miui.imagefilters.HslWrapFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;
import miui.imagefilters.LevelsFilter;

public interface IImageFilter {
    public static final String TAG = "IImageFilter";

    public boolean initParams(String var1, List<Object> var2);

    public void process(ImageData var1);

    public void putOriginalImage(Bitmap var1);

    public boolean canConcurrence();

    public static class ImageFilterGroup {
        public IImageFilter[] mFilters;

        public ImageFilterGroup(IImageFilter[] iImageFilterArray) {
            this.mFilters = iImageFilterArray;
        }

        public ImageData processAll(Bitmap bitmap) {
            ImageData imageData = ImageData.bitmapToImageData(bitmap);
            for (IImageFilter iImageFilter : this.mFilters) {
                iImageFilter.putOriginalImage(bitmap);
                iImageFilter.process(imageData);
            }
            return imageData;
        }
    }

    public static abstract class AbstractImageFilter
    implements IImageFilter {
        private Map<String, List<Object>> mParams;

        @Override
        public boolean initParams(String string, List<Object> list) {
            if (list == null || list.size() == 0) {
                return false;
            }
            boolean bl = ImageFilterUtils.setProperty(this, string, list.get(0));
            if (bl && list.size() > 1) {
                if (this.mParams == null) {
                    this.mParams = new HashMap<String, List<Object>>();
                }
                this.mParams.put(string, list);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(ImageData imageData) {
            if (this.canConcurrence()) {
                this.fillRandomParams(imageData);
                this.processData(imageData);
            } else {
                AbstractImageFilter abstractImageFilter = this;
                synchronized (abstractImageFilter) {
                    this.fillRandomParams(imageData);
                    this.processData(imageData);
                }
            }
        }

        private void fillRandomParams(ImageData imageData) {
            if (this.mParams != null) {
                for (Map.Entry<String, List<Object>> entry : this.mParams.entrySet()) {
                    String string = entry.getKey();
                    List<Object> list = entry.getValue();
                    int n = imageData.generalRandomNum(list.size());
                    ImageFilterUtils.setProperty(this, string, list.get(n));
                }
            }
        }

        public abstract void processData(ImageData var1);

        @Override
        public void putOriginalImage(Bitmap bitmap) {
        }

        @Override
        public boolean canConcurrence() {
            return this.mParams == null || this.mParams.size() <= 1;
        }
    }

    public static class Factory {
        public static IImageFilter create(String string, List<Map.Entry<String, String>> list) {
            AbstractImageFilter abstractImageFilter = null;
            if ("Hsl".equalsIgnoreCase(string)) {
                abstractImageFilter = new HslWrapFilter();
            } else if ("Edges".equalsIgnoreCase(string)) {
                abstractImageFilter = new EdgesFilter();
            } else if ("Levels".equalsIgnoreCase(string)) {
                abstractImageFilter = new LevelsFilter();
            } else if ("GrayScale".equalsIgnoreCase(string)) {
                abstractImageFilter = new GrayScaleFilter();
            } else if (!"BlendImage".equalsIgnoreCase(string)) {
                Log.w(IImageFilter.TAG, "unknown filter:" + string);
                return null;
            }
            if (list != null && list.size() > 0) {
                for (Map.Entry<String, String> entry : list) {
                    Factory.setProperty(abstractImageFilter, entry.getKey(), entry.getValue());
                }
            }
            return abstractImageFilter;
        }

        private static void setProperty(Object object, String string, String string2) {
            String string3 = "set" + string;
            Method method = null;
            Method[] methodArray = object.getClass().getMethods();
            for (Method method2 : methodArray) {
                if (!string3.equalsIgnoreCase(method2.getName()) || method2.getParameterTypes().length != 1) continue;
                method = method2;
                break;
            }
            if (method == null) {
                Log.w(IImageFilter.TAG, "unknown property:" + string + ",obj:" + object);
                return;
            }
            Class<?> clazz = method.getParameterTypes()[0];
            try {
                Object object2 = null;
                if (String.class.equals((Object)clazz)) {
                    object2 = string2;
                } else if (Integer.TYPE.equals(clazz)) {
                    object2 = Integer.parseInt(string2);
                } else if (Float.TYPE.equals(clazz)) {
                    object2 = Float.valueOf(Float.parseFloat(string2));
                } else if (Double.TYPE.equals(clazz)) {
                    object2 = Double.parseDouble(string2);
                } else if (Boolean.TYPE.equals(clazz)) {
                    object2 = Boolean.parseBoolean(string2);
                } else if (clazz.isEnum()) {
                    object2 = Enum.valueOf(clazz, string2);
                } else {
                    Log.w(IImageFilter.TAG, "unknown param type:" + clazz.getName() + ",obj:" + object + ",property:" + string);
                    return;
                }
                method.invoke(object, object2);
            }
            catch (Exception exception) {
                Log.e(IImageFilter.TAG, "set property fail. obj:" + object + ",property:" + string + ",value:" + string2, exception);
            }
        }
    }
}

