/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class HslFilter
extends IImageFilter.AbstractImageFilter {
    private float mHueModify = Float.NaN;
    private float mSaturationModify = Float.NaN;
    private float mLightnessModify = Float.NaN;
    private float mHueAdjust = Float.NaN;
    private float mSaturationAdjust = Float.NaN;
    private float mLightnessAdjust = Float.NaN;
    public boolean useHsv;

    public void setHueModify(float f) {
        this.mHueModify = ImageFilterUtils.clamp(0.0f, f, 359.9999f);
    }

    public void setSaturationModify(float f) {
        this.mSaturationModify = ImageFilterUtils.clamp(0.0f, f /= 100.0f, 1.0f);
    }

    public void setLightnessModify(float f) {
        this.mLightnessModify = ImageFilterUtils.clamp(0.0f, f /= 100.0f, 1.0f);
    }

    public void setHueAdjust(float f) {
        this.mHueAdjust = ImageFilterUtils.clamp(-180.0f, f, 180.0f);
    }

    public void setSaturationAdjust(float f) {
        this.mSaturationAdjust = ImageFilterUtils.clamp(-1.0f, f /= 100.0f, 1.0f);
    }

    public void setLightnessAdjust(float f) {
        this.mLightnessAdjust = ImageFilterUtils.clamp(-1.0f, f /= 100.0f, 1.0f);
    }

    @Override
    public void processData(ImageData imageData) {
        int n = imageData.width;
        int n2 = imageData.height;
        int[] nArray = imageData.pixels;
        float[] fArray = new float[3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = j * n + i;
                int n4 = nArray[n3];
                if (this.useHsv) {
                    ImageFilterUtils.RgbToHsv(n4, fArray);
                } else {
                    ImageFilterUtils.RgbToHsl(n4, fArray);
                }
                float f = fArray[0];
                float f2 = fArray[1];
                float f3 = fArray[2];
                if (!Float.isNaN(this.mHueModify)) {
                    f = this.mHueModify;
                } else if (!Float.isNaN(this.mHueAdjust)) {
                    if ((f += this.mHueAdjust) >= 360.0f) {
                        f -= 360.0f;
                    } else if (f < 0.0f) {
                        f += 360.0f;
                    }
                }
                if (!Float.isNaN(this.mSaturationModify)) {
                    f2 = this.mSaturationModify;
                } else if (!Float.isNaN(this.mSaturationAdjust)) {
                    if (this.mSaturationAdjust <= 0.0f) {
                        f2 *= 1.0f + this.mSaturationAdjust;
                    } else {
                        float f4 = Math.min(1.0f, this.mSaturationAdjust * 2.0f);
                        float f5 = (this.mSaturationAdjust - 0.5f) * 2.0f;
                        f2 *= 1.0f + f4;
                        if (f5 > 0.0f) {
                            f2 += f5;
                        }
                    }
                    f2 = ImageFilterUtils.clamp(0.0f, f2, 1.0f);
                }
                if (!Float.isNaN(this.mLightnessModify)) {
                    f3 = this.mLightnessModify;
                } else if (!Float.isNaN(this.mLightnessAdjust)) {
                    f3 = this.mLightnessAdjust <= 0.0f ? (f3 *= 1.0f + this.mLightnessAdjust) : 1.0f - (1.0f - f3) * (1.0f - this.mLightnessAdjust);
                }
                int n5 = this.useHsv ? ImageFilterUtils.HsvToRgb(f, f2, f3) : ImageFilterUtils.HslToRgb(f, f2, f3);
                nArray[n3] = n5 & 0xFFFFFF | nArray[n3] & 0xFF000000;
            }
        }
    }
}

