/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import android.graphics.Color;
import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class GrayScaleFilter
extends IImageFilter.AbstractImageFilter {
    private int mBlackColor = -16777216;
    private int mWhiteColor = -1;

    public void setBlackColor(String string) {
        this.mBlackColor = Color.parseColor(string);
    }

    public void setWhiteColor(String string) {
        this.mWhiteColor = Color.parseColor(string);
    }

    @Override
    public void processData(ImageData imageData) {
        int n = imageData.width;
        int n2 = imageData.height;
        int[] nArray = imageData.pixels;
        int n3 = this.mBlackColor >>> 24;
        int n4 = this.mWhiteColor >>> 24;
        int n5 = this.mBlackColor >>> 16 & 0xFF;
        int n6 = this.mWhiteColor >>> 16 & 0xFF;
        int n7 = this.mBlackColor >>> 8 & 0xFF;
        int n8 = this.mWhiteColor >>> 8 & 0xFF;
        int n9 = this.mBlackColor & 0xFF;
        int n10 = this.mWhiteColor & 0xFF;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n11 = j * n + i;
                int n12 = nArray[n11];
                int n13 = ImageFilterUtils.convertColorToGrayscale(n12);
                int n14 = ImageFilterUtils.interpolate(0, 255, n3, n4, n13);
                int n15 = ImageFilterUtils.interpolate(0, 255, n5, n6, n13);
                int n16 = ImageFilterUtils.interpolate(0, 255, n7, n8, n13);
                int n17 = ImageFilterUtils.interpolate(0, 255, n9, n10, n13);
                n14 = n14 * (n12 >>> 24) / 255;
                nArray[n11] = n14 << 24 | n15 << 16 | n16 << 8 | n17;
            }
        }
    }
}

