/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import android.util.FloatMath;
import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class ConvolutionFilter
extends IImageFilter.AbstractImageFilter {
    private int mMatrixSideLength;
    private int[] mMatrix;
    private int mDivisor;
    private int mBias;
    private boolean mIsFilterR = true;
    private boolean mIsFilterG = true;
    private boolean mIsFilterB = true;
    private boolean mIsFilterA = true;
    private int mRepeatCount;
    private boolean mIsParamsFormated;

    public void setMatrix(int[] nArray) {
        this.mMatrix = nArray;
        this.mIsParamsFormated = false;
    }

    public void setRepeatCount(int n) {
        this.mRepeatCount = n;
    }

    public void setDivisor(int n) {
        this.mDivisor = n;
        this.mIsParamsFormated = false;
    }

    public void setBias(int n) {
        this.mBias = n;
    }

    public void setChannel(String string) {
        boolean[] blArray = new boolean[4];
        ImageFilterUtils.checkChannelParam(string, blArray);
        this.mIsFilterR = blArray[0];
        this.mIsFilterG = blArray[1];
        this.mIsFilterB = blArray[2];
        this.mIsFilterA = blArray[3];
    }

    private synchronized void formatParams() {
        if (this.mIsParamsFormated) {
            return;
        }
        this.mIsParamsFormated = true;
        if (this.mMatrix != null) {
            if (this.mMatrix.length == 9) {
                this.mMatrixSideLength = 3;
            } else if (this.mMatrix.length == 25) {
                this.mMatrixSideLength = 5;
            } else {
                this.mMatrixSideLength = (int)FloatMath.sqrt(this.mMatrix.length);
                if (this.mMatrixSideLength * this.mMatrixSideLength != this.mMatrix.length) {
                    throw new RuntimeException("matrix must be a square matrix.");
                }
                if (this.mMatrixSideLength % 2 != 1) {
                    throw new RuntimeException("matrixX and matrixY must be odd.");
                }
            }
            if (this.mDivisor == 0) {
                for (int i = 0; i < this.mMatrix.length; ++i) {
                    this.mDivisor += this.mMatrix[i];
                }
                if (this.mDivisor == 0) {
                    this.mDivisor = 1;
                }
            }
        }
    }

    @Override
    public void processData(ImageData imageData) {
        if (!this.mIsParamsFormated) {
            this.formatParams();
        }
        if (this.mMatrix == null) {
            return;
        }
        int n = this.mRepeatCount <= 1 ? 1 : this.mRepeatCount;
        for (int i = 0; i < n; ++i) {
            this.processOnce(imageData);
        }
    }

    private void processOnce(ImageData imageData) {
        int n = imageData.width;
        int n2 = imageData.height;
        int[] nArray = imageData.pixels;
        int[] nArray2 = imageData.getBackPixels();
        for (int i = 0; i <= n2 - 1; ++i) {
            for (int j = 0; j <= n - 1; ++j) {
                int n3 = i * n + j;
                nArray2[n3] = this.processPerPixel(nArray, j, i, n, n2);
            }
        }
        imageData.swapPixels();
    }

    private int processPerPixel(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = (this.mMatrixSideLength - 1) / 2;
        int n14 = 0;
        for (n8 = -n13; n8 <= n13; ++n8) {
            for (n7 = -n13; n7 <= n13; ++n7) {
                n6 = this.mMatrix[n14];
                n5 = ConvolutionFilter.getColor(nArray, n + n7, n2 + n8, n3, n4);
                if (this.mIsFilterR) {
                    n9 += n6 * (n5 >>> 16 & 0xFF);
                }
                if (this.mIsFilterG) {
                    n10 += n6 * (n5 >>> 8 & 0xFF);
                }
                if (this.mIsFilterB) {
                    n11 += n6 * (n5 & 0xFF);
                }
                if (this.mIsFilterA) {
                    n12 += n6 * (n5 >>> 24 & 0xFF);
                }
                ++n14;
            }
        }
        n8 = ConvolutionFilter.getColor(nArray, n, n2, n3, n4);
        n7 = this.mIsFilterR ? ImageFilterUtils.clamp(0, n9 / this.mDivisor + this.mBias, 255) : n8 >>> 16 & 0xFF;
        n6 = this.mIsFilterG ? ImageFilterUtils.clamp(0, n10 / this.mDivisor + this.mBias, 255) : n8 >>> 8 & 0xFF;
        n5 = this.mIsFilterB ? ImageFilterUtils.clamp(0, n11 / this.mDivisor + this.mBias, 255) : n8 & 0xFF;
        int n15 = this.mIsFilterA ? ImageFilterUtils.clamp(0, n12 / this.mDivisor + this.mBias, 255) : n8 >>> 24 & 0xFF;
        return n15 << 24 | n7 << 16 | n6 << 8 | n5;
    }

    private static final int getColor(int[] nArray, int n, int n2, int n3, int n4) {
        n = ImageFilterUtils.clamp(0, n, n3 - 1);
        n2 = ImageFilterUtils.clamp(0, n2, n4 - 1);
        return nArray[n2 * n3 + n];
    }
}

