/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.text.TextUtils;
import android.util.FloatMath;
import android.util.Log;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.Map;
import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class BlendImageFilter
extends IImageFilter.AbstractImageFilter {
    static final String TAG = "BlendImageFilter";
    static final int BLEND_TYPE_NORMAL = 0;
    static final int BLEND_TYPE_MULTIPLY = 1;
    static final int BLEND_TYPE_SCREEN = 2;
    static final int BLEND_TYPE_DARKEN = 3;
    static final int BLEND_TYPE_LIGHTEN = 4;
    static final int BLEND_TYPE_DIFFERENCE = 5;
    static final int BLEND_TYPE_LINEAR_DODGE = 6;
    static final int BLEND_TYPE_LINEAR_BURN = 7;
    static final int BLEND_TYPE_OVERLAY = 8;
    static final int BLEND_TYPE_COLOR_DODGE = 9;
    static final int BLEND_TYPE_COLOR_BURN = 10;
    static final int BLEND_TYPE_OPACITY = 11;
    static final int BLEND_TYPE_HARD_LIGHT = 12;
    static final int BLEND_TYPE_SOFT_LIGHT = 13;
    static final int BLEND_TYPE_VIVID_LIGHT = 14;
    static final int BLEND_TYPE_LINEAR_LIGHT = 15;
    static final int BLEND_TYPE_PIN_LIGHT = 16;
    static final int BLEND_TYPE_HARD_MIX = 17;
    static final int BLEND_TYPE_EXCLUSION = 18;
    static final int BLEND_TYPE_HUE = 19;
    static final int BLEND_TYPE_SATURATION = 20;
    static final int BLEND_TYPE_COLOR = 21;
    static final int BLEND_TYPE_LUMINOSITY = 22;
    static final int BLEND_TYPE_DIVIDE = 23;
    static final int BLEND_TYPE_SUBTRACT = 24;
    private ImageData mInputImage;
    private IImageFilter.ImageFilterGroup mInputFilters;
    private int mBlendType = 0;
    private boolean mIsInputImageOnTop = true;
    private PorterDuff.Mode mPorterDuffMode = PorterDuff.Mode.SRC_ATOP;
    private boolean mUseOriginalImage;
    private SoftReference<Map.Entry<Integer, ImageData>> mInputImageCache;

    public void setBlendType(int n) {
        this.mBlendType = n;
    }

    public void setIsInputImageOnTop(boolean bl) {
        this.mIsInputImageOnTop = bl;
    }

    public void setPorterDuffMode(PorterDuff.Mode mode) {
        this.mPorterDuffMode = mode;
    }

    public void setBlendTypeName(String string) {
        if (TextUtils.isEmpty(string) || string.equalsIgnoreCase("Normal")) {
            this.mBlendType = 0;
        } else if (string.equalsIgnoreCase("Multiply")) {
            this.mBlendType = 1;
        } else if (string.equalsIgnoreCase("Screen")) {
            this.mBlendType = 2;
        } else if (string.equalsIgnoreCase("Darken")) {
            this.mBlendType = 3;
        } else if (string.equalsIgnoreCase("Lighten")) {
            this.mBlendType = 4;
        } else if (string.equalsIgnoreCase("Difference")) {
            this.mBlendType = 5;
        } else if (string.equalsIgnoreCase("LinearDodge")) {
            this.mBlendType = 6;
        } else if (string.equalsIgnoreCase("LinearBurn")) {
            this.mBlendType = 7;
        } else if (string.equalsIgnoreCase("Overlay")) {
            this.mBlendType = 8;
        } else if (string.equalsIgnoreCase("ColorDodge")) {
            this.mBlendType = 9;
        } else if (string.equalsIgnoreCase("ColorBurn")) {
            this.mBlendType = 10;
        } else if (string.equalsIgnoreCase("Opacity")) {
            this.mBlendType = 11;
        } else if (string.equalsIgnoreCase("HardLight")) {
            this.mBlendType = 12;
        } else if (string.equalsIgnoreCase("SoftLight")) {
            this.mBlendType = 13;
        } else if (string.equalsIgnoreCase("VividLight")) {
            this.mBlendType = 14;
        } else if (string.equalsIgnoreCase("LinearLight")) {
            this.mBlendType = 15;
        } else if (string.equalsIgnoreCase("PinLight")) {
            this.mBlendType = 16;
        } else if (string.equalsIgnoreCase("HardMix")) {
            this.mBlendType = 17;
        } else if (string.equalsIgnoreCase("Exclusion")) {
            this.mBlendType = 18;
        } else if (string.equalsIgnoreCase("Hue")) {
            this.mBlendType = 19;
        } else if (string.equalsIgnoreCase("Saturation")) {
            this.mBlendType = 20;
        } else if (string.equalsIgnoreCase("Color")) {
            this.mBlendType = 21;
        } else if (string.equalsIgnoreCase("Luminosity")) {
            this.mBlendType = 22;
        } else if (string.equalsIgnoreCase("Divide")) {
            this.mBlendType = 23;
        } else if (string.equalsIgnoreCase("Subtract")) {
            this.mBlendType = 24;
        } else {
            Log.d(TAG, "unknown blend type name: " + string);
        }
    }

    public void setInputImage(Bitmap bitmap) {
        this.mInputImage = ImageData.bitmapToImageData(bitmap);
        this.mInputImageCache = null;
    }

    public void setInputFilters(IImageFilter.ImageFilterGroup imageFilterGroup) {
        this.mUseOriginalImage = true;
        this.mInputFilters = imageFilterGroup;
    }

    public void setUseOriginalImage(boolean bl) {
        this.mUseOriginalImage = bl;
    }

    @Override
    public void putOriginalImage(Bitmap bitmap) {
        if (!this.mUseOriginalImage) {
            return;
        }
        this.mInputImage = this.mInputFilters != null ? this.mInputFilters.processAll(bitmap) : ImageData.bitmapToImageData(bitmap);
        this.mInputImageCache = null;
    }

    @Override
    public boolean canConcurrence() {
        if (this.mUseOriginalImage) {
            return false;
        }
        return super.canConcurrence();
    }

    @Override
    public void processData(ImageData imageData) {
        int[] nArray;
        if (this.mInputImage == null) {
            return;
        }
        Blender blender = this.getCurrentBlender();
        if (blender == null) {
            return;
        }
        PorterDuffBlender porterDuffBlender = this.getCurrentPorterDuffBlender();
        if (porterDuffBlender == null) {
            return;
        }
        int n = imageData.width;
        int n2 = imageData.height;
        int[] nArray2 = nArray = imageData.pixels;
        int[] nArray3 = this.obtainInputImageBySize((int)n, (int)n2).pixels;
        if (!this.mIsInputImageOnTop) {
            nArray2 = nArray3;
            nArray3 = nArray;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = j * n + i;
                int n4 = nArray2[n3];
                int n5 = nArray3[n3];
                int n6 = blender.blendColor(n4, n5);
                nArray[n3] = porterDuffBlender.blendFinal(n4, n6);
            }
        }
    }

    private ImageData obtainInputImageBySize(int n, int n2) {
        Map.Entry<Integer, ImageData> entry;
        int n3 = this.mergeWidthHeight(n, n2);
        Map.Entry<Integer, ImageData> entry2 = entry = this.mInputImageCache == null ? null : this.mInputImageCache.get();
        if (entry != null && entry.getKey() == n3) {
            return entry.getValue();
        }
        int n4 = this.mergeWidthHeight(this.mInputImage.width, this.mInputImage.height);
        if (n4 == n3) {
            return this.mInputImage;
        }
        Bitmap bitmap = ImageData.imageDataToBitmap(this.mInputImage);
        Bitmap bitmap2 = Bitmap.createScaledBitmap(bitmap, n, n2, true);
        ImageData imageData = ImageData.bitmapToImageData(bitmap2);
        this.mInputImageCache = new SoftReference<AbstractMap.SimpleImmutableEntry<Integer, ImageData>>(new AbstractMap.SimpleImmutableEntry<Integer, ImageData>(n3, imageData));
        return imageData;
    }

    private int mergeWidthHeight(int n, int n2) {
        if (n > Short.MAX_VALUE || n2 > Short.MAX_VALUE) {
            throw new RuntimeException("image's width or height to large:" + n + "x" + n2);
        }
        return n << 16 | n2;
    }

    private Blender getCurrentBlender() {
        switch (this.mBlendType) {
            case 0: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return f2;
                    }
                };
            }
            case 1: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return f * f2;
                    }
                };
            }
            case 2: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return 1.0f - (1.0f - f) * (1.0f - f2);
                    }
                };
            }
            case 8: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        if (f < 0.5f) {
                            return 2.0f * f * f2;
                        }
                        return 1.0f - 2.0f * (1.0f - f) * (1.0f - f2);
                    }
                };
            }
            case 13: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        if (f2 < 0.5f) {
                            return 2.0f * f * f2 + f * f * (1.0f - 2.0f * f2);
                        }
                        return 2.0f * f * (1.0f - f2) + FloatMath.sqrt(f) * (2.0f * f2 - 1.0f);
                    }
                };
            }
            case 12: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        if (f2 < 0.5f) {
                            return 2.0f * f * f2;
                        }
                        return 1.0f - 2.0f * (1.0f - f) * (1.0f - f2);
                    }
                };
            }
            case 9: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return f / (1.0f - f2);
                    }
                };
            }
            case 6: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return f2 + f;
                    }
                };
            }
            case 10: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return 1.0f - (1.0f - f) / f2;
                    }
                };
            }
            case 7: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return f2 + f - 1.0f;
                    }
                };
            }
            case 14: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        if (f2 <= 0.5f) {
                            return 1.0f - (1.0f - f) / (2.0f * f2);
                        }
                        return f / (2.0f * (1.0f - f2));
                    }
                };
            }
            case 15: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return f + 2.0f * f2 - 1.0f;
                    }
                };
            }
            case 23: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return f / f2;
                    }
                };
            }
            case 24: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return f - f2;
                    }
                };
            }
            case 5: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return Math.abs(f - f2);
                    }
                };
            }
            case 3: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return Math.min(f, f2);
                    }
                };
            }
            case 4: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return Math.max(f, f2);
                    }
                };
            }
            case 16: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        if (f < 2.0f * f2 - 1.0f) {
                            return 2.0f * f2 - 1.0f;
                        }
                        if (f < 2.0f * f2) {
                            return f;
                        }
                        return 2.0f * f2;
                    }
                };
            }
            case 17: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        if (f2 < 1.0f - f) {
                            return 0.0f;
                        }
                        return 1.0f;
                    }
                };
            }
            case 18: {
                return new BlenderPerChannel(){

                    @Override
                    public float blendChannel(float f, float f2) {
                        return f2 + f - 2.0f * f2 * f;
                    }
                };
            }
            case 19: {
                return new Blender(){

                    @Override
                    public int blendColor(int n, int n2) {
                        float[] fArray = new float[3];
                        float[] fArray2 = new float[3];
                        ImageFilterUtils.RgbToHsl(n2, fArray);
                        ImageFilterUtils.RgbToHsl(n, fArray2);
                        int n3 = ImageFilterUtils.HslToRgb(fArray[0], fArray2[1], fArray2[2]);
                        return n2 & 0xFF000000 | n3 & 0xFFFFFF;
                    }
                };
            }
            case 20: {
                return new Blender(){

                    @Override
                    public int blendColor(int n, int n2) {
                        float[] fArray = new float[3];
                        float[] fArray2 = new float[3];
                        ImageFilterUtils.RgbToHsl(n2, fArray);
                        ImageFilterUtils.RgbToHsl(n, fArray2);
                        int n3 = ImageFilterUtils.HslToRgb(fArray2[0], fArray[1], fArray2[2]);
                        return n2 & 0xFF000000 | n3 & 0xFFFFFF;
                    }
                };
            }
            case 21: {
                return new Blender(){

                    @Override
                    public int blendColor(int n, int n2) {
                        float[] fArray = new float[3];
                        float[] fArray2 = new float[3];
                        ImageFilterUtils.RgbToHsl(n2, fArray);
                        ImageFilterUtils.RgbToHsl(n, fArray2);
                        int n3 = ImageFilterUtils.HslToRgb(fArray[0], fArray[1], fArray2[2]);
                        return n2 & 0xFF000000 | n3 & 0xFFFFFF;
                    }
                };
            }
            case 22: {
                return new Blender(){

                    @Override
                    public int blendColor(int n, int n2) {
                        float[] fArray = new float[3];
                        float[] fArray2 = new float[3];
                        ImageFilterUtils.RgbToHsl(n2, fArray);
                        ImageFilterUtils.RgbToHsl(n, fArray2);
                        int n3 = ImageFilterUtils.HslToRgb(fArray2[0], fArray2[1], fArray[2]);
                        return n2 & 0xFF000000 | n3 & 0xFFFFFF;
                    }
                };
            }
            case 11: {
                return new Blender(){

                    @Override
                    public int blendColor(int n, int n2) {
                        int n3 = n2 >>> 24 & 0xFF;
                        int n4 = n2 >>> 16 & 0xFF;
                        int n5 = n2 >>> 8 & 0xFF;
                        int n6 = n2 & 0xFF;
                        int n7 = n >>> 16 & 0xFF;
                        int n8 = n >>> 8 & 0xFF;
                        int n9 = n & 0xFF;
                        int n10 = (int)(ImageFilterUtils.clamp(0.0f, this.blendChannel((float)n7 / 255.0f, (float)n4 / 255.0f, (float)n3 / 255.0f), 1.0f) * 255.0f);
                        int n11 = (int)(ImageFilterUtils.clamp(0.0f, this.blendChannel((float)n8 / 255.0f, (float)n5 / 255.0f, (float)n3 / 255.0f), 1.0f) * 255.0f);
                        int n12 = (int)(ImageFilterUtils.clamp(0.0f, this.blendChannel((float)n9 / 255.0f, (float)n6 / 255.0f, (float)n3 / 255.0f), 1.0f) * 255.0f);
                        return n2 & 0xFF000000 | n10 << 16 | n11 << 8 | n12;
                    }

                    private float blendChannel(float f, float f2, float f3) {
                        return f3 * f2 + (1.0f - f3) * f;
                    }
                };
            }
        }
        Log.w(TAG, "unknown blender type:" + this.mBlendType);
        return null;
    }

    private PorterDuffBlender getCurrentPorterDuffBlender() {
        switch (this.mPorterDuffMode) {
            case CLEAR: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return 0.0f;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return 0.0f;
                    }
                };
            }
            case DST: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f;
                    }
                };
            }
            case DST_ATOP: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f2;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f4 * f + f2 * (1.0f - f3);
                    }
                };
            }
            case DST_IN: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f2 * f;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f4 * f;
                    }
                };
            }
            case DST_OUT: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f * (1.0f - f2);
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f * (1.0f - f4);
                    }
                };
            }
            case DST_OVER: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f2 + (1.0f - f2) * f;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f + (1.0f - f3) * f2;
                    }
                };
            }
            case SRC: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f2;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f2;
                    }
                };
            }
            case SRC_ATOP: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f2 * f3 + (1.0f - f4) * f;
                    }
                };
            }
            case SRC_IN: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f2 * f;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f2 * f3;
                    }
                };
            }
            case SRC_OUT: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f2 * (1.0f - f);
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f2 * (1.0f - f3);
                    }
                };
            }
            case SRC_OVER: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f2 + (1.0f - f2) * f;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f2 + (1.0f - f4) * f;
                    }
                };
            }
            case XOR: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f2 + f - 2.0f * f2 * f;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f2 * (1.0f - f3) + (1.0f - f4) * f;
                    }
                };
            }
            case SCREEN: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f2 + f - f2 * f;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f2 + f - f2 * f / 255.0f;
                    }
                };
            }
            case LIGHTEN: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f2 + f - f2 * f;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f2 * (1.0f - f3) + f * (1.0f - f4) + Math.max(f2, f);
                    }
                };
            }
            case DARKEN: {
                return new PorterDuffBlenderPerChannel(){

                    @Override
                    public float blendAlpha(float f, float f2) {
                        return f2 + f - f2 * f;
                    }

                    @Override
                    public float blendChannel(float f, float f2, float f3, float f4) {
                        return f2 * (1.0f - f3) + f * (1.0f - f4) + Math.min(f2, f);
                    }
                };
            }
        }
        Log.w(TAG, "unsupport porter duff mode:" + (Object)((Object)this.mPorterDuffMode));
        return null;
    }

    abstract class PorterDuffBlenderPerChannel
    extends PorterDuffBlender {
        PorterDuffBlenderPerChannel() {
        }

        @Override
        public int blendFinal(int n, int n2) {
            int n3 = n2 >>> 24 & 0xFF;
            int n4 = (n2 >>> 16 & 0xFF) * n3;
            int n5 = (n2 >>> 8 & 0xFF) * n3;
            int n6 = (n2 & 0xFF) * n3;
            int n7 = n >>> 24 & 0xFF;
            int n8 = (n >>> 16 & 0xFF) * n7;
            int n9 = (n >>> 8 & 0xFF) * n7;
            int n10 = (n & 0xFF) * n7;
            float f = (float)n7 / 255.0f;
            float f2 = (float)n3 / 255.0f;
            int n11 = (int)(ImageFilterUtils.clamp(0.0f, this.blendAlpha(f, f2), 1.0f) * 255.0f);
            int n12 = n11 == 0 ? 0 : (int)ImageFilterUtils.clamp(0.0f, this.blendChannel(n8, n4, f, f2) / (float)n11, 255.0f);
            int n13 = n11 == 0 ? 0 : (int)ImageFilterUtils.clamp(0.0f, this.blendChannel(n9, n5, f, f2) / (float)n11, 255.0f);
            int n14 = n11 == 0 ? 0 : (int)ImageFilterUtils.clamp(0.0f, this.blendChannel(n10, n6, f, f2) / (float)n11, 255.0f);
            return n11 << 24 | n12 << 16 | n13 << 8 | n14;
        }

        public abstract float blendAlpha(float var1, float var2);

        public abstract float blendChannel(float var1, float var2, float var3, float var4);
    }

    abstract class PorterDuffBlender {
        PorterDuffBlender() {
        }

        public abstract int blendFinal(int var1, int var2);
    }

    abstract class BlenderPerChannel
    extends Blender {
        BlenderPerChannel() {
        }

        @Override
        public int blendColor(int n, int n2) {
            int n3 = n2 >>> 16 & 0xFF;
            int n4 = n2 >>> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            int n6 = n >>> 16 & 0xFF;
            int n7 = n >>> 8 & 0xFF;
            int n8 = n & 0xFF;
            int n9 = (int)(ImageFilterUtils.clamp(0.0f, this.blendChannel((float)n6 / 255.0f, (float)n3 / 255.0f), 1.0f) * 255.0f);
            int n10 = (int)(ImageFilterUtils.clamp(0.0f, this.blendChannel((float)n7 / 255.0f, (float)n4 / 255.0f), 1.0f) * 255.0f);
            int n11 = (int)(ImageFilterUtils.clamp(0.0f, this.blendChannel((float)n8 / 255.0f, (float)n5 / 255.0f), 1.0f) * 255.0f);
            return n2 & 0xFF000000 | n9 << 16 | n10 << 8 | n11;
        }

        public abstract float blendChannel(float var1, float var2);
    }

    abstract class Blender {
        Blender() {
        }

        public abstract int blendColor(int var1, int var2);
    }
}

