/*
 * Decompiled with CFR 0.152.
 */
package miui.content.res;

import android.text.TextUtils;
import android.util.Log;
import com.miui.theme.tool.icon.TransformFilter;
import com.miui.theme.tool.util.ConfigUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import miui.content.res.IconConfig;
import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageFilterBuilder;
import miui.imagefilters.TFilter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IconCustomizer {
    private static final String LOG_TAG = "IconCustomizer";
    public static final int sCustomizedIconWidth = IconCustomizer.getIconSize();
    private static final String ICON_TRANSFORM_CONFIG = "transform_config.xml";
    private static boolean sIconTransformNeeded = false;

    private static int getIconSize() {
        return 90;
    }

    public static float hdpiIconSizeToCurrent(float f) {
        BigDecimal bigDecimal = new BigDecimal(f * (float)sCustomizedIconWidth / 90.0f);
        return bigDecimal.setScale(1, 4).floatValue();
    }

    public static int hdpiIconSizeToCurrent(int n) {
        return (int)((float)(n * sCustomizedIconWidth) / 90.0f + 0.5f);
    }

    public static double hdpiIconSizeToCurrent(double d) {
        return d * (double)sCustomizedIconWidth / 90.0;
    }

    public static Object getRawIcon(String string) {
        return null;
    }

    public static IconConfig loadIconConfig() {
        Object object;
        IconConfig iconConfig = new IconConfig();
        InputStream inputStream = IconCustomizer.getIconConfigStream(ICON_TRANSFORM_CONFIG);
        if (inputStream == null) {
            Log.w(LOG_TAG, "can't load transform_config.xml");
            return iconConfig;
        }
        Element element = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            element = ((DocumentBuilder)object).parse(inputStream).getDocumentElement();
        }
        catch (Exception exception) {
            Log.w(LOG_TAG, "load icon config failed.", exception);
            return iconConfig;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return iconConfig;
        }
        if (element != null) {
            object = element.getChildNodes();
            try {
                for (int i = 0; i < object.getLength(); ++i) {
                    Object object2;
                    Object object3;
                    if (object.item(i).getNodeType() != 1) continue;
                    Element element2 = (Element)object.item(i);
                    String string = element2.getTagName();
                    if ("IconFilters".equals(string)) {
                        iconConfig.mIconFilters = IconCustomizer.loadIconFilters(element2.getChildNodes());
                        iconConfig.mFilterList = IconCustomizer.loadIconFilter(element2.getChildNodes());
                        continue;
                    }
                    if ("PointsMapping".equals(string)) {
                        int n;
                        object3 = element2.getChildNodes();
                        object2 = new ArrayList();
                        ArrayList<Float> arrayList = new ArrayList<Float>();
                        for (n = 0; n < object3.getLength(); ++n) {
                            Element element3;
                            if (object3.item(n).getNodeType() != 1 || !"Point".equals((element3 = (Element)object3.item(n)).getNodeName())) continue;
                            object2.add(Float.valueOf(Float.parseFloat(element3.getAttribute("fromX"))));
                            object2.add(Float.valueOf(Float.parseFloat(element3.getAttribute("fromY"))));
                            arrayList.add(Float.valueOf(Float.parseFloat(element3.getAttribute("toX"))));
                            arrayList.add(Float.valueOf(Float.parseFloat(element3.getAttribute("toY"))));
                        }
                        n = object2.size();
                        iconConfig.mPointsMappingFrom = object2;
                        iconConfig.mPointsMappingTo = arrayList;
                        continue;
                    }
                    if ("Config".equals(string)) {
                        object3 = element2.getAttribute("name");
                        object2 = element2.getAttribute("value");
                        if (!"UseModIcon".equalsIgnoreCase((String)object3)) continue;
                        iconConfig.mUseModIcon = Boolean.parseBoolean((String)object2);
                        continue;
                    }
                    if ("ScaleX".equals(string)) {
                        iconConfig.mScaleX = Float.parseFloat(element2.getAttribute("value"));
                        continue;
                    }
                    if ("ScaleY".equals(string)) {
                        iconConfig.mScaleY = Float.parseFloat(element2.getAttribute("value"));
                        continue;
                    }
                    if ("SkewX".equals(string)) {
                        iconConfig.mSkewX = Float.parseFloat(element2.getAttribute("value"));
                        continue;
                    }
                    if ("SkewY".equals(string)) {
                        iconConfig.mSkewY = Float.parseFloat(element2.getAttribute("value"));
                        continue;
                    }
                    if ("TransX".equals(string)) {
                        iconConfig.mTransX = IconCustomizer.hdpiIconSizeToCurrent(Float.parseFloat(element2.getAttribute("value")));
                        continue;
                    }
                    if ("TransY".equals(string)) {
                        iconConfig.mTransY = IconCustomizer.hdpiIconSizeToCurrent(Float.parseFloat(element2.getAttribute("value")));
                        continue;
                    }
                    if ("RotateX".equals(string)) {
                        iconConfig.mRotateX = Float.parseFloat(element2.getAttribute("value"));
                        continue;
                    }
                    if ("RotateY".equals(string)) {
                        iconConfig.mRotateY = Float.parseFloat(element2.getAttribute("value"));
                        continue;
                    }
                    if ("RotateZ".equals(string)) {
                        iconConfig.mRotateZ = Float.parseFloat(element2.getAttribute("value"));
                        continue;
                    }
                    if ("CameraX".equals(string)) {
                        iconConfig.mCameraX = IconCustomizer.hdpiIconSizeToCurrent(Float.parseFloat(element2.getAttribute("value")));
                        continue;
                    }
                    if (!"CameraY".equals(string)) continue;
                    iconConfig.mCameraY = IconCustomizer.hdpiIconSizeToCurrent(Float.parseFloat(element2.getAttribute("value")));
                }
                sIconTransformNeeded = true;
            }
            catch (Exception exception) {
                Log.w(LOG_TAG, "transform_config.xml parse failed.", exception);
            }
        }
        return iconConfig;
    }

    private static InputStream getIconConfigStream(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(ConfigUtil.getThemePath() + File.separator + "icons" + File.separator + string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return fileInputStream;
    }

    private static List<TFilter> loadIconFilter(NodeList nodeList) {
        ArrayList<TFilter> arrayList = new ArrayList<TFilter>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            String string;
            if (nodeList.item(i).getNodeType() != 1 || !"Filter".equals(string = (element = (Element)nodeList.item(i)).getTagName())) continue;
            TFilter tFilter = new TFilter();
            NodeList nodeList2 = element.getChildNodes();
            tFilter.mName = element.getAttribute("name");
            ArrayList<Map.Entry<String, String>> arrayList2 = new ArrayList<Map.Entry<String, String>>();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2;
                if (nodeList2.item(j).getNodeType() != 1 || !"Param".equals((element2 = (Element)nodeList2.item(j)).getNodeName())) continue;
                AbstractMap.SimpleEntry<String, String> simpleEntry = new AbstractMap.SimpleEntry<String, String>(element2.getAttribute("name"), element2.getAttribute("value"));
                arrayList2.add(simpleEntry);
            }
            tFilter.mParamEntrys = arrayList2;
            arrayList.add(tFilter);
        }
        return arrayList;
    }

    private static IImageFilter.ImageFilterGroup loadIconFilters(NodeList nodeList) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            if (nodeList.item(i).getNodeType() != 1) continue;
            ImageFilterBuilder imageFilterBuilder = new ImageFilterBuilder();
            Element element = (Element)nodeList.item(i);
            String string = element.getTagName();
            if (!"Filter".equals(string)) continue;
            NodeList nodeList2 = element.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Object object2;
                Object object3;
                if (nodeList2.item(j).getNodeType() != 1 || !"Param".equals((object = (Element)nodeList2.item(j)).getNodeName())) continue;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                String string2 = object.getAttribute("ignoreWhenNotSupported");
                if (object.hasChildNodes()) {
                    object3 = object.getChildNodes();
                    for (int k = 0; k < object3.getLength(); ++k) {
                        if (object3.item(k).getNodeType() != 1 || !"IconFilters".equals((object2 = (Element)object3.item(k)).getTagName())) continue;
                        arrayList2.add(IconCustomizer.loadIconFilters(object2.getChildNodes()));
                    }
                }
                if (arrayList2.size() == 0) {
                    object3 = object.getAttribute("value");
                    String[] stringArray = ((String)object3).split("\\|");
                    object2 = stringArray;
                    int n = ((String[])object2).length;
                    for (int k = 0; k < n; ++k) {
                        Object object4 = object2[k];
                        if (TextUtils.isEmpty((CharSequence)object4)) continue;
                        arrayList2.add(object4);
                    }
                }
                imageFilterBuilder.addParam(object.getAttribute("name"), arrayList2, TextUtils.isEmpty(string2) ? false : Boolean.TRUE.toString().equalsIgnoreCase(string2));
            }
            imageFilterBuilder.setFilterName(element.getAttribute("name"));
            String string3 = element.getAttribute("ignoreWhenNotSupported");
            imageFilterBuilder.setIgnoreWhenNotSupported(TextUtils.isEmpty(string3) ? false : Boolean.TRUE.toString().equalsIgnoreCase(string3));
            try {
                object = imageFilterBuilder.createImageFilter();
                if (object == null) continue;
                arrayList.add(object);
                continue;
            }
            catch (ImageFilterBuilder.NoSupportException noSupportException) {
                noSupportException.printStackTrace();
                arrayList.clear();
                break;
            }
        }
        return new IImageFilter.ImageFilterGroup(arrayList.toArray(new IImageFilter[0]));
    }

    public static IImageFilter.ImageFilterGroup tFilterListToImageFilterGroup(List<TFilter> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (TFilter tFilter : list) {
            ImageFilterBuilder imageFilterBuilder = new ImageFilterBuilder();
            if (tFilter.mParamEntrys != null) {
                for (Map.Entry<String, String> entry : tFilter.mParamEntrys) {
                    String[] stringArray;
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    String string = entry.getValue();
                    for (String string2 : stringArray = string.split("\\|")) {
                        if (TextUtils.isEmpty(string2)) continue;
                        arrayList2.add(string2);
                    }
                    imageFilterBuilder.addParam(entry.getKey(), arrayList2, false);
                }
            }
            imageFilterBuilder.setFilterName(tFilter.mName);
            imageFilterBuilder.setIgnoreWhenNotSupported(false);
            try {
                IImageFilter iImageFilter = imageFilterBuilder.createImageFilter();
                if (iImageFilter == null) continue;
                arrayList.add(iImageFilter);
            }
            catch (ImageFilterBuilder.NoSupportException noSupportException) {
                noSupportException.printStackTrace();
                arrayList.clear();
                break;
            }
        }
        return new IImageFilter.ImageFilterGroup(arrayList.toArray(new IImageFilter[0]));
    }

    public static void save(IconConfig iconConfig) {
        TransformFilter transformFilter = new TransformFilter(new File(ConfigUtil.getThemePath() + File.separator + "icons" + File.separator + ICON_TRANSFORM_CONFIG));
        transformFilter.mPointsMappingFrom = iconConfig.mPointsMappingFrom;
        transformFilter.mPointsMappingTo = iconConfig.mPointsMappingTo;
        transformFilter.mFilters = iconConfig.mFilterList;
        transformFilter.save();
    }
}

