/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ImageSelection;
import com.miui.theme.tool.util.Log;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class Screenshot {
    public static float sScreenshotQuality = 0.85f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            Screenshot.printUsageAndQuit();
        }
        int n = 0;
        do {
            if ("-d".equals(string = stringArray[n++])) {
                if (bl2 || string2 != null) {
                    Screenshot.printAndExit("-d conflicts with -e and -s", false);
                }
                bl = true;
                continue;
            }
            if ("-e".equals(string)) {
                if (bl || string2 != null) {
                    Screenshot.printAndExit("-e conflicts with -d and -s", false);
                }
                bl2 = true;
                continue;
            }
            if ("-s".equals(string)) {
                if (n == stringArray.length) {
                    Screenshot.printAndExit("Missing serial number after -s", false);
                }
                if (bl || bl2) {
                    Screenshot.printAndExit("-s conflicts with -d and -e", false);
                }
                string2 = stringArray[n++];
                continue;
            }
            if ("-l".equals(string)) {
                bl3 = true;
                continue;
            }
            string3 = string;
            if (n >= stringArray.length) continue;
            Screenshot.printAndExit("Too many arguments!", false);
        } while (n < stringArray.length);
        if (string3 == null) {
            Screenshot.printUsageAndQuit();
        }
        com.android.ddmlib.Log.setLogOutput((Log.ILogOutput)new Log.ILogOutput(){

            public void printAndPromptLog(Log.LogLevel logLevel, String string, String string2) {
                System.err.println(logLevel.getStringValue() + ":" + string + ":" + string2);
            }

            public void printLog(Log.LogLevel logLevel, String string, String string2) {
                System.err.println(logLevel.getStringValue() + ":" + string + ":" + string2);
            }
        });
        AndroidDebugBridge.init((boolean)false);
        try {
            string = AndroidDebugBridge.createBridge();
            int n2 = 0;
            while (!string.hasInitialDeviceList()) {
                try {
                    Thread.sleep(100L);
                    ++n2;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n2 <= 100) continue;
                Screenshot.printAndExit("Timeout getting device list!", true);
                return;
            }
            IDevice[] iDeviceArray = string.getDevices();
            if (iDeviceArray.length == 0) {
                Screenshot.printAndExit("No devices found!", true);
            }
            IDevice iDevice = null;
            if (bl2 || bl) {
                for (IDevice iDevice2 : iDeviceArray) {
                    if (iDevice2.isEmulator() != bl2) continue;
                    if (iDevice != null) {
                        if (bl2) {
                            Screenshot.printAndExit("Error: more than one emulator launched!", true);
                        } else {
                            Screenshot.printAndExit("Error: more than one device connected!", true);
                        }
                    }
                    iDevice = iDevice2;
                }
            } else if (string2 != null) {
                for (IDevice iDevice3 : iDeviceArray) {
                    if (!string2.equals(iDevice3.getSerialNumber())) continue;
                    iDevice = iDevice3;
                    break;
                }
            } else {
                if (iDeviceArray.length > 1) {
                    Screenshot.printAndExit("Error: more than one emulator or device available!", true);
                }
                iDevice = iDeviceArray[0];
            }
            if (iDevice != null) {
                try {
                    System.out.println("Taking screenshot from: " + iDevice.getSerialNumber());
                    Screenshot.getDeviceImage(iDevice, string3, bl3);
                    System.out.println("Success.");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                Screenshot.printAndExit("Could not find matching device/emulator.", true);
            }
        }
        finally {
            AndroidDebugBridge.terminate();
        }
    }

    public static void captureScreen(String string) throws Exception {
        String string2 = ThemeHelper.getUserDir();
        string2 = OS.getOS() == 1 ? string2 + File.separator + "tools" + File.separator + "adb.exe" : (OS.getOS() == 3 ? string2 + File.separator + "tools" + File.separator + "adb-mac" : string2 + File.separator + "tools" + File.separator + "adb");
        AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.createBridge((String)string2, (boolean)false);
        int n = 0;
        while (!androidDebugBridge.hasInitialDeviceList()) {
            try {
                Thread.sleep(100L);
                ++n;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n <= 100) continue;
            Screenshot.printAndExit("Timeout getting device list!", true);
            return;
        }
        IDevice[] iDeviceArray = androidDebugBridge.getDevices();
        if (iDeviceArray.length == 0) {
            Screenshot.printAndExit("No devices found!", true);
        }
        IDevice iDevice = null;
        for (IDevice iDevice2 : iDeviceArray) {
            if (iDevice2.isEmulator()) continue;
            if (iDevice != null) {
                Screenshot.printAndExit("Error: more than one device connected!", true);
            }
            iDevice = iDevice2;
        }
        if (iDevice != null) {
            try {
                System.out.println("Taking screenshot from: " + iDevice.getSerialNumber());
                Screenshot.getDeviceImage(iDevice, string, false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            Screenshot.printAndExit("Could not find matching device/emulator.", true);
        }
    }

    public static void getDeviceImage(IDevice iDevice, String string, boolean bl) throws Exception {
        RawImage rawImage;
        try {
            rawImage = iDevice.getScreenshot();
        }
        catch (IOException iOException) {
            Screenshot.printAndExit("Unable to get frame buffer: " + iOException.getMessage(), true);
            return;
        }
        if (rawImage == null) {
            return;
        }
        if (bl) {
            rawImage = rawImage.getRotated();
        }
        BufferedImage bufferedImage = new BufferedImage(rawImage.width, rawImage.height, 1);
        int n = 0;
        int n2 = rawImage.bpp >> 3;
        for (int i = 0; i < rawImage.height; ++i) {
            for (int j = 0; j < rawImage.width; ++j) {
                int n3 = rawImage.getARGB(n);
                n += n2;
                bufferedImage.setRGB(j, i, n3);
            }
        }
        GUIUtil.saveImage(bufferedImage, new File(string), sScreenshotQuality);
        ImageSelection imageSelection = new ImageSelection(bufferedImage);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
    }

    private static void printUsageAndQuit() {
        System.out.println("Usage: screenshot [-d | -e | -s SERIAL] [-l] OUT_FILE");
        System.out.println("");
        System.out.println("    -d      Uses the first device found.");
        System.out.println("    -e      Uses the first emulator found.");
        System.out.println("    -s      Targets the device by serial number.");
        System.out.println("");
        System.out.println("    -l      Rotate images for landscape mode.");
        System.out.println("");
        System.exit(1);
    }

    private static void printAndExit(String string, boolean bl) throws Exception {
        Log.l(string);
        if (bl) {
            // empty if block
        }
        throw new Exception(string);
    }
}

