/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class JPEGOutputUtil {
    private JPEGOutputUtil() {
    }

    public static boolean writeJPEGImageStream(OutputStream outputStream, RenderedImage renderedImage) {
        try {
            JPEGOutputUtil.compressJpegStream(outputStream, renderedImage, 1.0f);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public static void compressJpegFile(File file, RenderedImage renderedImage, float f) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JPEGOutputUtil.compressJpegStream(fileOutputStream, renderedImage, f);
        ((OutputStream)fileOutputStream).close();
    }

    public static void compressJpegStream(OutputStream outputStream, RenderedImage renderedImage, float f) throws IOException {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(Locale.getDefault()){

            @Override
            public void setCompressionQuality(float f) {
                if (f < 0.0f || f > 1.0f) {
                    throw new IllegalArgumentException("Quality out-of-bounds!");
                }
                this.compressionQuality = f;
            }
        };
        jPEGImageWriteParam.setCompressionMode(2);
        jPEGImageWriteParam.setCompressionQuality(f);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(null, new IIOImage(renderedImage, null, null), jPEGImageWriteParam);
        imageOutputStream.flush();
        imageWriter.dispose();
        imageOutputStream.close();
    }
}

