/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class ImagePreview
extends JPanel
implements PropertyChangeListener {
    private JFileChooser jfc;
    private Image img;

    public ImagePreview(JFileChooser jFileChooser) {
        this.jfc = jFileChooser;
        Dimension dimension = new Dimension(200, 200);
        this.setPreferredSize(dimension);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            File file = this.jfc.getSelectedFile();
            this.updateImage(file);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    public void updateImage(File file) throws IOException {
        if (file == null) {
            return;
        }
        this.img = ImageIO.read(file);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(Color.gray);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.img != null) {
            int n = this.img.getWidth(null);
            int n2 = this.img.getHeight(null);
            int n3 = Math.max(n, n2);
            double d = 200.0 / (double)n3;
            n = (int)(d * (double)n);
            n2 = (int)(d * (double)n2);
            graphics.drawImage(this.img, 0, 0, n, n2, null);
            String string = n + " x " + n2;
            graphics.setColor(Color.black);
            graphics.drawString(string, 31, 196);
            graphics.setColor(Color.white);
            graphics.drawString(string, 30, 195);
            graphics.setColor(Color.black);
        }
    }
}

