/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.gui.ConfirmDialog;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.JPEGOutputUtil;
import com.miui.theme.tool.util.NinePatchEditor;
import com.miui.theme.tool.util.ThemeHelper;
import com.miui.theme.tool.util.ToastPanel;
import com.sun.awt.AWTUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GUIUtil {
    public static final Color TRANSPARENT = GUIUtil.hex2color("#00000000");
    public static final Color BLACK = GUIUtil.hex2color("#FF000000");
    public static final Color BASE_BLUE = GUIUtil.hex2color("#5383d1");
    public static final Color COMMON_RIGHT_BACKGROUND_COLOR = GUIUtil.hex2color("#f2f3f5");
    public static final Color SEP_LINE_COLOR = GUIUtil.hex2color("#d7d7d8");
    public static int HDPI_SIZE = 90;
    public static int XHDPI_SIZE = 136;

    public static void alert(String string) {
        JOptionPane.showMessageDialog(NewMainFrame.getInstance(), string);
    }

    public static void alert(String string, Component component) {
        JOptionPane.showMessageDialog(component, string);
    }

    public static JButton createTransparentButton(ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3, ImageIcon imageIcon4) {
        JButton jButton = new JButton();
        jButton.setBorder(null);
        jButton.setMargin(null);
        jButton.setOpaque(false);
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
        }
        if (imageIcon2 != null) {
            jButton.setRolloverIcon(imageIcon2);
        }
        if (imageIcon3 != null) {
            jButton.setPressedIcon(imageIcon3);
        }
        if (imageIcon4 != null) {
            jButton.setDisabledIcon(imageIcon4);
        }
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setRequestFocusEnabled(false);
        GUIUtil.hand(jButton);
        return jButton;
    }

    public static Color hex2color(String string) {
        if (null == string) {
            return null;
        }
        try {
            if (!string.startsWith("#")) {
                return null;
            }
            if (string.length() == 7) {
                return new Color(Integer.valueOf(string.substring(1, 3), 16), Integer.valueOf(string.substring(3, 5), 16), Integer.valueOf(string.substring(5, 7), 16));
            }
            if (string.length() == 9) {
                return new Color(Integer.valueOf(string.substring(3, 5), 16), Integer.valueOf(string.substring(5, 7), 16), Integer.valueOf(string.substring(7, 9), 16), Integer.valueOf(string.substring(1, 3), 16));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String color2hex(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toHexString(color.getAlpha());
        String string2 = Integer.toHexString(color.getRed());
        String string3 = Integer.toHexString(color.getGreen());
        String string4 = Integer.toHexString(color.getBlue());
        string = string.length() == 1 ? "0" + string : string;
        string2 = string2.length() == 1 ? "0" + string2 : string2;
        string3 = string3.length() == 1 ? "0" + string3 : string3;
        string4 = string4.length() == 1 ? "0" + string4 : string4;
        stringBuffer.append("#");
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(string3);
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    public static String color2hexNoAlpha(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        string = string.length() == 1 ? "0" + string : string;
        string2 = string2.length() == 1 ? "0" + string2 : string2;
        string3 = string3.length() == 1 ? "0" + string3 : string3;
        stringBuffer.append("#");
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public static BufferedImage getImage(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedImage bufferedImage = ImageIO.read(fileInputStream);
            fileInputStream.close();
            return bufferedImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getImage(InputStream inputStream) {
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            return bufferedImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void openNinePatch(String string) {
        NinePatchEditor ninePatchEditor = new NinePatchEditor(string);
        ninePatchEditor.setVisible(true);
    }

    public static void layout(Container container, Container container2, int n, int n2) {
        container.setBounds(container2.getX() + (container2.getWidth() - n) / 2, container2.getY() + (container2.getHeight() - n2) / 2, n, n2);
    }

    public static NinePatch getNinePatch(String string) {
        try {
            InputStream inputStream = ResourceFactory.getInstance().getResourceSream(string);
            NinePatch ninePatch = NinePatch.load(inputStream, true, false);
            inputStream.close();
            return ninePatch;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void saveImage(Image image, File file) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        GUIUtil.saveImage(bufferedImage, file);
    }

    public static BufferedImage getBufferedImageFromImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
        bufferedImage.getGraphics().drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public static void saveImage(BufferedImage bufferedImage, File file) {
        GUIUtil.saveImage(bufferedImage, file, 1.0f);
    }

    public static void saveImage(BufferedImage bufferedImage, File file, float f) {
        try {
            file.getParentFile().mkdirs();
            String string = file.getAbsolutePath();
            if (string.endsWith(".jpg")) {
                JPEGOutputUtil.compressJpegFile(file, bufferedImage, f);
            } else if (string.endsWith(".png")) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                if (!ImageIO.write((RenderedImage)bufferedImage, "PNG", fileOutputStream)) {
                    fileOutputStream.close();
                    throw new IOException("Failed to find png writer");
                }
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static BufferedImage scaleImage(BufferedImage bufferedImage, int n) {
        return GUIUtil.scaleImage(bufferedImage, n, 4);
    }

    public static BufferedImage scaleImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImage;
        int n3 = bufferedImage.getHeight();
        int n4 = bufferedImage.getWidth();
        if (bufferedImage.getWidth() > n) {
            n4 = n;
            n3 = (int)(1.0 * (double)bufferedImage.getHeight() / (double)bufferedImage.getWidth() * (double)n);
            if (n3 <= 0) {
                n3 = 3;
            }
            bufferedImage2 = GUIUtil.scale(bufferedImage, n, n3);
        }
        if (n3 > n) {
            if ((n4 = (int)(1.0 * (double)n4 / (double)n3 * (double)n)) <= 0) {
                n4 = 3;
            }
            bufferedImage2 = GUIUtil.scale(bufferedImage2, n4, n);
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = bufferedImage;
        }
        return bufferedImage2;
    }

    public static ImageIcon getIcon(File file) {
        return GUIUtil.getIcon(file, 4);
    }

    public static ImageIcon getIcon(File file, int n) {
        return GUIUtil.getIcon(file, HDPI_SIZE, n);
    }

    public static ImageIcon getIcon(File file, int n, int n2) {
        if (!file.exists()) {
            return new ImageIcon();
        }
        return GUIUtil.getIcon(GUIUtil.getImage(file), n, n2);
    }

    public static ImageIcon getIcon(BufferedImage bufferedImage, int n, int n2) {
        return new ImageIcon(GUIUtil.scaleImage(bufferedImage, n, n2));
    }

    public static void centerComponent(JComponent jComponent) {
        Rectangle rectangle = NewMainFrame.getInstance().getBounds();
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        rectangle = jComponent.getBounds();
        rectangle = new Rectangle(point.x - rectangle.width / 2, point.y - rectangle.height / 2, rectangle.width, rectangle.height);
        jComponent.setBounds(rectangle);
    }

    public static void fixSize(Container container, Dimension dimension) {
        container.setPreferredSize(dimension);
        container.setMinimumSize(dimension);
        container.setMaximumSize(dimension);
        container.setSize(dimension);
    }

    public static String cutWord(JComponent jComponent, String string, int n) {
        string = string.replaceAll("</?[^>]+>", "");
        FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        for (int i = 1; i < string.length(); ++i) {
            if (string.charAt(i - 1) > '\u00ff') {
                ++i;
            }
            if (fontMetrics.stringWidth(string.substring(0, i)) < n) continue;
            return string.substring(0, i) + "...";
        }
        return string;
    }

    public static boolean supportTransparent() {
        if (ThemeHelper.isReviewMode()) {
            return false;
        }
        if (OS.getOS() == 2) {
            return false;
        }
        return AWTUtilities.isTranslucencySupported((AWTUtilities.Translucency)AWTUtilities.Translucency.TRANSLUCENT);
    }

    public static void toast(String string) {
        ToastPanel toastPanel = ToastPanel.getInstance();
        toastPanel.setMessage(string);
        toastPanel.showToast();
    }

    public static void toastLong(String string) {
        ToastPanel toastPanel = ToastPanel.getInstance();
        toastPanel.setMessage(string);
        toastPanel.showToast(ToastPanel.LONG);
    }

    public static ToastPanel toastEver(String string) {
        ToastPanel toastPanel = ToastPanel.getInstance();
        toastPanel.setMessage(string);
        toastPanel.showToast(ToastPanel.EVER);
        return toastPanel;
    }

    public static void hand(Container container) {
        container.setCursor(Cursor.getPredefinedCursor(12));
    }

    public static void wait(Container container) {
        container.setCursor(Cursor.getPredefinedCursor(12));
    }

    public static void normal(Container container) {
        container.setCursor(Cursor.getPredefinedCursor(12));
    }

    public static void moveable(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewMainFrame.getInstance().bindMoveWindowListener(jComponent);
            }
        });
    }

    public static void showSuccess() {
        GUIUtil.toastLong(ResourceFactory.getString("Success"));
    }

    public static void showFail() {
        ConfirmDialog confirmDialog = new ConfirmDialog(ResourceFactory.getString("Notice"), ResourceFactory.getString("Fail"));
        confirmDialog.setVisible(true);
    }

    public static void showResult(boolean bl) {
        if (bl) {
            GUIUtil.showSuccess();
        } else {
            GUIUtil.showFail();
        }
    }

    public static void font(JComponent jComponent, float f) {
        jComponent.setFont(jComponent.getFont().deriveFont(f));
    }

    public static BufferedImage scale(BufferedImage bufferedImage, int n, int n2) {
        return GUIUtil.getBufferedImageFromImage(bufferedImage.getScaledInstance(n, n2, 4));
    }
}

