/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.android.ninepatch.GraphicsUtilities;
import com.miui.theme.tool.gui.CopyableDialog;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.Log;
import com.miui.theme.tool.util.SimilarImageSearch;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class FullResolutionMatchManager {
    public static final String MATCH_FILE = "full_resolution_match.csv";
    public static final double HDPI2XHDPI_SCALE = 1.5;
    public static final double XHDPI2XXHDPI_SCALE = 1.4;
    public static final int WIDTH = 15;
    public static final int HEIGHT = 15;
    public static HashMap<String, Set<String>> sFullResolutionMatchManager = new HashMap();
    public static HashMap<String, Double> sHDPI2XHDPI_SCALE = new HashMap();
    public static HashMap<String, Double> sXHDPI2XXHDPI_SCALE = new HashMap();
    public static final String[] NORMAL_SUFFIX;
    public static final String[] PRESSED_SUFFIX;
    public static final String[] DISABLED_SUFFIX;

    private static boolean checkShouldMatch(String string, String string2) {
        if (!sFullResolutionMatchManager.containsKey(string)) {
            return false;
        }
        return sFullResolutionMatchManager.get(string).contains(string2);
    }

    public static boolean checkNeedFullResolutionMatch(File file) {
        String[] stringArray = FullResolutionMatchManager.getInfoFromFile(file);
        if (stringArray.length < 2) {
            return false;
        }
        return FullResolutionMatchManager.checkShouldMatch(stringArray[0], stringArray[stringArray.length - 1]);
    }

    public static String[] getInfoFromFile(File file) {
        String string = file.getAbsolutePath().substring(ConfigUtil.getThemePath().length() + 1);
        return ThemeHelper.assurePath(string).split("\\" + File.separator);
    }

    public static String getKeyFromNames(String string, String string2) {
        return string + " " + string2;
    }

    public static String getKeyFromFile(File file) {
        String[] stringArray = FullResolutionMatchManager.getInfoFromFile(file);
        return FullResolutionMatchManager.getKeyFromNames(stringArray[0], stringArray[stringArray.length - 1]);
    }

    public static File getPath(File file, String string, String string2) {
        return new File(file.getAbsolutePath().replace(string, string2));
    }

    public static File getHdpiPathFromXhdpiPath(File file) {
        return FullResolutionMatchManager.getPath(file, "drawable-xhdpi", "drawable-hdpi");
    }

    public static File getXxhdpiPathFromXhdpiPath(File file) {
        return FullResolutionMatchManager.getPath(file, "drawable-xhdpi", "drawable-xxhdpi");
    }

    public static File getXhdpiPathFromXxhdpiPath(File file) {
        return FullResolutionMatchManager.getPath(file, "drawable-xxhdpi", "drawable-xhdpi");
    }

    public static void adaptXhdpiToHdpi(File file) {
        File file2 = FullResolutionMatchManager.getHdpiPathFromXhdpiPath(file);
        String string = FullResolutionMatchManager.getKeyFromFile(file);
        double d = 0.6666666666666666;
        if (sHDPI2XHDPI_SCALE.containsKey(string)) {
            d = 1.0 / sHDPI2XHDPI_SCALE.get(string);
        }
        FullResolutionMatchManager.adapt(file, file2, d);
    }

    public static void adaptXhdpiToXxhdpi(File file) {
        File file2 = FullResolutionMatchManager.getXxhdpiPathFromXhdpiPath(file);
        String string = FullResolutionMatchManager.getKeyFromFile(file);
        double d = 1.4;
        if (sXHDPI2XXHDPI_SCALE.containsKey(string)) {
            d = sXHDPI2XXHDPI_SCALE.get(string);
        }
        FullResolutionMatchManager.adapt(file, file2, d);
    }

    public static void adaptXxhdpiToXhdpi(File file) {
        File file2 = FullResolutionMatchManager.getXhdpiPathFromXxhdpiPath(file);
        double d = 0.6666666666666666;
        String string = ConfigUtil.get("preference", "XxhdpiXhdpi");
        if (!string.isEmpty()) {
            d = Float.parseFloat(string);
        }
        FullResolutionMatchManager.adapt(file, file2, d);
    }

    public static Vector<File> adaptAllXhdpi(String string, String string2) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        Vector<File> vector = new Vector<File>();
        if (fileArray == null) {
            return vector;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (!sFullResolutionMatchManager.containsKey(fileArray[i].getName())) continue;
            for (String string3 : sFullResolutionMatchManager.get(fileArray[i].getName())) {
                String string4 = fileArray[i].getAbsolutePath() + File.separator + "res" + File.separator + "drawable-xhdpi" + File.separator + string3;
                File file2 = new File(string4);
                if (!file2.exists()) continue;
                if (string2.equals("drawable-hdpi")) {
                    if (FullResolutionMatchManager.getHdpiPathFromXhdpiPath(file2).exists()) continue;
                    FullResolutionMatchManager.adaptXhdpiToHdpi(file2);
                    vector.add(FullResolutionMatchManager.getHdpiPathFromXhdpiPath(file2));
                    continue;
                }
                if (!string2.equals("drawable-xxhdpi") || FullResolutionMatchManager.getXxhdpiPathFromXhdpiPath(file2).exists()) continue;
                FullResolutionMatchManager.adaptXhdpiToXxhdpi(file2);
                vector.add(FullResolutionMatchManager.getXxhdpiPathFromXhdpiPath(file2));
            }
        }
        return vector;
    }

    public static void showAdaptResult(Vector<File> vector) {
        StringBuilder stringBuilder = new StringBuilder(ResourceFactory.getString("adapted") + "\n");
        for (int i = 0; i < vector.size(); ++i) {
            stringBuilder.append(vector.get(i) + "\n");
        }
        CopyableDialog copyableDialog = new CopyableDialog(stringBuilder.toString());
        copyableDialog.setVisible(true);
    }

    public static void adaptAllPressed(File file, Set<File> set) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file2 : fileArray) {
                FullResolutionMatchManager.adaptAllPressed(file2, set);
            }
        } else {
            if (!file.getAbsolutePath().endsWith(".png")) {
                return;
            }
            FullResolutionMatchManager.checkAdaptPressed(file, set);
        }
    }

    public static void checkAdaptPressed(File file, Set<File> set) {
        File file2 = ThemeHelper.getCatalogFileFromReplaceFile(file);
        if (file2 == null || !file2.exists()) {
            return;
        }
        for (int i = 0; i < PRESSED_SUFFIX.length; ++i) {
            File file3;
            File file4;
            File file5;
            if (!file2.getAbsolutePath().endsWith(PRESSED_SUFFIX[i] + ".png")) continue;
            File file6 = new File(file2.getAbsolutePath().replace(PRESSED_SUFFIX[i], NORMAL_SUFFIX[i]));
            if (FullResolutionMatchManager.checkAndReplace(file6, file5 = new File(file.getAbsolutePath().replace(PRESSED_SUFFIX[i], NORMAL_SUFFIX[i])))) {
                set.add(file5);
            }
            if (!FullResolutionMatchManager.checkAndReplace(file4 = new File(file2.getAbsolutePath().replace(PRESSED_SUFFIX[i], DISABLED_SUFFIX[i])), file3 = new File(file.getAbsolutePath().replace(PRESSED_SUFFIX[i], DISABLED_SUFFIX[i])))) continue;
            set.add(file5);
        }
    }

    private static boolean checkAndReplace(File file, File file2) {
        if (file.exists() && !file2.exists()) {
            try {
                ThemeHelper.copyFile(file, file2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public static void adapt(File file, File file2, double d) {
        int n;
        int n2;
        if (d == -1.0) {
            return;
        }
        BufferedImage bufferedImage = GUIUtil.getImage(file);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (!file.getAbsolutePath().endsWith(ThemeHelper.NINE_PATCH_SUFFIX)) {
            int n5 = FullResolutionMatchManager.scale(n3, d);
            int n6 = FullResolutionMatchManager.scale(n4, d);
            if (n3 <= 15) {
                n5 = n3;
            }
            if (n4 <= 15) {
                n6 = n4;
            }
            if (n5 <= 0 || n6 <= 0) {
                return;
            }
            GUIUtil.saveImage(GUIUtil.scale(bufferedImage, n5, n6), file2);
            return;
        }
        int n7 = FullResolutionMatchManager.scale(n3 -= 2, d);
        int n8 = FullResolutionMatchManager.scale(n4 -= 2, d);
        if (n3 <= 15) {
            n7 = n3;
        }
        if (n4 <= 15) {
            n8 = n4;
        }
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        nArray = GraphicsUtilities.getPixels(bufferedImage, 1, 0, n3, 1, nArray);
        nArray2 = GraphicsUtilities.getPixels(bufferedImage, 0, 1, 1, n4, nArray2);
        boolean[] blArray = new boolean[1];
        Pair<List<Pair<Integer>>> pair = FullResolutionMatchManager.getPatches(nArray2, blArray);
        Pair<List<Pair<Integer>>> pair2 = FullResolutionMatchManager.getPatches(nArray, blArray);
        nArray3 = GraphicsUtilities.getPixels(bufferedImage, 1, n4 + 1, n3, 1, nArray3);
        nArray4 = GraphicsUtilities.getPixels(bufferedImage, n3 + 1, 1, 1, n4, nArray4);
        Pair<List<Pair<Integer>>> pair3 = FullResolutionMatchManager.getPatches(nArray3, blArray);
        Pair<Integer> pair4 = FullResolutionMatchManager.getPadding((List)pair3.mFirst);
        Pair<List<Pair<Integer>>> pair5 = FullResolutionMatchManager.getPatches(nArray4, blArray);
        Pair<Integer> pair6 = FullResolutionMatchManager.getPadding((List)pair5.mFirst);
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(1, 1, n3, n4);
        BufferedImage bufferedImage3 = new BufferedImage(n7, n8, 6);
        bufferedImage3 = GUIUtil.scale(bufferedImage2, n7, n8);
        BufferedImage bufferedImage4 = new BufferedImage(n7 + 2, n8 + 2, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage4.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage3, 1, 1, n7 + 1, n8 + 1, 0, 0, n7, n8, null);
        graphics2D.setColor(GUIUtil.BLACK);
        double d2 = n3 > 15 ? d : 1.0;
        for (Pair pair7 : (List)pair2.mSecond) {
            n2 = FullResolutionMatchManager.getXFixedPoint((Integer)pair7.mFirst, bufferedImage2, bufferedImage3, d2);
            n = FullResolutionMatchManager.getXFixedPoint((Integer)pair7.mSecond - 1, bufferedImage2, bufferedImage3, d2);
            graphics2D.drawLine(1 + n2, 0, 1 + n, 0);
        }
        for (Pair pair7 : (List)pair3.mSecond) {
            n2 = FullResolutionMatchManager.getXFixedPoint((Integer)pair7.mFirst, bufferedImage2, bufferedImage3, d2);
            n = FullResolutionMatchManager.getXFixedPoint((Integer)pair7.mSecond - 1, bufferedImage2, bufferedImage3, d2);
            graphics2D.drawLine(1 + n2, n8 + 1, 1 + n, n8 + 1);
        }
        d2 = n4 > 15 ? d : 1.0;
        for (Pair pair7 : (List)pair.mSecond) {
            n2 = FullResolutionMatchManager.getYFixedPoint((Integer)pair7.mFirst, bufferedImage2, bufferedImage3, d2);
            n = FullResolutionMatchManager.getYFixedPoint((Integer)pair7.mSecond - 1, bufferedImage2, bufferedImage3, d2);
            graphics2D.drawLine(0, 1 + n2, 0, 1 + n);
        }
        for (Pair pair7 : (List)pair5.mSecond) {
            n2 = FullResolutionMatchManager.getYFixedPoint((Integer)pair7.mFirst, bufferedImage2, bufferedImage3, d2);
            n = FullResolutionMatchManager.getYFixedPoint((Integer)pair7.mSecond - 1, bufferedImage2, bufferedImage3, d2);
            graphics2D.drawLine(n7 + 1, 1 + n2, n7 + 1, 1 + n);
        }
        graphics2D.dispose();
        GUIUtil.saveImage(bufferedImage4, file2);
    }

    private static void show(BufferedImage bufferedImage) {
        Log.l("----------------------------------");
        Log.l(FullResolutionMatchManager.c(bufferedImage.getRGB(0, 0)));
        Log.l(FullResolutionMatchManager.c(bufferedImage.getRGB(0, 1)));
        Log.l(FullResolutionMatchManager.c(bufferedImage.getRGB(1, 0)));
        Log.l(FullResolutionMatchManager.c(bufferedImage.getRGB(1, 1)));
        Log.l("----------------------------------");
    }

    public static String c(int n) {
        return GUIUtil.color2hex(new Color(n, true));
    }

    private static int getXFixedPoint(int n, BufferedImage bufferedImage, BufferedImage bufferedImage2, double d) {
        if (n == 0) {
            return 0;
        }
        if (n == bufferedImage.getWidth() - 1) {
            return bufferedImage2.getWidth() - 1;
        }
        int n2 = FullResolutionMatchManager.scale(n, d);
        String string = SimilarImageSearch.produceFingerPrint(bufferedImage.getSubimage(n, 0, 1, bufferedImage.getHeight()));
        ArrayList<Pair<Integer>> arrayList = new ArrayList<Pair<Integer>>();
        for (int i = n2 - 1; i <= n2 + 1; ++i) {
            if (i < 0 || i > bufferedImage2.getWidth() - 1) continue;
            String string2 = SimilarImageSearch.produceFingerPrint(bufferedImage2.getSubimage(i, 0, 1, bufferedImage2.getHeight()));
            int n3 = SimilarImageSearch.hammingDistance(string, string2);
            arrayList.add(new Pair<Integer>(i, n3));
        }
        return FullResolutionMatchManager.minDistance(arrayList);
    }

    private static int getYFixedPoint(int n, BufferedImage bufferedImage, BufferedImage bufferedImage2, double d) {
        if (n == 0) {
            return 0;
        }
        if (n == bufferedImage.getHeight() - 1) {
            return bufferedImage2.getHeight() - 1;
        }
        int n2 = FullResolutionMatchManager.scale(n, d);
        String string = SimilarImageSearch.produceFingerPrint(bufferedImage.getSubimage(0, n, bufferedImage.getWidth(), 1));
        ArrayList<Pair<Integer>> arrayList = new ArrayList<Pair<Integer>>();
        for (int i = n2 - 1; i <= n2 + 1; ++i) {
            if (i < 0 || i > bufferedImage2.getHeight() - 1) continue;
            String string2 = SimilarImageSearch.produceFingerPrint(bufferedImage2.getSubimage(0, i, bufferedImage2.getWidth(), 1));
            int n3 = SimilarImageSearch.hammingDistance(string, string2);
            arrayList.add(new Pair<Integer>(i, n3));
        }
        return FullResolutionMatchManager.minDistance(arrayList);
    }

    private static int minDistance(List<Pair<Integer>> list) {
        Pair<Integer> pair = list.get(1);
        Collections.sort(list, new Comparator<Pair<Integer>>(){

            @Override
            public int compare(Pair<Integer> pair, Pair<Integer> pair2) {
                return (Integer)pair.mSecond - (Integer)pair2.mSecond;
            }
        });
        if (list.get((int)0).mSecond == pair.mSecond) {
            return (Integer)pair.mFirst;
        }
        return (Integer)list.get((int)0).mFirst;
    }

    private static Pair<Integer> getPadding(List<Pair<Integer>> list) {
        if (list.size() == 0) {
            return new Pair<Integer>(0, 0);
        }
        if (list.size() == 1) {
            if ((Integer)list.get((int)0).mFirst == 0) {
                return new Pair<Integer>((Integer)list.get((int)0).mSecond - (Integer)list.get((int)0).mFirst, 0);
            }
            return new Pair<Integer>(0, (Integer)list.get((int)0).mSecond - (Integer)list.get((int)0).mFirst);
        }
        int n = list.size() - 1;
        return new Pair<Integer>((Integer)list.get((int)0).mSecond - (Integer)list.get((int)0).mFirst, (Integer)list.get((int)n).mSecond - (Integer)list.get((int)n).mFirst);
    }

    private static int scale(double d, double d2) {
        return (int)(d * d2);
    }

    private static Pair<List<Pair<Integer>>> getPatches(int[] nArray, boolean[] blArray) {
        int n = 0;
        int n2 = nArray[0];
        boolean bl = true;
        ArrayList<Pair<Integer>> arrayList = new ArrayList<Pair<Integer>>();
        ArrayList<Pair<Integer>> arrayList2 = new ArrayList<Pair<Integer>>();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 == n2) continue;
            if (n2 == -16777216) {
                if (bl) {
                    blArray[0] = true;
                }
                arrayList2.add(new Pair<Integer>(n, i));
            } else {
                arrayList.add(new Pair<Integer>(n, i));
            }
            bl = false;
            n = i;
            n2 = n3;
        }
        if (n2 == -16777216) {
            if (bl) {
                blArray[0] = true;
            }
            arrayList2.add(new Pair<Integer>(n, nArray.length));
        } else {
            arrayList.add(new Pair<Integer>(n, nArray.length));
        }
        if (arrayList2.size() == 0) {
            arrayList2.add(new Pair<Integer>(1, nArray.length));
            blArray[0] = true;
            arrayList.clear();
        }
        return new Pair<List<Pair<Integer>>>(arrayList, arrayList2);
    }

    static {
        String string = ThemeHelper.readFromFile(new File(ThemeHelper.getDataFolder() + File.separator + MATCH_FILE));
        if (string != null) {
            String[] stringArray = string.split("\r?\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String[] stringArray2 = string2.split(",");
                if (stringArray2 == null || stringArray2.length < 2) continue;
                if (!sFullResolutionMatchManager.containsKey(stringArray2[0])) {
                    sFullResolutionMatchManager.put(stringArray2[0], new HashSet());
                }
                sFullResolutionMatchManager.get(stringArray2[0]).add(stringArray2[1]);
                String string3 = FullResolutionMatchManager.getKeyFromNames(stringArray2[0], stringArray2[1]);
                if (stringArray2.length >= 3 && !stringArray2[2].trim().isEmpty()) {
                    sHDPI2XHDPI_SCALE.put(string3, Double.parseDouble(stringArray2[2]));
                }
                if (stringArray2.length < 4 || stringArray2[3].trim().isEmpty()) continue;
                sXHDPI2XXHDPI_SCALE.put(string3, Double.parseDouble(stringArray2[3]));
            }
        }
        NORMAL_SUFFIX = new String[]{"_n", "_normal"};
        PRESSED_SUFFIX = new String[]{"_p", "_pressed"};
        DISABLED_SUFFIX = new String[]{"_d", "_disabled"};
    }

    static class Pair<E>
    implements Serializable {
        private static final long serialVersionUID = -2204108979541762418L;
        E mFirst;
        E mSecond;

        Pair(E e, E e2) {
            this.mFirst = e;
            this.mSecond = e2;
        }

        public String toString() {
            return "Pair[" + this.mFirst + ", " + this.mSecond + "]";
        }
    }
}

