/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.update;

import com.miui.theme.tool.gui.PopupDialog;
import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.update.VersionFile;
import com.miui.theme.tool.util.DownloadProgressListener;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.InternetDownloadTask;
import com.miui.theme.tool.util.Log;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.json.JSONObject;

public class UpdateDialog
extends PopupDialog {
    public static final String NAME_PREFIX = "MIUINewThemeEditor_";
    public static final String NAME_SUFFIX = ".zip";
    public static final String INNER_URL = "http://mi.tlightsky.com/MIUINewThemeEditor/";
    public static final String URL_SEP = "/";
    public static final String NAME_VERSION = "version.txt";
    public static final String NAME_TMP_VERSION = "version.new";
    public static final String STAGING_URL = "http://staging.market.n.xiaomi.com";
    public static final String MARKET_URL = "http://market.xiaomi.com";
    public static final String DETAIL = "/thm/thememakingtool/win";
    public static final String CHECK_UPDATE = "/thm/thememakingtool/win/checkupdate/version/";
    public static final String DOWNLOAD = "/thm/thememakingtool/win/download";
    private File mCurrentVersionFile;
    private VersionFile mCurrentVF;
    private File mUpdatePackageFile;
    private InternetDownloadTask mInternetDownloadTask;
    protected TransparentPanel mTitlePanel;
    protected String mMessage;
    protected JPanel mBottomPanel;
    private JPanel mMiddlePanel;
    private JLabel mMiddleLabel;
    private JLabel mMiddleText;
    private TransparentPanel mMiddleTextWrapper;
    ImageIcon sPositiveNIcon = ResourceFactory.getInstance().getImageIcon("review/positive_btn_n.png");
    ImageIcon sPositivePIcon = ResourceFactory.getInstance().getImageIcon("review/positive_btn_p.png");
    ImageIcon sNegativeNIcon = ResourceFactory.getInstance().getImageIcon("review/negative_btn_n.png");
    ImageIcon sNegativePIcon = ResourceFactory.getInstance().getImageIcon("review/negative_btn_p.png");
    JButton mIgnoreButton = GUIUtil.createTransparentButton(this.sNegativeNIcon, null, this.sNegativePIcon, null);
    JButton mUpdateButton = GUIUtil.createTransparentButton(this.sPositiveNIcon, null, this.sPositivePIcon, null);
    JButton mCancelButton = GUIUtil.createTransparentButton(this.sNegativeNIcon, null, this.sNegativePIcon, null);
    private ActionListener mActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(UpdateDialog.this.mIgnoreButton)) {
                UpdateDialog.this.closeDialog();
            } else if (actionEvent.getSource().equals(UpdateDialog.this.mUpdateButton)) {
                UpdateDialog.this.initProgressBottomPanel();
                UpdateDialog.this.downloadUpdate();
            } else if (actionEvent.getSource().equals(UpdateDialog.this.mCancelButton)) {
                UpdateDialog.this.mInternetDownloadTask.cancel(true);
            }
        }
    };
    private JProgressBar mProgressBar;
    private DownloadProgressListener dpl = new DownloadProgressListener(){

        @Override
        public void progress(long l, long l2) {
            UpdateDialog.this.mProgressBar.setMaximum((int)(l2 / 4096L));
            UpdateDialog.this.mProgressBar.setMinimum(0);
            UpdateDialog.this.mProgressBar.setValue((int)(l / 4096L));
            UpdateDialog.this.mProgressBar.updateUI();
            Log.l(l + UpdateDialog.URL_SEP + l2);
        }

        @Override
        public void done(Object object) {
            UpdateDialog.this.mCancelButton.setEnabled(false);
            UpdateDialog.this.mCancelButton.setText(ResourceFactory.getString("Unzipping"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean bl = ThemeHelper.unzip(UpdateDialog.this.mUpdatePackageFile, new File(ThemeHelper.getUserDir()).getParentFile());
                    UpdateDialog.this.mCancelButton.setVisible(false);
                    UpdateDialog.this.mConfirmButton.setVisible(true);
                    if (bl) {
                        UpdateDialog.this.deleteOld();
                        UpdateDialog.this.transport();
                        CmdUtils.startEditor();
                        NewMainFrame.getInstance().exit();
                    } else {
                        GUIUtil.alert(ResourceFactory.getString("UpdateUnzipError"), UpdateDialog.this);
                        String string = new File(ThemeHelper.getUserDir()).getParent() + File.separator + UpdateDialog.this.getNewVersion() + File.separator;
                        CmdUtils.deleteDir(string);
                    }
                }
            });
        }

        @Override
        public void cancelled() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateDialog.this.closeDialog();
                    GUIUtil.alert(ResourceFactory.getString("UpdateDownloadCancelled"), UpdateDialog.this);
                }
            });
        }
    };

    public UpdateDialog() {
        this.setModal(false);
        this.initTitlePanel();
        this.initMiddlePanel();
        this.initBottomPanel();
        this.initLayout();
    }

    protected void initLayout() {
        double[][] dArrayArray = new double[][]{{-1.0, 680.0, -1.0}, {20.0, 32.0, 17.0, -1.0, 20.0, 30.0, 22.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mMainPanel.setLayout(tableLayout);
        int n = 1;
        this.mMainPanel.add((Component)this.mTitlePanel, "1, " + n);
        this.mMainPanel.add((Component)this.mMiddlePanel, "1, " + (n += 2));
        this.mMainPanel.add((Component)this.mBottomPanel, "1, " + (n += 2));
    }

    protected void initTitlePanel() {
        double[][] dArrayArray = new double[][]{{-1.0}, {-1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mTitlePanel = new TransparentPanel();
        this.mTitlePanel.setLayout(tableLayout);
        this.mDialogTitleLabel = new JLabel(ResourceFactory.getString("UpdateAvailable"));
        this.mDialogTitleLabel.setHorizontalTextPosition(2);
        GUIUtil.font(this.mDialogTitleLabel, 30.0f);
        this.mTitlePanel.add((Component)this.mDialogTitleLabel, "0, 0");
    }

    protected void initMiddlePanel() {
        double[][] dArrayArray = new double[][]{{12.0, -1.0, 12.0}, {14.0, 20.0, 10.0, 1.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mMiddlePanel = new JPanel();
        this.mMiddlePanel.setLayout(tableLayout);
        this.mMiddlePanel.setBorder(BorderFactory.createLineBorder(GUIUtil.hex2color("#dbdcde"), 1));
        this.mMiddlePanel.setBackground(GUIUtil.COMMON_RIGHT_BACKGROUND_COLOR);
        this.mMiddleLabel = new JLabel(ResourceFactory.getString("UpdateLog"));
        this.mMiddleLabel.setHorizontalTextPosition(2);
        GUIUtil.font(this.mMiddleLabel, 16.0f);
        this.mMiddleLabel.setForeground(GUIUtil.hex2color("#5384d6"));
        this.mMiddlePanel.add((Component)this.mMiddleLabel, "1, 1");
        this.mMiddlePanel.add((Component)this.getSepPanel(), "1, 3");
        this.initMiddleText();
        this.mMiddlePanel.add((Component)this.mMiddleTextWrapper, "1, 4");
    }

    protected void initMiddleText() {
        double[][] dArrayArray = new double[][]{{9.0, -1.0, 9.0}, {12.0, -2.0, -1.0, 12.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mMiddleTextWrapper = new TransparentPanel();
        this.mMiddleTextWrapper.setLayout(tableLayout);
        this.mMiddleText = new JLabel("<html>" + this.getDetail() + "</html>");
        GUIUtil.font(this.mMiddleText, 14.0f);
        this.mMiddleTextWrapper.add((Component)this.mMiddleText, "1, 1");
    }

    private String getDetail() {
        JSONObject jSONObject = this.getDetailObject();
        if (jSONObject == null) {
            return "";
        }
        String string = jSONObject.getString("description");
        if (string != null) {
            return string;
        }
        return "";
    }

    private String getNewVersion() {
        JSONObject jSONObject = this.getDetailObject();
        if (jSONObject == null) {
            return "";
        }
        String string = jSONObject.getString("version");
        if (string != null) {
            return string;
        }
        return "1.0";
    }

    private JSONObject getDetailObject() {
        String string = ThemeHelper.isInnerUserMode() ? "http://staging.market.n.xiaomi.com/thm/thememakingtool/win" : "http://market.xiaomi.com/thm/thememakingtool/win";
        try {
            JSONObject jSONObject = ThemeHelper.getJSON(string);
            return jSONObject;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected void initProgressBottomPanel() {
        this.mMainPanel.remove(this.mBottomPanel);
        double[][] dArrayArray = new double[][]{{-1.0, 17.0, 89.0}, {11.0, 15.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mBottomPanel = new JPanel();
        this.mBottomPanel.setBackground(GUIUtil.hex2color("#efeff1"));
        this.mBottomPanel.setLayout(tableLayout);
        this.mProgressBar = new JProgressBar();
        this.mProgressBar.setBorder(BorderFactory.createLineBorder(GUIUtil.hex2color("#d4d5d8"), 1));
        this.mCancelButton.setText(ResourceFactory.getString("Cancel"));
        this.processButton(this.mCancelButton);
        this.mCancelButton.addActionListener(this.mActionListener);
        this.mBottomPanel.add((Component)this.mProgressBar, "0, 1");
        this.mBottomPanel.add((Component)this.mCancelButton, "2, 0, 2, 1");
        this.mMainPanel.add((Component)this.mBottomPanel, "1, 5");
    }

    protected void initBottomPanel() {
        double[][] dArrayArray = new double[][]{{-1.0, 89.0, 15.0, 89.0}, {-1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mBottomPanel = new TransparentPanel();
        this.mBottomPanel.setLayout(tableLayout);
        this.mIgnoreButton.setText(ResourceFactory.getString("Ignore"));
        this.processButton(this.mIgnoreButton);
        this.mIgnoreButton.addActionListener(this.mActionListener);
        this.mUpdateButton.setText(ResourceFactory.getString("Update"));
        this.processButton(this.mUpdateButton);
        this.mUpdateButton.addActionListener(this.mActionListener);
        this.mBottomPanel.add((Component)this.mIgnoreButton, "1, 0");
        this.mBottomPanel.add((Component)this.mUpdateButton, "3, 0");
    }

    public String getCurrentVersion() {
        this.mCurrentVersionFile = new File(ThemeHelper.getUserDir() + File.separator + NAME_VERSION);
        this.mCurrentVF = VersionFile.parse(this.mCurrentVersionFile);
        return this.mCurrentVF.getVersionString();
    }

    @Override
    public int getDefineHeight() {
        return 525;
    }

    @Override
    public int getDefineWidth() {
        return 793;
    }

    private void downloadUpdate() {
        this.mUpdatePackageFile = new File(ThemeHelper.getUserDir() + File.separator + NAME_PREFIX + this.getNewVersion() + NAME_SUFFIX);
        String string = ThemeHelper.isInnerUserMode() ? "http://mi.tlightsky.com/MIUINewThemeEditor/MIUINewThemeEditor_" + this.getNewVersion() + NAME_SUFFIX : "http://market.xiaomi.com/thm/thememakingtool/win/download";
        try {
            this.mInternetDownloadTask = new InternetDownloadTask(string, new FileOutputStream(this.mUpdatePackageFile));
            this.mInternetDownloadTask.setDownloadProgressListener(this.dpl);
            this.mInternetDownloadTask.execute();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            GUIUtil.alert(ResourceFactory.getString("UpdateDownloadError"), this);
            this.closeDialog();
        }
    }

    private void transport() {
        this.mCancelButton.setText(ResourceFactory.getString("Transporting"));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.mConfirmButton.setEnabled(false);
        String string = ThemeHelper.getUserDir() + File.separator;
        String string2 = new File(ThemeHelper.getUserDir()).getParent() + File.separator + this.getNewVersion() + File.separator;
        String string3 = "config";
        CmdUtils.copyDir(string + string3, string2 + string3);
        this.setCursor(Cursor.getDefaultCursor());
        this.closeDialog();
        GUIUtil.alert(ResourceFactory.getString("UpdateTransportDone"), this);
    }

    private void deleteOld() {
        File file = new File(ThemeHelper.getUserDir()).getParentFile();
        Vector<VersionFile> vector = new Vector<VersionFile>();
        for (File file2 : file.listFiles()) {
            VersionFile versionFile = VersionFile.parse(file2.getName());
            if (versionFile == null) continue;
            vector.add(versionFile);
        }
        Collections.sort(vector);
        for (int i = 0; i < vector.size() - 2; ++i) {
            CmdUtils.deleteDir(file.getAbsolutePath() + File.separator + ((VersionFile)vector.get(i)).getVersionString());
            System.out.println("deleting " + ((VersionFile)vector.get(i)).getVersionString());
        }
    }

    private void processButton(JButton jButton) {
        GUIUtil.font(jButton, 13.0f);
        jButton.setHorizontalTextPosition(0);
        jButton.setForeground(Color.WHITE);
    }
}

