/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.review;

import com.miui.theme.tool.review.CustomRedirectHandler;
import com.miui.theme.tool.review.ReviewConfig;
import com.miui.theme.tool.review.ThemeTask;
import com.miui.theme.tool.util.DownloadProgressListener;
import com.miui.theme.tool.util.InputStreamUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class ThemeDownloadManager {
    private static volatile ThemeDownloadManager single;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThemeDownloadManager getInstance() {
        if (single != null) return single;
        Class<ThemeDownloadManager> clazz = ThemeDownloadManager.class;
        synchronized (ThemeDownloadManager.class) {
            if (single != null) return single;
            single = new ThemeDownloadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public void addTask(ThemeTask themeTask, DownloadProgressListener downloadProgressListener) {
        try {
            int n;
            HttpGet httpGet = new HttpGet(themeTask.mCoverUrl);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setDefaultCookieStore((CookieStore)ReviewConfig.getCookieStore()).setRedirectStrategy((RedirectStrategy)new CustomRedirectHandler()).build();
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            String string = InputStreamUtils.InputStreamTOString(closeableHttpResponse.getEntity().getContent(), "utf8");
            Pattern pattern = Pattern.compile("(href=\")(.*?)(\">\u4e0b\u8f7d\u5230\u7535\u8111)");
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find() || matcher.groupCount() < 3) {
                return;
            }
            String string2 = matcher.group(2);
            File file = new File(themeTask.mMtzPath);
            file.getParentFile().mkdirs();
            httpGet = new HttpGet(string2);
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            if (file.exists() && file.length() == closeableHttpResponse.getEntity().getContentLength()) {
                downloadProgressListener.done(themeTask);
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            long l = closeableHttpResponse.getEntity().getContentLength();
            byte[] byArray = new byte[4096];
            int n2 = 0;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(closeableHttpResponse.getEntity().getContent());
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
                downloadProgressListener.progress(n2 += n, l);
            }
            fileOutputStream.close();
            bufferedInputStream.close();
            downloadProgressListener.done(themeTask);
        }
        catch (Exception exception) {
            downloadProgressListener.cancelled();
            exception.printStackTrace();
        }
    }
}

