/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.review;

import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserCommandEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowOpeningEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import com.miui.theme.tool.gui.CommonRightPanel;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.review.JS;
import com.miui.theme.tool.review.ReviewConfig;
import com.miui.theme.tool.review.ReviewDetailPanel;
import com.miui.theme.tool.review.ThemeDownloadManager;
import com.miui.theme.tool.review.ThemeTask;
import com.miui.theme.tool.util.DownloadProgressListener;
import com.miui.theme.tool.util.Log;
import com.miui.theme.tool.util.ShortcutManager;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;

public class ReviewWebPanel
extends CommonRightPanel {
    public JWebBrowser mBrowser;
    public static String REVIEW_ROOT = "http://admin.n.miui.com";
    public static String REVIEW_URL = "http://admin.n.miui.com/theme/audit/list?auditType=add&category=theme";
    public static String DOWNLOAD_URL_PRE = "http://file.market.miui.srv/download/ThemeMarket/";
    public static String DETAIL_URL_PRE = "http://admin.n.miui.com/theme/audit/";
    public static String LIST_URL_PRE = "http://admin.n.miui.com/theme/audit/list";
    public static String sReviewUrl;
    public static String sDownloadUrlPre;
    public static String sDetailUrlPre;
    public static ExecutorService sThreadPool;
    public static Vector<String> sDeleteQueue;
    private ShortcutManager.ShortcutListener mShortcutListener = new ShortcutManager.ShortcutListener(){

        @Override
        public void handle() {
            NewMainFrame.getInstance().getMainPanel().switchTab("web");
        }
    };
    private WebBrowserAdapter wba = new WebBrowserAdapter(){

        @Override
        public void windowWillOpen(WebBrowserWindowWillOpenEvent webBrowserWindowWillOpenEvent) {
            webBrowserWindowWillOpenEvent.getNewWebBrowser().addWebBrowserListener(new WebBrowserAdapter(){

                @Override
                public void locationChanging(WebBrowserNavigationEvent webBrowserNavigationEvent) {
                    final JWebBrowser jWebBrowser = webBrowserNavigationEvent.getWebBrowser();
                    jWebBrowser.removeWebBrowserListener(this);
                    String string = webBrowserNavigationEvent.getNewResourceLocation();
                    boolean bl = false;
                    if (string.startsWith(DETAIL_URL_PRE) && !string.startsWith(LIST_URL_PRE)) {
                        bl = true;
                        ReviewWebPanel.this.mBrowser.navigate(string);
                    }
                    if (string.startsWith(DOWNLOAD_URL_PRE)) {
                        bl = true;
                        Log.l("start downloading");
                    }
                    if (bl) {
                        webBrowserNavigationEvent.consume();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                jWebBrowser.getWebBrowserWindow().dispose();
                            }
                        });
                    }
                }
            });
        }

        @Override
        public void windowOpening(WebBrowserWindowOpeningEvent webBrowserWindowOpeningEvent) {
        }

        @Override
        public void windowClosing(WebBrowserEvent webBrowserEvent) {
            Log.l("closing");
        }

        @Override
        public void titleChanged(WebBrowserEvent webBrowserEvent) {
        }

        @Override
        public void statusChanged(WebBrowserEvent webBrowserEvent) {
        }

        @Override
        public void locationChanging(WebBrowserNavigationEvent webBrowserNavigationEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void locationChanged(WebBrowserNavigationEvent webBrowserNavigationEvent) {
            try {
                String string = webBrowserNavigationEvent.getWebBrowser().getResourceLocation();
                if (webBrowserNavigationEvent.getNewResourceLocation().equals(string)) {
                    return;
                }
                Log.l(webBrowserNavigationEvent.getNewResourceLocation() + " --------------- " + string);
                if (string.startsWith(LIST_URL_PRE) && !string.contains("auditState=mtzApproved")) {
                    ReviewWebPanel.this.mBrowser.executeJavascript(JS.listPageDownload());
                    Log.l(JS.editDownloadedTheme());
                    ReviewWebPanel.this.mBrowser.executeJavascript(JS.listPageView());
                    ReviewWebPanel.this.mBrowser.executeJavascript(JS.editDownloadedTheme());
                    ReviewWebPanel.this.mBrowser.executeJavascript(JS.jsLoaded());
                }
            }
            finally {
                ReviewConfig.saveCookie();
            }
        }

        @Override
        public void locationChangeCanceled(WebBrowserNavigationEvent webBrowserNavigationEvent) {
        }

        @Override
        public void loadingProgressChanged(WebBrowserEvent webBrowserEvent) {
        }

        @Override
        public void commandReceived(WebBrowserCommandEvent webBrowserCommandEvent) {
            Object object2;
            String string;
            String string2;
            Object[] objectArray;
            String string3 = webBrowserCommandEvent.getCommand();
            Object[] objectArray2 = webBrowserCommandEvent.getParameters();
            if (string3.equals("download")) {
                objectArray = (Object[])objectArray2[0];
                string2 = (String)objectArray2[1];
                string = (String)objectArray2[2];
                object2 = new ThemeTask((String)objectArray, REVIEW_ROOT + string2, string);
                ReviewWebPanel.this.mBrowser.executeJavascript(JS.showDownloadStarting((String)objectArray));
                new Thread((ThemeTask)object2){
                    final /* synthetic */ ThemeTask val$tt;
                    {
                        this.val$tt = themeTask;
                    }

                    @Override
                    public void run() {
                        ThemeDownloadManager.getInstance().addTask(this.val$tt, new ThemeDownloadListener(this.val$tt));
                    }
                }.start();
            } else if (string3.equals("view")) {
                System.gc();
                objectArray = (String)objectArray2[0];
                string2 = (String)objectArray2[1];
                string = (String)objectArray2[2];
                object2 = (String)objectArray2[3];
                String string4 = (String)objectArray2[4];
                ThemeTask themeTask = new ThemeTask((String)objectArray, REVIEW_ROOT + string2, string);
                themeTask.mType = object2;
                themeTask.mCoverIds = string4;
                themeTask.mSourceUrl = ReviewWebPanel.this.mBrowser.getResourceLocation();
                ReviewDetailPanel reviewDetailPanel = new ReviewDetailPanel(themeTask);
                NewMainFrame.getInstance().getMainPanel().switchTab(reviewDetailPanel);
            }
            Log.l(string3);
            if (objectArray2 == null) {
                return;
            }
            for (Object object2 : objectArray2) {
                Log.l(object2.toString());
            }
        }
    };

    public ReviewWebPanel() {
        this.initBrowser();
        int n = 50;
        double[][] dArrayArray = new double[][]{{n, -1.0, n}, {n, -1.0, n}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.add((Component)this.mBrowser, "1, 1");
    }

    private void initBrowser() {
        ReviewConfig.initCookie();
        this.mBrowser = new JWebBrowser(JWebBrowser.destroyOnFinalization(), JWebBrowser.proxyComponentHierarchy());
        this.mBrowser.setMenuBarVisible(false);
        this.mBrowser.navigate(REVIEW_URL);
        this.mBrowser.addWebBrowserListener(this.wba);
        if (ThemeHelper.isDebugMode()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ShortcutManager.getInstance().addShortcutListener(ReviewWebPanel.this.mShortcutListener, 8);
                }
            });
        }
    }

    private void debug() {
        String string = "http://auto.n.miui.com/theme/display.php?id=0068eb09-71b6-4ae9-a38a-169b73a65407";
        String string2 = "/theme/audit/c44d4ffc-7bd5-46e2-8138-2fbaf7caabb5";
        ThemeTask themeTask = new ThemeTask(string, string2, "Test");
        themeTask.mType = "aries";
        ReviewDetailPanel reviewDetailPanel = new ReviewDetailPanel(themeTask);
        NewMainFrame.getInstance().getMainPanel().switchTab(reviewDetailPanel);
    }

    public synchronized void processDeleteQueue() {
        for (String string : sDeleteQueue) {
            this.mBrowser.executeJavascript(JS.deleteItem(string));
        }
    }

    static {
        sThreadPool = Executors.newFixedThreadPool(10);
        sDeleteQueue = new Vector();
    }

    class ThemeDownloadListener
    implements DownloadProgressListener {
        private ThemeTask mThemeTask;

        public ThemeDownloadListener(ThemeTask themeTask) {
            this.mThemeTask = themeTask;
        }

        @Override
        public void progress(final long l, final long l2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = (int)(100.0 * (double)l / (double)l2);
                    if (n % 5 == 0) {
                        ReviewWebPanel.this.mBrowser.executeJavascript(JS.showDownloadProgress(((ThemeDownloadListener)ThemeDownloadListener.this).mThemeTask.mTestDetailUrl, n));
                    }
                }
            });
        }

        @Override
        public void done(Object object) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReviewConfig.setThemeDownloaded(((ThemeDownloadListener)ThemeDownloadListener.this).mThemeTask.mID, ((ThemeDownloadListener)ThemeDownloadListener.this).mThemeTask.mCoverUrl);
                    ReviewWebPanel.this.mBrowser.executeJavascript(JS.showDownloadDone(((ThemeDownloadListener)ThemeDownloadListener.this).mThemeTask.mTestDetailUrl));
                }
            });
        }

        @Override
        public void cancelled() {
        }
    }
}

