/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.review;

import com.miui.theme.tool.util.DownloadProgressListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class DownloadImageTask
implements Runnable {
    private DownloadProgressListener mDownloadProgressListener;
    private URL mUrl;
    private InputStream mUrlStream;
    private OutputStream mDestFileStream;
    private URLConnection mUrlConnection;
    public static final int BLOCK_SIZE = 4096;
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_TYPE_VALUE = "binary/data";
    public static final int DOWNLOAD_TIMEOUT = 5000;

    public DownloadImageTask(String string, OutputStream outputStream) throws IOException {
        this(string);
        this.mDestFileStream = outputStream;
    }

    public DownloadImageTask(String string) throws IOException {
        this.mUrl = new URL(string);
        this.mUrlConnection = this.mUrl.openConnection();
        this.mUrlConnection.setConnectTimeout(5000);
        this.mUrlConnection.setDoOutput(true);
        this.mUrlConnection.setDoInput(true);
        this.mUrlConnection.setRequestProperty(CONTENT_TYPE, CONTENT_TYPE_VALUE);
        this.mUrlStream = this.mUrl.openStream();
    }

    public void setDestFileStream(OutputStream outputStream) {
        this.mDestFileStream = outputStream;
    }

    public int getFileSize() {
        return this.mUrlConnection.getContentLength();
    }

    @Override
    public void run() {
        int n = this.mUrlConnection.getContentLength();
        byte[] byArray = new byte[4096];
        int n2 = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.mUrlStream);
        try {
            int n3;
            while ((n3 = bufferedInputStream.read(byArray)) != -1) {
                this.mDestFileStream.write(byArray, 0, n3);
                this.mDownloadProgressListener.progress(n2 += n3, n);
            }
            this.mUrlStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.done();
    }

    protected void done() {
        try {
            this.mDestFileStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.mDownloadProgressListener != null) {
            this.mDownloadProgressListener.done(this);
        }
    }

    public void setDownloadProgressListener(DownloadProgressListener downloadProgressListener) {
        this.mDownloadProgressListener = downloadProgressListener;
    }
}

