/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.resourceeditor.Resource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ScreenshotXml
implements Comparable<ScreenshotXml> {
    public static String SCREENSHOT_SUFFIX = ".jpg";
    public static float SCREENSHOT_QUALITY = 0.85f;
    String mVersion = "";
    String mDescription = "";
    String mAnnotation = "";
    String mTag = "";
    Vector<Resource> mResources = new Vector();
    File mFile;
    File mXmlFile;
    public static String SCREENSHOT_TAGNAME = "screenshot";
    public static String SCREENSHOT_DESCRIPTION = "description";
    public static String SCREENSHOT_ANNOTATION = "annotation";
    public static String SCREENSHOT_TAG = "tag";
    public static String SCREENSHOT_VERSION = "version";
    private boolean mIsLoaded = false;

    public ScreenshotXml(File file, File file2) {
        this.mFile = file;
        this.mXmlFile = file2;
    }

    public void parse() {
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(this.mXmlFile);
            Element element = document.getRootElement();
            this.mVersion = element.getAttributeValue(SCREENSHOT_VERSION);
            this.mVersion = this.mVersion == null ? "" : this.mVersion;
            this.mDescription = element.getAttributeValue(SCREENSHOT_DESCRIPTION);
            this.mDescription = this.mDescription == null ? "" : this.mDescription;
            this.mAnnotation = element.getAttributeValue(SCREENSHOT_ANNOTATION);
            this.mAnnotation = this.mAnnotation == null ? "" : this.mAnnotation;
            this.mTag = element.getAttributeValue(SCREENSHOT_TAG);
            this.mTag = this.mTag == null ? "" : this.mTag;
            for (Element element2 : element.getChildren()) {
                Resource resource = new Resource();
                resource.parse(element2);
                this.mResources.add(resource);
            }
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String toString() {
        return this.mDescription;
    }

    public void save() {
        Element element = new Element(SCREENSHOT_TAGNAME);
        element.setAttribute(SCREENSHOT_DESCRIPTION, this.mDescription);
        element.setAttribute(SCREENSHOT_VERSION, this.mVersion);
        element.setAttribute(SCREENSHOT_ANNOTATION, this.mAnnotation);
        element.setAttribute(SCREENSHOT_TAG, this.mTag);
        for (Resource object : this.mResources) {
            element.addContent((Content)object.getElement());
        }
        XMLOutputter xMLOutputter = new XMLOutputter();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.mXmlFile);
            Format fileNotFoundException = Format.getPrettyFormat();
            fileNotFoundException.setEncoding("UTF-8");
            fileNotFoundException.setIndent("    ");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            xMLOutputter.setFormat(fileNotFoundException);
            xMLOutputter.output(new Document(element), (Writer)outputStreamWriter);
            fileOutputStream.close();
        }
        catch (FileNotFoundException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (UnsupportedEncodingException iOException) {
            iOException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public int compareTo(ScreenshotXml screenshotXml) {
        return this.mDescription.compareTo(screenshotXml.mDescription);
    }

    public synchronized void matchResource(String string) {
        if (this.mIsLoaded) {
            return;
        }
        for (Resource resource : this.mResources) {
            resource.matchResource(string);
        }
        this.mIsLoaded = true;
    }
}

