/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Rectangle;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import org.jdom2.Content;
import org.jdom2.Element;

class Resource
implements Comparable<Resource> {
    int mX;
    int mY;
    int mWidth = 200;
    int mHeight = 200;
    String mDescription = ResourceFactory.getString("default");
    UUID mUUID = null;
    Vector<String> mPaths = new Vector();
    Vector<String> mPathDescriptions = new Vector();
    public static String RESOURCE_TAGNAME = "resource";
    public static String PATH_TAGNAME = "path";
    public static String PATH_SRC = "src";
    public static String PATH_DESCRIPTION = "description";
    public static String RESOURCE_DESCRIPTION = "description";
    public static String RESOURCE_UUID = "uuid";
    public static String RESOURCE_X = "x";
    public static String RESOURCE_Y = "y";
    public static String RESOURCE_WIDTH = "width";
    public static String RESOURCE_HEIGHT = "height";
    public static String RESOURCE_PATH = "path";

    public Resource() {
    }

    public Resource(Resource resource) {
        this.mX = resource.mX;
        this.mY = resource.mY;
        this.mWidth = resource.mWidth;
        this.mHeight = resource.mHeight;
        this.mDescription = resource.mDescription;
        this.mUUID = UUID.randomUUID();
        this.mPaths = new Vector<String>(resource.mPaths);
        this.mPathDescriptions = new Vector<String>(resource.mPathDescriptions);
    }

    public void parse(Element element) {
        this.mX = Integer.parseInt(element.getAttributeValue(RESOURCE_X));
        this.mY = Integer.parseInt(element.getAttributeValue(RESOURCE_Y));
        this.mWidth = Integer.parseInt(element.getAttributeValue(RESOURCE_WIDTH));
        this.mHeight = Integer.parseInt(element.getAttributeValue(RESOURCE_HEIGHT));
        this.mDescription = element.getAttributeValue(PATH_DESCRIPTION);
        this.mUUID = UUID.fromString(element.getAttributeValue(RESOURCE_UUID));
        for (Element element2 : element.getChildren()) {
            this.mPaths.add(element2.getAttributeValue(PATH_SRC));
            this.mPathDescriptions.add(element2.getAttributeValue(PATH_DESCRIPTION));
        }
        this.assurePath();
    }

    public void assurePath() {
        for (int i = 0; i < this.mPaths.size(); ++i) {
            String string = this.mPaths.get(i);
            string = ThemeHelper.assurePath(string);
            this.mPaths.set(i, string);
        }
    }

    public String toString() {
        return this.mDescription;
    }

    public Element getElement() {
        Element element = new Element(RESOURCE_TAGNAME);
        element.setAttribute(RESOURCE_DESCRIPTION, this.mDescription);
        element.setAttribute(RESOURCE_X, this.mX + "");
        element.setAttribute(RESOURCE_Y, this.mY + "");
        element.setAttribute(RESOURCE_WIDTH, this.mWidth + "");
        element.setAttribute(RESOURCE_HEIGHT, this.mHeight + "");
        element.setAttribute(RESOURCE_UUID, this.mUUID.toString());
        for (int i = 0; i < this.mPaths.size(); ++i) {
            Element element2 = new Element(PATH_TAGNAME);
            element2.setAttribute(PATH_SRC, this.mPaths.get(i));
            String string = "";
            try {
                string = this.mPathDescriptions.get(i);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.print(".");
            }
            element2.setAttribute(PATH_DESCRIPTION, string);
            element.addContent((Content)element2);
        }
        return element;
    }

    @Override
    public int compareTo(Resource resource) {
        Rectangle rectangle = new Rectangle(this.mX, this.mY, this.mWidth, this.mHeight);
        Rectangle rectangle2 = new Rectangle(resource.mX, resource.mY, resource.mWidth, resource.mHeight);
        if (rectangle.contains(rectangle2)) {
            return 1;
        }
        if (rectangle2.contains(rectangle)) {
            return -1;
        }
        return 0;
    }

    public void matchResource(String string) {
        Object object;
        final HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (int i = 0; i < this.mPaths.size(); ++i) {
            object = this.mPaths.get(i);
            File file = new File(string + File.separator + (String)object);
            if (!hashMap.containsKey(file.getName())) {
                hashMap.put(file.getName(), i);
            }
            hashMap2.put(file.getName(), this.mPathDescriptions.get(i));
        }
        Vector<String> vector = this.seekResourcePath(new File(string), hashMap.keySet());
        Collections.sort(vector, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                Integer n = (Integer)hashMap.get(new File(string).getName());
                Integer n2 = (Integer)hashMap.get(new File(string2).getName());
                return n.compareTo(n2);
            }
        });
        object = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)hashMap2.get(new File(vector.get(i)).getName());
            if (string2 == null) {
                string2 = "";
            }
            ((Vector)object).add(i, string2);
            vector.set(i, vector.get(i).substring(string.length() + 1));
        }
        this.mPathDescriptions = object;
        this.mPaths = vector;
    }

    private Vector<String> seekResourcePath(File file, Set<String> set) {
        Vector<String> vector = new Vector<String>();
        if (!file.exists()) {
            return vector;
        }
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                vector.addAll(this.seekResourcePath(file2, set));
                continue;
            }
            if (!file2.isFile() || !set.contains(file2.getName())) continue;
            vector.add(file2.getPath());
        }
        return vector;
    }
}

