/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.gui.PSBGLabel;
import com.miui.theme.tool.gui.ResourceReplacePanel;
import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.gui.skin.ThemeLookAndFeel;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.FileDrop;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ModuleResourceReplacePanel
extends ResourceReplacePanel {
    public static final int REPLACE_ICON_SIZE = 65;
    private String mDescription;
    private MouseListener mRightClickMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                PSBGLabel pSBGLabel = (PSBGLabel)mouseEvent.getSource();
                pSBGLabel.nextBackground();
            }
        }
    };

    public ModuleResourceReplacePanel(String string, String string2, File file, File file2, ResourceReplacePanel.ReplaceActionListener replaceActionListener) {
        super(string, file, file2, replaceActionListener);
        this.mUnreplaceButton.setBorder(mBorder);
        this.mDescription = string2;
        this.initPanel();
    }

    private void initPanel() {
        double[][] dArrayArray = new double[][]{{32.0, 65.0, 28.0, 39.0, 28.0, 65.0, -1.0, 14.0, 30.0}, {4.0, 20.0, 20.0, 4.0, 65.0, 20.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        int n = 1;
        JLabel jLabel = new JLabel(this.mName);
        jLabel.setFont(ThemeLookAndFeel.getFont(12.0f));
        this.add((Component)jLabel, "1, " + n + ", 8, " + n);
        JLabel jLabel2 = new JLabel(this.mDescription);
        jLabel2.setForeground(GUIUtil.hex2color("#808080"));
        jLabel2.setFont(ThemeLookAndFeel.getFont(11.0f));
        this.add((Component)jLabel2, "1, " + ++n + ", 8, " + n);
        n += 2;
        ImageIcon imageIcon = GUIUtil.getIcon(this.mCatalogFile, 65, 4);
        this.mCatalogIconLabel = new PSBGLabel(imageIcon);
        this.mCatalogIconLabel.setBorder(mBorder);
        this.mCatalogIconLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.mCatalogIconLabel.addMouseListener(new ResourceReplacePanel.OpenInExplorerMouseAdapter(this.mCatalogFile));
        this.mCatalogIconLabel.setToolTipText(ResourceFactory.getString("RightClickChangeBackground"));
        this.mCatalogIconLabel.addMouseListener(this.mRightClickMouseListener);
        this.add((Component)this.mCatalogIconLabel, "1, " + n);
        this.mCopyButton.addActionListener(new ResourceReplacePanel.CopyResourceActionListener(this.mCatalogFile.getAbsolutePath(), this.mReplaceFile.getAbsolutePath()));
        this.add((Component)this.mCopyButton, "3, " + n);
        if (this.mReplaceFile.exists()) {
            this.mReplaceIconLabel = new PSBGLabel(GUIUtil.getIcon(this.mReplaceFile, 65, 4));
            this.mReplaceIconLabel.setBorder(mBorder);
            this.mReplaceIconLabel.addMouseListener(new ResourceReplacePanel.OpenInExplorerMouseAdapter(this.mReplaceFile));
            this.mReplaceIconLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.mReplaceIconLabel.addMouseListener(this.mRightClickMouseListener);
            this.add((Component)this.mReplaceIconLabel, "5, " + n);
            new FileDrop(null, (Component)this.mReplaceIconLabel, this.mReplaceIconLabel.getBorder(), (FileDrop.Listener)new ResourceReplacePanel.FileDropListener(this.mReplaceFile));
        } else {
            this.add((Component)this.mUnreplaceButton, "5, " + n);
            this.mUnreplaceButton.addActionListener(this.dhal);
            new FileDrop(null, (Component)this.mUnreplaceButton, this.mUnreplaceButton.getBorder(), (FileDrop.Listener)new ResourceReplacePanel.FileDropListener(this.mReplaceFile));
        }
        this.mEditPanel = this.getEditPanel();
        this.add((Component)this.mEditPanel, "7, " + n);
    }

    protected JPanel getEditPanel() {
        TransparentPanel transparentPanel = new TransparentPanel();
        double[][] dArrayArray = new double[][]{{-1.0}, {0.0, 14.0, -1.0, 14.0, -1.0, 14.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        transparentPanel.setLayout(tableLayout);
        if (this.mReplaceFile.exists()) {
            this.mDeleteButton.addActionListener(this.dfal);
            this.mDeleteButton.setHorizontalAlignment(2);
            transparentPanel.add((Component)this.mDeleteButton, "0, 3");
            if (this.mReplaceFile.getAbsolutePath().endsWith(ThemeHelper.NINE_PATCH_SUFFIX)) {
                this.mEditButton.addActionListener(this.enpal);
                transparentPanel.add((Component)this.mEditButton, "0, 5");
            }
        }
        this.mSelectButton.addActionListener(this.rial);
        transparentPanel.add((Component)this.mSelectButton, "0, 1");
        return transparentPanel;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(GUIUtil.SEP_LINE_COLOR);
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }
}

