/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.gui.CommonRightPanel;
import com.miui.theme.tool.gui.ConfirmDialog;
import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.gui.WrapLayout;
import com.miui.theme.tool.gui.main.ModuleRightPanel;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.gui.main.PhoneSnapshotPanel;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.RefreshPageListener;
import com.miui.theme.tool.resourceeditor.ThemeValuesEditPage;
import com.miui.theme.tool.resourceeditor.ThemeValuesList;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.TextUtils;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CenterThemeValuesPanel
extends ModuleRightPanel {
    private ThemeValuesList mThemeValuesList;
    private JScrollPane mThemeValueScrollPane;
    private ThemeValuesEditPage mThemeValuesEditPage;
    private PhoneSnapshotPanel mPhoneSnapshotPanel;
    private JPanel mButtonAreaPanels;
    private JButton mShowingStringScopeBtn;
    private ListSelectionListener mListSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (CenterThemeValuesPanel.this.mThemeValuesList.getSelectedIndex() < 0) {
                return;
            }
            CenterThemeValuesPanel.this.refreshEditPage();
        }
    };
    private RefreshPageListener mRefreshPageListener = new RefreshPageListener(){

        @Override
        public void onRefresh() {
            CenterThemeValuesPanel.this.refreshEditPage();
        }
    };

    private void refreshEditPage() {
        this.mThemeValuesEditPage.refreshValue();
        String string = this.mThemeValuesList.getSnapshotTextOfCurrentValue();
        if (string != null) {
            this.mPhoneSnapshotPanel.updateSelectTextArea(string);
        }
    }

    public CenterThemeValuesPanel(ThemeValuesList themeValuesList) {
        this.mThemeValuesEditPage = new ThemeValuesEditPage(themeValuesList);
        this.mThemeValuesList = themeValuesList;
        this.mThemeValuesList.addListSelectionListener(this.mListSelectionListener);
        this.mThemeValuesList.setRefreshPageListener(this.mRefreshPageListener);
        this.mPhoneSnapshotPanel = new PhoneSnapshotPanel();
        this.mPhoneSnapshotPanel.setSnapshotStateChangeListener(new PhoneSnapshotPanel.SnapshotStateChangeListener(){
            private boolean packageNameMatched = false;

            @Override
            public void onTextSelected(String string) {
                if (this.packageNameMatched && CenterThemeValuesPanel.this.mThemeValuesList.isSnapshotFilteredMode()) {
                    CenterThemeValuesPanel.this.mThemeValuesList.selectThemeStringItemBySnapshotText(string);
                }
            }

            @Override
            public void onFinishObtainSnasphot(String string, List<String> list) {
                this.packageNameMatched = CenterThemeValuesPanel.this.mThemeValuesList.getPackageName().equals(string);
                if (this.packageNameMatched) {
                    CenterThemeValuesPanel.this.mThemeValuesList.setSnapshotTextList(list);
                    CenterThemeValuesPanel.this.mThemeValuesList.updateShowingContent(true);
                } else if ("android".equals(string)) {
                    GUIUtil.toastLong(ResourceFactory.getString("switch_module_by_snapshot_android_alert_msg"));
                } else if (TextUtils.isEmpty(string)) {
                    GUIUtil.alert(ResourceFactory.getString("warn_msg_obtain_phone_snapshot"));
                    CenterThemeValuesPanel.this.mThemeValuesList.updateShowingContent(false);
                } else {
                    ConfirmDialog confirmDialog = new ConfirmDialog(ResourceFactory.getString("switch_module_by_snapshot_title"), ResourceFactory.getString("switch_module_by_snapshot_msg"));
                    confirmDialog.setVisible(true);
                    if (confirmDialog.mResult.equals("yes")) {
                        NewMainFrame.getInstance().getMainPanel().switchTab(string, "string");
                    } else {
                        CenterThemeValuesPanel.this.mThemeValuesList.updateShowingContent(false);
                    }
                }
                CenterThemeValuesPanel.this.updateShowingStringScopeBtnState();
            }

            @Override
            public void onBeginObtainSnapshot() {
            }
        });
        this.initLayout();
        this.layoutThemeStringOperationBtn();
        this.layoutList();
    }

    private void initLayout() {
        double[][] dArrayArray = new double[][]{{400.0, 1.0, 450.0, -1.0}, {80.0, 160.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.add((Component)this.getSepPanel(), "1, 0, 1, 2");
    }

    private void layoutThemeStringOperationBtn() {
        this.mButtonAreaPanels = new TransparentPanel();
        this.mButtonAreaPanels.setLayout(new WrapLayout(1, 20, 20));
        JButton jButton = this.createOperationBtn("snapshot_refresh");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CenterThemeValuesPanel.this.mPhoneSnapshotPanel.refreshSnapshot();
            }
        });
        this.mButtonAreaPanels.add(jButton);
        this.mShowingStringScopeBtn = this.createOperationBtn("snapshot_expand_filted_string");
        this.mShowingStringScopeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CenterThemeValuesPanel.this.mThemeValuesList.isSnapshotFilteredMode()) {
                    CenterThemeValuesPanel.this.mThemeValuesList.updateShowingContent(false);
                } else {
                    CenterThemeValuesPanel.this.mThemeValuesList.setSnapshotTextList(CenterThemeValuesPanel.this.mPhoneSnapshotPanel.getSnapshotTextList());
                    CenterThemeValuesPanel.this.mThemeValuesList.updateShowingContent(true);
                }
                CenterThemeValuesPanel.this.updateShowingStringScopeBtnState();
            }
        });
        this.mButtonAreaPanels.add(this.mShowingStringScopeBtn);
        this.add((Component)this.mButtonAreaPanels, "0, 0");
        this.mButtonAreaPanels.setVisible(false);
        this.updateShowingStringScopeBtnState();
    }

    private void updateShowingStringScopeBtnState() {
        if (this.mThemeValuesList.getPackageName().equals(this.mPhoneSnapshotPanel.getSnapshotPackageName())) {
            this.mShowingStringScopeBtn.setEnabled(true);
            this.mShowingStringScopeBtn.setText(this.mThemeValuesList.isSnapshotFilteredMode() ? ResourceFactory.getString("snapshot_expand_all_string") : ResourceFactory.getString("snapshot_expand_filted_string"));
        } else {
            this.mShowingStringScopeBtn.setEnabled(false);
        }
    }

    private JButton createOperationBtn(String string) {
        ImageIcon imageIcon = ResourceFactory.getInstance().getImageIcon("editinfo/btn_n.png");
        ImageIcon imageIcon2 = ResourceFactory.getInstance().getImageIcon("editinfo/btn_p.png");
        JButton jButton = GUIUtil.createTransparentButton(imageIcon, imageIcon2, imageIcon2, null);
        jButton.setText(ResourceFactory.getString(string));
        jButton.setHorizontalTextPosition(0);
        return jButton;
    }

    private void layoutList() {
        double[][] dArrayArray = new double[][]{{16.0, -1.0, 16.0}, {-1.0, 16.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        CommonRightPanel commonRightPanel = new CommonRightPanel();
        commonRightPanel.setLayout(tableLayout);
        this.mThemeValueScrollPane = new JScrollPane(this.mThemeValuesList);
        this.mThemeValueScrollPane.setHorizontalScrollBarPolicy(31);
        commonRightPanel.add((Component)this.mThemeValueScrollPane, "1, 0");
        this.add((Component)commonRightPanel, "0, 1, 0, 2");
    }

    private void layoutEditPanel() {
        if ("string".equals(this.mThemeValuesList.getFilteredResourceType())) {
            this.add((Component)this.mThemeValuesEditPage, "2, 0, 2, 2");
        } else {
            this.add((Component)this.mThemeValuesEditPage, "2, 0, 3, 2");
        }
    }

    private void layoutSnapshotPanel() {
        this.remove(this.mPhoneSnapshotPanel);
        this.mButtonAreaPanels.setVisible(false);
        if (this.mThemeValuesList.canHaveSnapshotView()) {
            this.add((Component)this.mPhoneSnapshotPanel, "3, 0, 3, 2");
            this.mPhoneSnapshotPanel.updateSnapshotView(this.mThemeValuesList.getPackageName());
            this.mButtonAreaPanels.setVisible(true);
        }
    }

    public void refreshUI() {
        this.mThemeValueScrollPane.getVerticalScrollBar().setValue(0);
        this.mThemeValuesEditPage.removeAll();
        this.layoutEditPanel();
        this.layoutSnapshotPanel();
    }
}

