/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resource;

import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.GUIUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ResourceFactory {
    public static final String RESOURCE_FILE = "resource";
    private static ResourceBundle mResourceBundle;
    public static Locale sLocale;
    private static volatile ResourceFactory single;

    public static boolean isLangEnUs() {
        return sLocale.getLanguage().equals("en") && sLocale.getCountry().equals("US");
    }

    public static boolean isLangZhCn() {
        return sLocale.getLanguage().equals("zh") && sLocale.getCountry().equals("CN");
    }

    public static String getString(String string) {
        if (mResourceBundle.containsKey(string)) {
            return mResourceBundle.getString(string);
        }
        return "";
    }

    public static boolean containsKey(String string) {
        return mResourceBundle.containsKey(string);
    }

    public static void setLocale(Locale locale) {
        sLocale = locale;
        mResourceBundle = sLocale == null ? ResourceBundle.getBundle(RESOURCE_FILE) : ResourceBundle.getBundle(RESOURCE_FILE, sLocale);
    }

    public BufferedImage getImage(String string) {
        return GUIUtil.getImage(this.getResourceSream(string));
    }

    public InputStream getResourceSream(String string) {
        return this.getClass().getResourceAsStream(string);
    }

    public String getResourceFile(String string) {
        return this.getClass().getResource(string).getFile();
    }

    public ImageIcon getImageIcon(String string) {
        InputStream inputStream = this.getResourceSream(string);
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return new ImageIcon(bufferedImage);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            try {
                inputStream.close();
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceFactory getInstance() {
        if (single != null) return single;
        Class<ResourceFactory> clazz = ResourceFactory.class;
        synchronized (ResourceFactory.class) {
            if (single != null) return single;
            single = new ResourceFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    static {
        String[] stringArray;
        sLocale = null;
        String string = ConfigUtil.get("preference", "Lang");
        if (!string.isEmpty() && (stringArray = string.split("_")).length == 2) {
            sLocale = new Locale(stringArray[0], stringArray[1]);
        }
        if (sLocale == null) {
            sLocale = Locale.getDefault();
            if (!ResourceFactory.isLangZhCn() && !ResourceFactory.isLangEnUs()) {
                sLocale = new Locale("en", "US");
            }
        }
        mResourceBundle = ResourceBundle.getBundle(RESOURCE_FILE, sLocale);
    }
}

