/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.phone.uiautomator;

import com.android.ddmlib.IDevice;
import com.miui.theme.tool.phone.uiautomator.IProgressMonitor;
import com.miui.theme.tool.phone.uiautomator.NullProgressMonitor;
import com.miui.theme.tool.phone.uiautomator.UiAutomatorHelper;
import com.miui.theme.tool.phone.uiautomator.UiAutomatorModel;
import java.awt.image.BufferedImage;

public class UiAutomatorInstance {
    private boolean mUpdating;
    private UiAutomatorModel mModel;
    private BufferedImage mImage;
    private static UiAutomatorInstance sInstance = new UiAutomatorInstance();

    private UiAutomatorInstance() {
    }

    public static UiAutomatorInstance getInstance() {
        return sInstance;
    }

    public UiAutomatorModel getAutomatorModel() {
        return this.mModel;
    }

    public BufferedImage getSnapshotImage() {
        return this.mImage;
    }

    public synchronized void updateAutomatorData(IDevice iDevice, IProgressMonitor iProgressMonitor) throws Exception {
        if (this.mUpdating) {
            throw new Exception("Global automator data is updating.");
        }
        this.mUpdating = true;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask();
        UiAutomatorHelper.UiAutomatorResult uiAutomatorResult = UiAutomatorHelper.takeSnapshot(iDevice, iProgressMonitor, true);
        this.mModel = uiAutomatorResult != null ? uiAutomatorResult.model : null;
        this.mImage = uiAutomatorResult != null ? uiAutomatorResult.screenshot : null;
        this.mUpdating = false;
        iProgressMonitor.done();
    }

    public boolean isUpdating() {
        return this.mUpdating;
    }
}

