/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.phone.uiautomator;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.SyncService;
import com.miui.theme.tool.phone.tree.BasicTreeNode;
import com.miui.theme.tool.phone.tree.RootWindowNode;
import com.miui.theme.tool.phone.uiautomator.IProgressMonitor;
import com.miui.theme.tool.phone.uiautomator.NullProgressMonitor;
import com.miui.theme.tool.phone.uiautomator.UiAutomatorModel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class UiAutomatorHelper {
    public static final int UIAUTOMATOR_MIN_API_LEVEL = 16;
    private static final String UIAUTOMATOR = "/system/bin/uiautomator";
    private static final String UIAUTOMATOR_DUMP_COMMAND = "dump";
    private static final String UIDUMP_DEVICE_PATH = "/data/local/tmp/uidump.xml";
    private static final int XML_CAPTURE_TIMEOUT_SEC = 40;

    private static boolean supportsUiAutomator(IDevice iDevice) {
        int n;
        String string = iDevice.getProperty("ro.build.version.sdk");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 16;
        }
        return n >= 16;
    }

    private static void getUiHierarchyFile(IDevice iDevice, File file, IProgressMonitor iProgressMonitor) {
        CountDownLatch countDownLatch;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.subTask("Deleting old UI XML snapshot ...");
        String string = "rm /data/local/tmp/uidump.xml";
        try {
            countDownLatch = new CountDownLatch(1);
            iDevice.executeShellCommand(string, (IShellOutputReceiver)new CollectingOutputReceiver(countDownLatch));
            countDownLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        iProgressMonitor.subTask("Taking UI XML snapshot...");
        string = String.format("%s %s %s", UIAUTOMATOR, UIAUTOMATOR_DUMP_COMMAND, UIDUMP_DEVICE_PATH);
        countDownLatch = new CountDownLatch(1);
        try {
            iDevice.executeShellCommand(string, (IShellOutputReceiver)new CollectingOutputReceiver(countDownLatch), 40L, TimeUnit.SECONDS);
            countDownLatch.await(40L, TimeUnit.SECONDS);
            iProgressMonitor.subTask("Pull UI XML snapshot from device...");
            iDevice.getSyncService().pullFile(UIDUMP_DEVICE_PATH, file.getAbsolutePath(), SyncService.getNullProgressMonitor());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static UiAutomatorResult takeSnapshot(IDevice iDevice, IProgressMonitor iProgressMonitor) throws UiAutomatorException {
        return UiAutomatorHelper.takeSnapshot(iDevice, iProgressMonitor, false);
    }

    public static UiAutomatorResult takeSnapshot(IDevice iDevice, IProgressMonitor iProgressMonitor, boolean bl) throws UiAutomatorException {
        RawImage rawImage;
        UiAutomatorModel uiAutomatorModel;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.subTask("Checking if device support UI Automator ...");
        if (!UiAutomatorHelper.supportsUiAutomator(iDevice)) {
            String string = "UI Automator requires a device with API Level 16";
            throw new UiAutomatorException(string, null);
        }
        iProgressMonitor.subTask("Creating temporary files for uiautomator results  ...");
        File file = null;
        File file2 = null;
        File file3 = null;
        try {
            file = File.createTempFile("uiautomatorviewer_", "");
            file.delete();
            if (!file.mkdirs()) {
                throw new IOException("Failed to mkdir");
            }
            file2 = File.createTempFile("dump_", ".uix", file);
            file3 = File.createTempFile("screenshot_", ".png", file);
        }
        catch (Exception exception) {
            String string = "Error while creating temporary file to save snapshot: " + exception.getMessage();
            throw new UiAutomatorException(string, exception);
        }
        file.deleteOnExit();
        file2.deleteOnExit();
        file3.deleteOnExit();
        iProgressMonitor.subTask("Obtaining UI hierarchy ...");
        try {
            UiAutomatorHelper.getUiHierarchyFile(iDevice, file2, iProgressMonitor);
        }
        catch (Exception exception) {
            String string = "Error while obtaining UI hierarchy XML file: " + exception.getMessage();
            throw new UiAutomatorException(string, exception);
        }
        try {
            uiAutomatorModel = new UiAutomatorModel(file2, bl);
        }
        catch (Exception exception) {
            String string = "Error while parsing UI hierarchy XML file: " + exception.getMessage();
            throw new UiAutomatorException(string, exception);
        }
        iProgressMonitor.subTask("Obtaining device screenshot ...");
        try {
            rawImage = iDevice.getScreenshot();
        }
        catch (Exception exception) {
            String string = "Error taking device screenshot: " + exception.getMessage();
            throw new UiAutomatorException(string, exception);
        }
        BasicTreeNode basicTreeNode = uiAutomatorModel.getXmlRootNode();
        if (basicTreeNode instanceof RootWindowNode) {
            for (int i = 0; i < ((RootWindowNode)basicTreeNode).getRotation(); ++i) {
                rawImage = rawImage.getRotated();
            }
        }
        return new UiAutomatorResult(uiAutomatorModel, UiAutomatorHelper.convertImage(rawImage));
    }

    private static BufferedImage convertImage(RawImage rawImage) {
        System.out.println("RawImage: " + rawImage.width + " vs " + rawImage.height + " depth: " + rawImage.bpp + " data: " + rawImage.data.length);
        BufferedImage bufferedImage = new BufferedImage(rawImage.width, rawImage.height, 6);
        int n = (rawImage.bpp + 7) / 8;
        int n2 = rawImage.width * n;
        for (int i = 0; i < rawImage.height; ++i) {
            for (int j = 0; j < rawImage.width; ++j) {
                int n3 = i * n2 + j * n;
                bufferedImage.setRGB(j, i, rawImage.getARGB(n3));
            }
        }
        return bufferedImage;
    }

    public static class UiAutomatorResult {
        public final UiAutomatorModel model;
        public final BufferedImage screenshot;

        public UiAutomatorResult(UiAutomatorModel uiAutomatorModel, BufferedImage bufferedImage) {
            this.model = uiAutomatorModel;
            this.screenshot = bufferedImage;
        }
    }

    public static class UiAutomatorException
    extends Exception {
        public UiAutomatorException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

