/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.os;

import com.miui.theme.tool.os.LogOutputThread;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.Logger;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class CmdUtils {
    public static Logger logger = new Logger();
    public static final String THEME_LOC = "/sdcard/MIUI/theme/";
    public static final String IMPORT_APPS_APK_FILE = "tools" + File.separator + "ShowApps.apk";
    public static final String IMPORT_APPS_APK_COMPONENT_NAME = "com.miui.themetool/com.miui.themetool.ShowAppsActivity";
    public static final String SHOWAPP_APK_PACKAGE_NAME = "com.miui.themetool";
    public static final String INTENT_GENERATE = "generate";
    public static final String INTENT_GENERATE_APPINFO = "appinfo";
    public static final String INTENT_GENERATE_ICONS = "icons";
    public static final String SYSTEM_THEME_PATH = "/data/system/theme";
    public static final String THEME_NAME = "MIUIThemeToolGenerated.mtz";
    public static final String SYSTEM_THEME_CUSTOMIZED_ICONS_PATH = "/data/system/customized_icons/";
    public static final String SYSTEM_THEME_CLOCK_PATH = "/data/data/com.miui.home/app_clock_bak/*";
    public static final String THEME_WALLPAPER_PATH = "wallpaper" + File.separator + "default_wallpaper.jpg";
    public static final String SYSTEM_WALLPAPER_PATH = "/data/data/com.android.settings/files/wallpaper";
    public static final String JLB_SYSTEM_WALLPAPER_PATH = "/data/system/users/0/wallpaper";
    public static final String THEME_LOCKSCREEN_WALLPAPER_PATH = "wallpaper" + File.separator + "default_lock_wallpaper.jpg";
    public static final String SYSTEM_LOCKSCREEN_WALLPAPER_PATH = "/data/system/theme/lock_wallpaper";

    public static String[] initS() {
        String[] stringArray = new String[3];
        stringArray[0] = "sh";
        stringArray[1] = "-c";
        if (OS.getOS() == 1) {
            stringArray[0] = "cmd";
            stringArray[1] = "/c";
        }
        String string = ThemeHelper.getUserDir();
        string = CmdUtils.convertPathSpace(string);
        stringArray[2] = string + File.separator;
        return stringArray;
    }

    public static String convertPathSpace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ' ') continue;
            string = string.subSequence(0, i) + "\" \"" + string.substring(i + 1, string.length());
            i += 2;
        }
        return string;
    }

    public static boolean adb_push_MIUIThemeToolGenerated(String string, String string2) {
        return CmdUtils.adb_push(string, string2, "/sdcard/MIUI/theme/MIUIThemeToolGenerated.mtz");
    }

    public static boolean adb_shell_applyTheme(String string, boolean bl, long l) {
        String[] stringArray = CmdUtils.initS();
        String string2 = "theme_file_path";
        String string3 = string != null ? "-s " + string : "";
        String string4 = string3 + " shell am start" + " -n com.android.thememanager/com.android.thememanager.ApplyThemeForScreenshot" + " -e \"" + string2 + "\" \"" + THEME_LOC + THEME_NAME + "\" " + " -e \"api_called_from\" \"ThemeEditor_" + ThemeHelper.getVersion() + "\"";
        if (!bl) {
            string4 = string4 + " -e \"theme_remove_flags\" \"0\"";
            string4 = string4 + " -e \"theme_apply_flags\" \"" + l + "\"";
        }
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand(string4);
        return CmdUtils.run(stringArray);
    }

    public static boolean adb_push(String string, String string2, String string3) {
        String[] stringArray = CmdUtils.initS();
        String string4 = string != null ? "-s " + string : "";
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand(string4 + " push \"" + string2 + "\" \"" + string3 + "\"");
        return CmdUtils.run(stringArray);
    }

    public static boolean adb_push(String string, String string2) {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand("push \"" + string + "\" \"" + string2 + "\"");
        return CmdUtils.run(stringArray);
    }

    public static boolean adb_pull(String string) {
        if (!CmdUtils.adb_root()) {
            logger.info("root fail");
            return false;
        }
        return CmdUtils.adb_pull(string, "");
    }

    public static boolean adb_pull(String string, String string2) {
        if (!CmdUtils.adb_root()) {
            logger.info("root fail");
            return false;
        }
        if (!string2.isEmpty()) {
            string2 = "\"" + string2 + "\"";
        }
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand("pull \"" + string + "\" " + string2);
        return CmdUtils.run(stringArray);
    }

    public static String adb_getApkPath(String string) {
        Object[] objectArray = CmdUtils.initS();
        objectArray[2] = objectArray[2] + CmdUtils.makeCommand("shell pm path \"" + string + "\"");
        String string2 = CmdUtils.runAndGet(StringUtils.join((Object[])objectArray, (String)" "));
        String[] stringArray = string2.split(":");
        if (stringArray.length == 2) {
            return StringUtils.trim((String)stringArray[1]);
        }
        return null;
    }

    public static boolean adb_shell_start(String string) {
        return CmdUtils.adb_shell_start(string, null);
    }

    public static boolean adb_shell_start(String string, HashMap<String, String> hashMap) {
        Object object;
        String string2 = "";
        if (hashMap != null) {
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                string2 = string2 + " -e \"" + string3 + "\" \"" + hashMap.get(string3) + "\"";
            }
        }
        Object object2 = object = CmdUtils.initS();
        object2[2] = (String)object2[2] + CmdUtils.makeCommand("shell am start -n " + string + string2);
        return CmdUtils.run((String[])object);
    }

    public static boolean aapt_dump_resources(String string, String string2) {
        String[] stringArray = CmdUtils.initS();
        if (string.contains(" ")) {
            string = "\"" + string + "\"";
        }
        stringArray[2] = OS.getOS() == 3 ? stringArray[2] + "tools" + File.separator + "aapt-mac dump --values resources " + string + " > " + string2 : stringArray[2] + "tools" + File.separator + "aapt dump --values resources " + string + " > " + string2;
        return CmdUtils.run(stringArray);
    }

    public static String aapt_get_package_name(File file) {
        String[] stringArray = CmdUtils.initS();
        String string = file.getAbsolutePath();
        if (string.contains(" ")) {
            string = "\"" + string + "\"";
        }
        String string2 = "badging.txt";
        stringArray[2] = OS.getOS() == 3 ? stringArray[2] + "tools" + File.separator + "aapt-mac dump badging " + string + " >" + string2 : stringArray[2] + "tools" + File.separator + "aapt dump badging " + string + " >" + string2;
        CmdUtils.run(stringArray);
        File file2 = new File(string2);
        if (!file2.exists()) {
            return null;
        }
        String string3 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
            String string4 = bufferedReader.readLine();
            if (!string4.contains("package: name=")) {
                return null;
            }
            int n = string4.indexOf("'");
            int n2 = string4.indexOf("'", n + 1);
            string3 = string4.substring(n + 1, n2);
            bufferedReader.close();
            OS.rmFile(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string3;
    }

    public static boolean apktool(String string, String string2) {
        String[] stringArray = CmdUtils.initS();
        if (string.contains(" ")) {
            string = "\"" + string + "\"";
        }
        String string3 = System.getProperty("user.dir").trim();
        for (int i = 0; i < string3.length(); ++i) {
            if (string3.charAt(i) != ' ') continue;
            string3 = string3.subSequence(0, i) + "\" \"" + string3.substring(i + 1, string3.length());
            i += 2;
        }
        stringArray[2] = OS.getOS() == 3 ? stringArray[2] + "tools" + File.separator + "apktool-mac d -f --keep-broken-res " + string + " " + string3 + File.separator + string2 + File.separator : stringArray[2] + "tools" + File.separator + "apktool d -f --keep-broken-res " + string + " " + string3 + File.separator + string2 + File.separator;
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(stringArray);
            InputStream inputStream = process.getErrorStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
            }
            process.waitFor();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean apktool_install(String string, String string2) {
        String[] stringArray = CmdUtils.initS();
        if (string.contains(" ")) {
            string = "\"" + string + "\"";
        }
        String string3 = System.getProperty("user.dir").trim();
        for (int i = 0; i < string3.length(); ++i) {
            if (string3.charAt(i) != ' ') continue;
            string3 = string3.subSequence(0, i) + "\" \"" + string3.substring(i + 1, string3.length());
            i += 2;
        }
        stringArray[2] = OS.getOS() == 3 ? stringArray[2] + "tools" + File.separator + "apktool-mac if " + string + " " + string2 : stringArray[2] + "tools" + File.separator + "apktool if " + string + " " + string2;
        return CmdUtils.run(stringArray);
    }

    public static boolean adb_install(String string) {
        GUIUtil.toast(ResourceFactory.getString("InstallApkAlert"));
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand("install -r \"" + string + "\"");
        return CmdUtils.run(stringArray);
    }

    public static boolean adb_uninstall(String string) {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand("uninstall \"" + string + "\"");
        return CmdUtils.run(stringArray);
    }

    public static boolean runShell(String string, String[] stringArray) {
        String[] stringArray2 = CmdUtils.initS();
        stringArray2[2] = string;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[2] = stringArray2[2] + " '" + stringArray[i] + "' ";
            }
        }
        return CmdUtils.run(stringArray2);
    }

    public static void hideFileInWin(String string) {
        try {
            Runtime.getRuntime().exec("attrib +H \"" + string + "\"");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean deleteDir(String string) {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = OS.getOS() == 1 ? "rd /s/q \"" + string + "\"" : "rm -rf \"" + string + "\"";
        return CmdUtils.run(stringArray);
    }

    public static boolean deleteFile(String string) {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = OS.getOS() == 1 ? "del /f/s/q \"" + string + "\"" : "rm -rf \"" + string + "\"";
        return CmdUtils.run(stringArray);
    }

    public static boolean moveFile(String string, String string2) {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = OS.getOS() == 1 ? "move /Y \"" + string + "\" \"" + string2 + "\"" : "mv -f \"" + string + "\" \"" + string2 + "\"";
        return CmdUtils.run(stringArray);
    }

    public static boolean renameFile(String string, String string2) {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = OS.getOS() == 1 ? "ren \"" + string + "\" \"" + string2 + "\"" : "mv -f \"" + string + "\" \"" + string2 + "\"";
        return CmdUtils.run(stringArray);
    }

    public static boolean copyFile(String string, String string2) {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = OS.getOS() == 1 ? "copy /Y \"" + string + "\" \"" + string2 + "\"" : "cp -f \"" + string + "\" \"" + string2 + "\"";
        return CmdUtils.run(stringArray);
    }

    public static boolean copyDir(String string, String string2) {
        String[] stringArray = CmdUtils.initS();
        if (OS.getOS() == 1) {
            stringArray[2] = "xcopy /E/Y \"" + string + "\" \"" + string2 + File.separator + "\"";
        } else {
            File file = new File(string2);
            if (file.exists()) {
                CmdUtils.deleteDir(file.getAbsolutePath());
            }
            stringArray[2] = "cp -rf \"" + string + "\"" + " \"" + string2 + "\"";
        }
        return CmdUtils.run(stringArray);
    }

    public static boolean openAndSelectFileInWindows(String string) {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = "explorer /select," + string;
        CmdUtils.runNoWait(stringArray);
        return true;
    }

    public static boolean optimizePng(String string) {
        return true;
    }

    public static boolean mspaint(String string) {
        String[] stringArray = CmdUtils.initS();
        stringArray = CmdUtils.initS();
        stringArray[2] = "mspaint \"" + string + "\"";
        return CmdUtils.run(stringArray);
    }

    private static boolean run(String[] stringArray) {
        if (ThemeHelper.isInnerUserMode()) {
            if (stringArray.length == 3) {
                logger.info(stringArray[2].toString());
            } else {
                logger.info(stringArray[0].toString());
            }
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            boolean bl;
            process = runtime.exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            new LogOutputThread("i", bufferedReader).start();
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            new LogOutputThread("e", bufferedReader2).start();
            if (process.waitFor() == 0) {
                bl = true;
            } else {
                bl = false;
                byte[] byArray = new byte[100];
                logger.debug(process.getErrorStream().read(byArray));
                logger.debug(new String(byArray));
            }
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static synchronized void runNoWait(String[] stringArray) {
        if (ThemeHelper.isInnerUserMode()) {
            logger.info(stringArray[2].toString());
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(stringArray, null, new File(ThemeHelper.getUserDir()).getParentFile());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            new LogOutputThread("i", bufferedReader).start();
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            new LogOutputThread("e", bufferedReader2).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean openNinePatchEditor(String string) {
        String[] stringArray = CmdUtils.initS();
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        string = file.getAbsolutePath();
        string = CmdUtils.convertPathSpace(string);
        stringArray[2] = OS.getOS() == 3 ? stringArray[2] + "tools" + File.separator + "draw9patch-mac " + string : stringArray[2] + "tools" + File.separator + "draw9patch " + string;
        CmdUtils.runNoWait(stringArray);
        return true;
    }

    public static boolean adb_shell_applyThemeSpecial(String string) {
        String string2;
        if (!CmdUtils.adb_root()) {
            logger.info("root fail");
            return false;
        }
        if (!CmdUtils.adb_rm(SYSTEM_THEME_PATH)) {
            logger.info("rm fail");
            return false;
        }
        if (!CmdUtils.adb_push(string, SYSTEM_THEME_PATH)) {
            logger.info("push fail");
            return false;
        }
        String string3 = string + File.separator + THEME_WALLPAPER_PATH;
        if (new File(string3).exists()) {
            if (!CmdUtils.adb_push(string3, SYSTEM_WALLPAPER_PATH)) {
                logger.info("push wallpaper fail");
                return false;
            }
            if (!CmdUtils.adb_push(string3, JLB_SYSTEM_WALLPAPER_PATH)) {
                logger.info("push wallpaper jlb fail");
                return false;
            }
        }
        if (new File(string2 = string + File.separator + THEME_LOCKSCREEN_WALLPAPER_PATH).exists() && !CmdUtils.adb_push(string2, SYSTEM_LOCKSCREEN_WALLPAPER_PATH)) {
            logger.info("push lockscreen wallpaper fail");
            return false;
        }
        CmdUtils.adb_rm(SYSTEM_THEME_CUSTOMIZED_ICONS_PATH);
        CmdUtils.adb_rm(SYSTEM_THEME_CLOCK_PATH);
        CmdUtils.adb_kill_system_server();
        return true;
    }

    public static boolean adb_kill_system_server() {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand("shell busybox pkill system_server");
        return CmdUtils.run(stringArray);
    }

    public static boolean adb_reboot() {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand("reboot");
        return CmdUtils.run(stringArray);
    }

    private static String makeCommand(String string) {
        if (OS.getOS() == 3) {
            return "tools" + File.separator + "adb-mac " + string;
        }
        return "tools" + File.separator + "adb " + string;
    }

    public static boolean adb_root() {
        boolean bl = ConfigUtil.get("device", "hasRooted").equals(Boolean.TRUE.toString());
        if (bl) {
            logger.debug("has been rooted");
            return true;
        }
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand("root");
        boolean bl2 = CmdUtils.run(stringArray);
        ConfigUtil.put("device", "hasRooted", Boolean.TRUE.toString());
        ConfigUtil.save();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return bl2;
    }

    public static boolean adb_rm(String string) {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand("shell rm -r " + string);
        return CmdUtils.run(stringArray);
    }

    public static synchronized boolean adb_killServer() {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand("kill-server");
        return CmdUtils.run(stringArray);
    }

    public static boolean adb_devices() {
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = stringArray[2] + CmdUtils.makeCommand("devices");
        return CmdUtils.run(stringArray);
    }

    public static void startEditor() {
        String string = new File(ThemeHelper.getUserDir()).getParent() + File.separator;
        String[] stringArray = CmdUtils.initS();
        if (OS.getOS() == 1) {
            stringArray[2] = string + "MIUINewThemeEditor.exe";
        } else if (OS.getOS() == 2) {
            stringArray[2] = "chmod 777 " + string + "start-linux.sh";
            CmdUtils.run(stringArray);
            stringArray[2] = string + "start-linux.sh";
        } else {
            return;
        }
        CmdUtils.runNoWait(stringArray);
    }

    public static void killAdb() {
        String string3;
        if (OS.getOS() != 1) {
            GUIUtil.toast("WINDOWS only!");
            return;
        }
        String string2 = CmdUtils.runAndGet("netstat -nao | findstr 5037");
        String[] stringArray = string2.split("\r\n");
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (String string3 : stringArray) {
            int n = Integer.parseInt(string3.substring(string3.lastIndexOf(" ") + 1));
            if (n == 0 || hashMap.containsKey(n) || (string2 = CmdUtils.runAndGet("tasklist | findstr " + n)).isEmpty()) continue;
            String string4 = string2.substring(0, string2.indexOf(" "));
            hashMap.put(n, string4);
        }
        Vector vector = new Vector();
        for (Integer n : hashMap.keySet()) {
            string3 = (String)hashMap.get(n);
            if (string3.equals("javaw.exe")) continue;
            String[] stringArray2 = CmdUtils.initS();
            stringArray2[2] = "taskkill /F /PID " + n;
            if (CmdUtils.run(stringArray2)) {
                System.out.println(string3 + " killed");
                vector.add(string3);
                continue;
            }
            System.out.println(string3 + " kill fail");
        }
        if (vector.size() <= 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            stringBuilder.append(string3);
            stringBuilder.append(" ");
        }
        stringBuilder.append("killed!");
        GUIUtil.toastLong(stringBuilder.toString());
        CmdUtils.adb_devices();
    }

    private static String runAndGet(String string) {
        String string2 = ThemeHelper.getTmpFolder() + File.separator + "poutput.txt";
        File file = new File(string2);
        String[] stringArray = CmdUtils.initS();
        stringArray[2] = string + " > \"" + string2 + "\"";
        CmdUtils.run(stringArray);
        if (!file.exists()) {
            return "";
        }
        String string3 = ThemeHelper.readFromFile(file);
        file.delete();
        return string3;
    }
}

