/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.ninepatch;

import com.miui.theme.tool.ninepatch.NinePatchChunk;
import com.miui.theme.tool.ninepatch.NinePatchPngFormatException;
import com.miui.theme.tool.ninepatch.NinePatchUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class NinePatchEncoder {
    public ByteArrayInputStream encode(InputStream inputStream) throws IOException, NinePatchPngFormatException {
        byte[] byArray = this.getEncodedByteData(inputStream);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public boolean encode(InputStream inputStream, OutputStream outputStream) throws IOException, NinePatchPngFormatException {
        byte[] byArray = this.getEncodedByteData(inputStream);
        if (byArray == null) {
            return false;
        }
        IOUtils.write((byte[])byArray, (OutputStream)outputStream);
        return true;
    }

    public void encode(String string, String string2) throws IOException, NinePatchPngFormatException {
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        this.encode(fileInputStream, fileOutputStream);
        fileInputStream.close();
        fileOutputStream.close();
    }

    private byte[] getEncodedByteData(InputStream inputStream) throws IOException, NinePatchPngFormatException {
        byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
        inputStream.close();
        NinePatchChunk ninePatchChunk = new NinePatchChunk();
        boolean bl = ninePatchChunk.set9PatchChunkFromImageData(byArray);
        if (!bl) {
            return null;
        }
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n <= 2 || n2 <= 2) {
            return null;
        }
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(1, 1, n -= 2, n2 -= 2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage2, "png", (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        byte[] byArray3 = new byte[byArray2.length + 12 + ninePatchChunk.da.length];
        this.addNinePatchChunk(byArray2, byArray3, ninePatchChunk);
        return byArray3;
    }

    private void addNinePatchChunk(byte[] byArray, byte[] byArray2, NinePatchChunk ninePatchChunk) throws IOException {
        int n;
        for (n = 0; n < 33; ++n) {
            byArray2[n] = byArray[n];
        }
        int n2 = 33;
        NinePatchUtils.getBytesFromInt(byArray2, n, ninePatchChunk.size);
        NinePatchUtils.getBytesFromInt(byArray2, n += 4, ninePatchChunk.TYPE);
        n += 4;
        int n3 = 0;
        while (n3 < ninePatchChunk.da.length) {
            byArray2[n] = ninePatchChunk.da[n3];
            ++n3;
            ++n;
        }
        NinePatchUtils.getBytesFromInt(byArray2, n, ninePatchChunk.crcValue);
        n += 4;
        while (n2 < byArray.length && n < byArray2.length) {
            byArray2[n] = byArray[n2];
            ++n;
            ++n2;
        }
    }
}

