/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.ninepatch;

import com.miui.theme.tool.ninepatch.NinePatchPngFormatException;
import com.miui.theme.tool.ninepatch.NinePatchUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;

public class NinePatchChunk {
    public int size;
    public final int TYPE = 1852855395;
    public byte[] da;
    public int crcValue;
    private static final int NO_COLOR = 1;
    private static final int TRANSPARENT = 0;
    private static final int TRANSPARENT_COLOR = 0xFFFFFF;
    private boolean ignoreNinePatchFormatException = false;
    private byte wasDeSerialized = 0;
    private byte numXDivs;
    private byte numYDivs;
    private byte numColors;
    private int paddingLeft;
    private int paddingRight;
    private int paddingTop;
    private int paddingBottom;
    private int[] xDivs_arr;
    private int[] yDivs_arr;
    private int[] colors_arr;

    public boolean set9PatchChunkFromImageData(byte[] byArray) throws IOException, NinePatchPngFormatException {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
        int n2 = -16777216;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (n3 < 3 || n4 < 3) {
            return false;
        }
        if (byArray[37] == 110 && byArray[38] == 112 && byArray[39] == 84 && byArray[40] == 99) {
            return false;
        }
        this.numXDivs = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n5 = 1;
        while (n5 < n3) {
            if (bufferedImage.getRGB(n5, 0) == n2) {
                arrayList.add(n5 - 1);
                ++n5;
                while (n5 < n3 && bufferedImage.getRGB(n5, 0) == n2) {
                    ++n5;
                }
                arrayList.add(n5 - 1);
                continue;
            }
            if (NinePatchChunk.isTransparent(bufferedImage.getRGB(n5, 0))) {
                ++n5;
                continue;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_wrong_color"));
        }
        if (arrayList.size() > 127) {
            return false;
        }
        this.numXDivs = (byte)arrayList.size();
        if (this.numXDivs == 0) {
            if (this.ignoreNinePatchFormatException) {
                return false;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_left_top"));
        }
        this.xDivs_arr = new int[arrayList.size()];
        for (n5 = 0; n5 < this.xDivs_arr.length; ++n5) {
            this.xDivs_arr[n5] = (Integer)arrayList.get(n5);
        }
        arrayList.clear();
        this.numYDivs = 0;
        n5 = 1;
        while (n5 < n4) {
            if (bufferedImage.getRGB(0, n5) == n2) {
                arrayList.add(n5 - 1);
                ++n5;
                while (n5 < n4 && bufferedImage.getRGB(0, n5) == n2) {
                    ++n5;
                }
                arrayList.add(n5 - 1);
                continue;
            }
            if (NinePatchChunk.isTransparent(bufferedImage.getRGB(0, n5))) {
                ++n5;
                continue;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_wrong_color"));
        }
        if (arrayList.size() > 127) {
            return false;
        }
        this.numYDivs = (byte)arrayList.size();
        if (this.numYDivs == 0) {
            if (this.ignoreNinePatchFormatException) {
                return false;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_left_top"));
        }
        this.yDivs_arr = new int[arrayList.size()];
        for (n5 = 0; n5 < this.yDivs_arr.length; ++n5) {
            this.yDivs_arr[n5] = (Integer)arrayList.get(n5);
        }
        arrayList.clear();
        this.paddingLeft = 0;
        for (n5 = 1; n5 < n3 && bufferedImage.getRGB(n5, n4 - 1) != n2; ++n5) {
            if (NinePatchChunk.isTransparent(bufferedImage.getRGB(n5, n4 - 1))) {
                continue;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_wrong_color"));
        }
        this.paddingLeft = n5 - 1;
        while (n5 < n3 && bufferedImage.getRGB(n5, n4 - 1) == n2) {
            ++n5;
        }
        this.paddingRight = n3 - 1 - n5;
        if (this.paddingLeft == n3 - 1) {
            this.paddingLeft = this.xDivs_arr[0];
            this.paddingRight = n3 - 2 - this.xDivs_arr[1];
        }
        for (n5 = 1; n5 < n4 && bufferedImage.getRGB(n3 - 1, n5) != n2; ++n5) {
            if (NinePatchChunk.isTransparent(bufferedImage.getRGB(n3 - 1, n5))) {
                continue;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_wrong_color"));
        }
        this.paddingTop = n5 - 1;
        while (n5 < n4 && bufferedImage.getRGB(n3 - 1, n5) == n2) {
            ++n5;
        }
        this.paddingBottom = n4 - 1 - n5;
        if (this.paddingTop == n4 - 1) {
            this.paddingTop = this.yDivs_arr[0];
            this.paddingBottom = n4 - 2 - this.yDivs_arr[1];
        }
        int n6 = this.xDivs_arr[0] == 0 && this.xDivs_arr[this.xDivs_arr.length - 1] == n3 - 2 ? this.numXDivs - 1 : (this.xDivs_arr[0] == 0 && this.xDivs_arr[this.xDivs_arr.length - 1] < n3 - 2 || this.xDivs_arr[0] > 0 && this.xDivs_arr[this.xDivs_arr.length - 1] == n3 - 2 ? (int)this.numXDivs : this.numXDivs + 1);
        int n7 = this.yDivs_arr[0] == 0 && this.yDivs_arr[this.yDivs_arr.length - 1] == n4 - 2 ? this.numYDivs - 1 : (this.yDivs_arr[0] == 0 && this.yDivs_arr[this.yDivs_arr.length - 1] < n4 - 2 || this.yDivs_arr[0] > 0 && this.yDivs_arr[this.yDivs_arr.length - 1] == n4 - 2 ? (int)this.numYDivs : this.numYDivs + 1);
        this.numColors = (byte)(n6 * n7);
        this.colors_arr = new int[this.numColors];
        this.size = 32 + (this.xDivs_arr.length + this.yDivs_arr.length + this.colors_arr.length) * 4;
        int n8 = 0;
        int n9 = 0;
        int n10 = this.xDivs_arr.length;
        int n11 = this.yDivs_arr.length;
        int n12 = 1;
        int n13 = this.yDivs_arr[n];
        for (n = 0; n12 <= n4 - 2 && n13 <= n4 - 2 && n <= n11; ++n) {
            if (n12 <= n13) {
                int n14 = 1;
                int n15 = this.xDivs_arr[n8];
                for (n8 = 0; n14 <= n3 - 2 && n15 <= n3 - 2 && n8 <= n10; ++n8) {
                    if (n14 <= n15) {
                        this.colors_arr[n9] = this.getColor(bufferedImage, n12, n13, n14, n15);
                        ++n9;
                    }
                    n14 = n15 + 1;
                    n15 = this.getNext(this.xDivs_arr, n8, n3 - 2);
                }
            }
            n12 = n13 + 1;
            n13 = this.getNext(this.yDivs_arr, n, n4 - 2);
        }
        this.crcValue = this.getCrc();
        return true;
    }

    private int getCrc() {
        int n;
        byte[] byArray = new byte[4];
        NinePatchUtils.getBytesFromInt(byArray, 0, 1852855395);
        this.da = new byte[this.size];
        this.da[0] = this.wasDeSerialized;
        this.da[1] = this.numXDivs;
        this.da[2] = this.numYDivs;
        this.da[3] = this.numColors;
        for (n = 4; n <= 11; ++n) {
            this.da[n] = 0;
        }
        NinePatchUtils.getBytesFromInt(this.da, 12, this.paddingLeft);
        NinePatchUtils.getBytesFromInt(this.da, 16, this.paddingRight);
        NinePatchUtils.getBytesFromInt(this.da, 20, this.paddingTop);
        NinePatchUtils.getBytesFromInt(this.da, 24, this.paddingBottom);
        for (n = 28; n <= 31; ++n) {
            this.da[n] = 0;
        }
        n = 32;
        int n2 = 0;
        while (n2 < this.xDivs_arr.length) {
            NinePatchUtils.getBytesFromInt(this.da, n, this.xDivs_arr[n2]);
            ++n2;
            n += 4;
        }
        n2 = 0;
        while (n2 < this.yDivs_arr.length) {
            NinePatchUtils.getBytesFromInt(this.da, n, this.yDivs_arr[n2]);
            ++n2;
            n += 4;
        }
        n2 = 0;
        while (n2 < this.colors_arr.length) {
            NinePatchUtils.getBytesFromInt(this.da, n, this.colors_arr[n2]);
            ++n2;
            n += 4;
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        cRC32.update(this.da);
        return (int)cRC32.getValue();
    }

    private int getNext(int[] nArray, int n, int n2) {
        if (n >= nArray.length - 1) {
            return n2;
        }
        return nArray[n + 1];
    }

    private int getColor(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        if (n3 == n4 && n == n2) {
            return bufferedImage.getRGB(n3, n);
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n5 = bufferedImage.getRGB(n3, n);
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                int n6 = bufferedImage.getRGB(i, j);
                if (bl2 && n6 != 0xFFFFFF) {
                    bl2 = false;
                }
                if (bl3 && n6 != n5) {
                    bl3 = false;
                }
                n5 = n6;
                if (bl2 || bl3) continue;
                bl = false;
                break;
            }
            if (!bl) break;
        }
        if (!bl2 || bl3) {
            // empty if block
        }
        if (bl2) {
            return 0;
        }
        if (bl3) {
            return n5;
        }
        return 1;
    }

    public static boolean isTransparent(int n) {
        return (n >> 24 & 0xFF) == 0;
    }
}

