/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.more;

import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.catalog.CatalogManager;
import com.miui.theme.tool.catalog.Member;
import com.miui.theme.tool.more.FilterListPanel;
import com.miui.theme.tool.more.ListPanel;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPanel;

public class MoreModuleListPanel
extends JPanel {
    public static Color sBackground = GUIUtil.hex2color("#efeff1");
    private Vector<Member> mThemeApps;
    private Vector<Member> mUnthemeApps;
    private Vector<String> mTemplatedApps;
    private ListPanel mThemedPanel;
    private ListPanel mUnthemedpanel;
    private static NinePatch mBorderPatch = GUIUtil.getNinePatch("more/list_frame.9.png");

    public MoreModuleListPanel() {
        this.setBackground(sBackground);
        double[][] dArrayArray = new double[][]{{-1.0}, {-2.0, -2.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.init();
    }

    public void init() {
        this.initLists();
        this.mThemedPanel = ListPanel.createInstance(ResourceFactory.getString("ThemedApps"), this.mThemeApps, true);
        this.mUnthemedpanel = FilterListPanel.createInstance(ResourceFactory.getString("UnthemedApps"), this.mUnthemeApps, this.mTemplatedApps, false);
        this.add((Component)this.mThemedPanel, "0, 0");
        this.add((Component)this.mUnthemedpanel, "0, 1");
    }

    public void initLists() {
        this.mThemeApps = new Vector();
        this.mUnthemeApps = new Vector();
        File file = new File(ConfigUtil.getThemePath());
        String[] stringArray = file.list();
        HashMap<String, Member> hashMap = null;
        try {
            hashMap = CatalogManager.getHashMapApps();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        for (String string : stringArray) {
            if (!hashMap.containsKey(string)) continue;
            this.mThemeApps.add(hashMap.get(string));
        }
        for (String string : hashMap.keySet()) {
            if (this.mThemeApps.contains(hashMap.get(string))) continue;
            this.mUnthemeApps.add(hashMap.get(string));
        }
        this.mTemplatedApps = new Vector();
        file = new File(ThemeHelper.getTemplatePath());
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (Object object : fileArray) {
                if (!((File)object).isDirectory()) continue;
                this.mTemplatedApps.add(((File)object).getName());
            }
        }
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        mBorderPatch.draw((Graphics2D)graphics, 0, 0, this.getWidth(), this.getHeight());
    }
}

