/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.more;

import com.miui.theme.tool.catalog.Member;
import com.miui.theme.tool.gui.ConfirmDialog;
import com.miui.theme.tool.gui.NinePBackgroundPanel;
import com.miui.theme.tool.gui.WrapLayout;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.icon.IconManager;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.GUIUtil;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ListPanel
extends JPanel {
    public static Color sBackground = GUIUtil.hex2color("#efeff1");
    public static Color sTitleColor = GUIUtil.hex2color("#878788");
    public static Color sIconNameColor = GUIUtil.hex2color("#4a4a4a");
    private String mTitle;
    public Vector<Member> mAppList;
    protected NinePBackgroundPanel mTitlePanel;
    private JLabel mTitleLabel;
    private boolean mIsThemed;
    private JPanel mListPanel;
    private MouseMotionListener mMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            if (mouseEvent.getSource() != ListPanel.this.mListPanel) {
                mouseEvent = SwingUtilities.convertMouseEvent((AppPanel)mouseEvent.getSource(), mouseEvent, ListPanel.this.mListPanel);
            }
            for (int i = 0; i < ListPanel.this.mListPanel.getComponentCount(); ++i) {
                AppPanel appPanel = (AppPanel)ListPanel.this.mListPanel.getComponent(i);
                Point point = new Point(appPanel.getX(), appPanel.getY());
                Rectangle rectangle = new Rectangle(point.x, point.y, appPanel.getWidth(), appPanel.getHeight());
                if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    appPanel.mActionButton.setVisible(true);
                    continue;
                }
                appPanel.mActionButton.setVisible(false);
            }
        }
    };
    public static int ICON_SIZE = 50;

    public ListPanel(String string, Vector<Member> vector, boolean bl) {
        this.mTitle = string;
        this.mAppList = vector;
        this.mIsThemed = bl;
    }

    public static ListPanel createInstance(String string, Vector<Member> vector, boolean bl) {
        ListPanel listPanel = new ListPanel(string, vector, bl);
        listPanel.initTitlePanel();
        listPanel.initLayout();
        return listPanel;
    }

    protected void initTitlePanel() {
        double[][] dArrayArray = new double[][]{{15.0, 100.0, 30.0, 80.0, -1.0}, {-1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mTitlePanel = new NinePBackgroundPanel();
        this.mTitlePanel.setLayout(tableLayout);
        this.mTitlePanel.setNinePBackground("more/category_title_bg.9.png");
        this.mTitleLabel = new JLabel(this.mTitle);
        this.mTitleLabel.setForeground(sTitleColor);
        this.mTitleLabel.setHorizontalTextPosition(2);
        this.mTitleLabel.setVerticalTextPosition(0);
        this.mTitlePanel.add((Component)this.mTitleLabel, "1, 0");
    }

    public void initLayout() {
        double[][] dArrayArray = new double[][]{{-1.0}, {37.0, -2.0, 30.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.add((Component)this.mTitlePanel, "0, 0");
        this.mListPanel = new JPanel();
        this.mListPanel.setBackground(sBackground);
        this.mListPanel.setLayout(new WrapLayout(0, 5, 12));
        if (this.mIsThemed) {
            this.mListPanel.addMouseMotionListener(this.mMouseAdapter);
        }
        this.mListPanel.removeAll();
        for (Member member : this.getAppList()) {
            this.mListPanel.add(new AppPanel(member));
        }
        this.add((Component)this.mListPanel, "0, 1");
        this.revalidate();
        this.repaint();
    }

    protected Vector<Member> getAppList() {
        return this.mAppList;
    }

    class AppPanel
    extends JPanel {
        private Member mMember;
        int WIDTH = 70;
        int HEIGHT = 90;
        private JLabel mIconLabel;
        private JLabel mIconTextLabel;
        private MouseAdapter mMouseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
                NewMainFrame.getInstance().getMainPanel().switchTab(((AppPanel)AppPanel.this).mMember.mPackageName);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                super.mouseMoved(mouseEvent);
                AppPanel.this.getParent().dispatchEvent(mouseEvent);
            }
        };
        ImageIcon mNormal = ResourceFactory.getInstance().getImageIcon("more/delete_n.png");
        ImageIcon mPressed = ResourceFactory.getInstance().getImageIcon("more/delete_p.png");
        JButton mActionButton = GUIUtil.createTransparentButton(this.mNormal, this.mPressed, this.mPressed, null);
        private ActionListener mDeleteIconActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfirmDialog confirmDialog = new ConfirmDialog(ResourceFactory.getString("DeleteModule"), ResourceFactory.getString("ConfirmDeleteModule") + ((AppPanel)AppPanel.this).mMember.mAppName + "?");
                confirmDialog.setVisible(true);
                if (confirmDialog.mResult == "cancle") {
                    return;
                }
                String string = ConfigUtil.getThemePath() + File.separator + ((AppPanel)AppPanel.this).mMember.mPackageName;
                CmdUtils.deleteDir(string);
                NewMainFrame.getInstance().getMainPanel().switchTab("more");
            }
        };

        public AppPanel(Member member) {
            this.mMember = member;
            this.setBackground(sBackground);
            GUIUtil.hand(this);
            this.mIconLabel = new JLabel(IconManager.getScaledAndRoundedIcon(IconManager.getIcon(this.mMember.mPackageName), ICON_SIZE, null));
            this.mIconTextLabel = new JLabel();
            this.mIconTextLabel.setText(GUIUtil.cutWord(this.mIconTextLabel, this.mMember.mAppName, 100));
            this.mIconTextLabel.setHorizontalAlignment(0);
            this.setToolTipText(this.mMember.mAppName + "(" + this.mMember.mPackageName + ")");
            this.mIconTextLabel.setForeground(sIconNameColor);
            double[][] dArrayArray = new double[][]{{10.0, 40.0, 10.0, 10.0}, {10.0, 10.0, 40.0, 14.0, 15.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            if (ListPanel.this.mIsThemed) {
                this.initDeleteButton();
            }
            this.add((Component)this.mIconLabel, "1, 1, 2, 2");
            this.add((Component)this.mIconTextLabel, "1, 4, 2, 4");
            this.addMouseListener(this.mMouseListener);
            this.addMouseMotionListener(this.mMouseListener);
        }

        public void initDeleteButton() {
            this.mActionButton.setVisible(false);
            this.mActionButton.addActionListener(this.mDeleteIconActionListener);
            this.add((Component)this.mActionButton, "2, 0, 3, 1");
        }
    }
}

