/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.more;

import com.miui.theme.tool.catalog.Member;
import com.miui.theme.tool.more.ListPanel;
import com.miui.theme.tool.resource.ResourceFactory;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class FilterListPanel
extends ListPanel {
    private final Vector<String> mTemplate;
    private JLabel mFilterLabel;
    private static JCheckBox sFilterCheckBox = new JCheckBox();
    private final ItemListener mItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            FilterListPanel.this.initLayout();
        }
    };

    public FilterListPanel(String string, Vector<Member> vector, Vector<String> vector2, boolean bl) {
        super(string, vector, bl);
        this.mTemplate = vector2;
    }

    public static FilterListPanel createInstance(String string, Vector<Member> vector, Vector<String> vector2, boolean bl) {
        FilterListPanel filterListPanel = new FilterListPanel(string, vector, vector2, bl);
        filterListPanel.initTitlePanel();
        filterListPanel.initLayout();
        filterListPanel.initFilter();
        return filterListPanel;
    }

    private void initFilter() {
        this.mFilterLabel = new JLabel(ResourceFactory.getString("ShowAll"));
        this.mFilterLabel.setForeground(sTitleColor);
        this.mFilterLabel.setHorizontalTextPosition(2);
        this.mFilterLabel.setVerticalTextPosition(0);
        this.mTitlePanel.add((Component)this.mFilterLabel, "3, 0");
        for (ItemListener itemListener : sFilterCheckBox.getItemListeners()) {
            sFilterCheckBox.removeItemListener(itemListener);
        }
        sFilterCheckBox.addItemListener(this.mItemListener);
        this.mTitlePanel.add((Component)sFilterCheckBox, "2, 0");
    }

    @Override
    protected Vector<Member> getAppList() {
        if (sFilterCheckBox.isSelected()) {
            return super.getAppList();
        }
        Vector<Member> vector = super.getAppList();
        Vector<Member> vector2 = new Vector<Member>();
        for (Member member : vector) {
            if (!this.mTemplate.contains(member.mPackageName)) continue;
            vector2.add(member);
        }
        return vector2;
    }
}

