/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icon;

import android.graphics.Bitmap;
import com.miui.theme.tool.catalog.CatalogManager;
import com.miui.theme.tool.catalog.Member;
import com.miui.theme.tool.gui.skin.ThemeLookAndFeel;
import com.miui.theme.tool.icon.IconManager;
import com.miui.theme.tool.icon.IconSelectListener;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.CSVFile;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPanel;
import miui.content.res.IconConfig;
import miui.content.res.IconCustomizer;
import miui.imagefilters.ImageData;
import org.jdom2.Document;
import org.jdom2.Element;
import org.json.JSONArray;
import org.json.JSONObject;
import sun.swing.SwingUtilities2;

public class MockLauncher
extends JPanel {
    public static final int WIDTH = 280;
    public static final int HEIGHT = 500;
    public static final int ICON_SIZE = 50;
    public static final int LEFT_START = 16;
    public static final int LEFT_WIDTH = 66;
    public static final int TOP_START = 30;
    public static final int TOP_HEIGHT = 85;
    public static final Color DEAFULT_BACKGROUND = GUIUtil.hex2color("#353535");
    private final Vector<String> mIcons;
    private BufferedImage mBackground;
    public static BufferedImage sLoadingImage = MockLauncher.getLoadingImage(280, 500);
    public BufferedImage mLauncher = sLoadingImage;
    HashMap<String, Member> mAppMap;
    public static HashMap<String, String> sOnlineMap = new HashMap();
    private static String sOnlineMapPath = ThemeHelper.getDataFolder() + File.separator + "online_app_map.csv";
    public int mCurrentIconIndex = -1;
    public IconSelectListener mIconSelectListener;
    private final MouseAdapter mLister = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (MockLauncher.this.mIconSelectListener == null) {
                return;
            }
            for (int i = 0; i < 20 && i < MockLauncher.this.mIcons.size(); ++i) {
                if (!MockLauncher.this.getRectangle(i).contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                MockLauncher.this.mCurrentIconIndex = i;
                MockLauncher.this.repaint();
                MockLauncher.this.mIconSelectListener.onIconSelected(MockLauncher.this, IconManager.getIconByPackageName((String)MockLauncher.this.mIcons.get(MockLauncher.this.mCurrentIconIndex)));
                return;
            }
        }
    };
    private IconConfig mIconConfig;
    public static HashMap<String, Image> sIconMap;

    public MockLauncher(Vector<String> vector) {
        try {
            this.mAppMap = CatalogManager.getHashMapApps();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mIcons = vector;
        this.addMouseListener(this.mLister);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private static void loadOnlineMap() {
        if (!new File(sOnlineMapPath).exists()) {
            return;
        }
        Vector<String[]> vector = new CSVFile(sOnlineMapPath).getData();
        for (String[] stringArray : vector) {
            if (stringArray.length < 2) continue;
            sOnlineMap.put(stringArray[0], stringArray[1]);
        }
    }

    private static void saveOnlineMap() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : sOnlineMap.keySet()) {
            stringBuilder.append(string + "," + sOnlineMap.get(string) + "\n");
        }
        ThemeHelper.writeToFile(new File(sOnlineMapPath), stringBuilder.toString());
    }

    public void setIconConfig(IconConfig iconConfig) {
        this.mIconConfig = iconConfig;
    }

    public void setBackground(BufferedImage bufferedImage) {
        this.mBackground = bufferedImage;
    }

    public void setIconSelectListener(IconSelectListener iconSelectListener) {
        this.mIconSelectListener = iconSelectListener;
    }

    public void refresh() {
        Graphics2D graphics2D;
        if (this.mBackground != null) {
            this.mLauncher = this.mBackground.getSubimage(0, 0, this.mBackground.getWidth(), this.mBackground.getHeight());
            graphics2D = (Graphics2D)this.mLauncher.getGraphics();
        } else {
            this.mLauncher = new BufferedImage(280, 500, 6);
            graphics2D = (Graphics2D)this.mLauncher.getGraphics();
            graphics2D.setColor(DEAFULT_BACKGROUND);
            graphics2D.fillRect(0, 0, 280, 500);
        }
        graphics2D.setColor(Color.WHITE);
        graphics2D.setFont(ThemeLookAndFeel.getFont(12.0f));
        for (int i = 0; i < 20 && i < this.mIcons.size(); ++i) {
            String string;
            int n;
            int n2;
            Rectangle rectangle = this.getRectangle(i);
            Image image = this.getImage(this.mIcons.get(i));
            graphics2D.drawImage(image, rectangle.x, rectangle.y, null);
            if (this.mIconConfig != null) {
                graphics2D.setColor(Color.RED);
                for (int j = 0; j < this.mIconConfig.mPointsMappingTo.size() / 2; ++j) {
                    n2 = rectangle.x + this.f2i(Float.valueOf(this.mIconConfig.mPointsMappingTo.get(j * 2).floatValue() / (float)IconCustomizer.sCustomizedIconWidth * 50.0f));
                    n = rectangle.y + this.f2i(Float.valueOf(this.mIconConfig.mPointsMappingTo.get(j * 2 + 1).floatValue() / (float)IconCustomizer.sCustomizedIconWidth * 50.0f));
                    int n3 = rectangle.x + this.f2i(Float.valueOf(this.mIconConfig.mPointsMappingTo.get((j + 1) % 4 * 2).floatValue() / (float)IconCustomizer.sCustomizedIconWidth * 50.0f));
                    int n4 = rectangle.y + this.f2i(Float.valueOf(this.mIconConfig.mPointsMappingTo.get((j + 1) % 4 * 2 + 1).floatValue() / (float)IconCustomizer.sCustomizedIconWidth * 50.0f));
                    graphics2D.drawLine(n2, n, n3, n4);
                }
                graphics2D.setColor(Color.WHITE);
            }
            if ((string = this.getText(this.mIcons.get(i))).isEmpty()) continue;
            if (string.length() >= 4) {
                string = string.substring(0, 4);
            }
            rectangle.y += rectangle.height + 16;
            n2 = this.getFontMetrics(this.getFont()).stringWidth(string);
            n = (image.getWidth(null) - n2) / 2;
            SwingUtilities2.drawStringUnderlineCharAt(this, graphics2D, string, n2, rectangle.x + n, rectangle.y);
        }
    }

    int f2i(Float f) {
        int n = (int)f.floatValue();
        if (n == GUIUtil.HDPI_SIZE) {
            n = GUIUtil.HDPI_SIZE - 1;
        }
        return n;
    }

    private String getText(String string) {
        if (this.mAppMap.containsKey(string)) {
            return this.mAppMap.get((Object)string).mAppName;
        }
        if (sOnlineMap.containsKey(string)) {
            return sOnlineMap.get(string);
        }
        String string2 = "";
        try {
            string2 = MockLauncher.getAppName(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string2.isEmpty()) {
            return ResourceFactory.getString("Unknown");
        }
        sOnlineMap.put(string, string2);
        MockLauncher.saveOnlineMap();
        return string2;
    }

    private static String getAppName(String string) {
        HashMap<String, String[]> hashMap = IconManager.mSystemApps;
        if (hashMap.containsKey(string)) {
            if (ResourceFactory.isLangZhCn() || hashMap.get(string).length == 2) {
                return hashMap.get(string)[0];
            }
            return hashMap.get(string)[1];
        }
        String string2 = MockLauncher.getAppFromBaidu(string = MockLauncher.fixPackageName(string));
        if (!string2.isEmpty()) {
            return string2;
        }
        string2 = MockLauncher.getAppFomXiaomi(string);
        return string2;
    }

    private static String fixPackageName(String string) {
        if (string.endsWith("Activity")) {
            return string.substring(0, string.lastIndexOf("."));
        }
        return string;
    }

    private static String getAppFomXiaomi(String string) {
        JSONArray jSONArray;
        String string2 = ResourceFactory.sLocale.toString();
        String string3 = "http://a0.app.xiaomi.com/tapp/applist?keyword=" + string;
        JSONObject jSONObject = ThemeHelper.getJSON(string3);
        if (jSONObject == null) {
            return "";
        }
        try {
            jSONArray = jSONObject.getJSONArray("listApp");
        }
        catch (Exception exception) {
            return "";
        }
        if (jSONArray.length() <= 0) {
            return "";
        }
        JSONObject jSONObject2 = jSONArray.getJSONObject(0);
        JSONObject jSONObject3 = jSONObject2.getJSONObject("displayName");
        if (!jSONObject3.has(string2)) {
            return "";
        }
        return jSONObject3.getString(string2);
    }

    private static String getAppFromBaidu(String string) {
        String string2 = "http://m.baidu.com/api?action=search&from=1269h&token=xiaomi&type=app&package=" + string;
        Document document = ThemeHelper.getXml(string2);
        if (document == null) {
            return "";
        }
        Element element = document.getRootElement();
        Element element2 = element.getChild("result");
        Element element3 = element2.getChild("app");
        if (element3 == null) {
            return "";
        }
        String string3 = element3.getChildText("sname");
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    Rectangle getRectangle(int n) {
        int n2 = n % 4;
        int n3 = n / 4;
        n2 = 16 + 66 * n2;
        n3 = 30 + 85 * n3;
        return new Rectangle(n2, n3, 50, 50);
    }

    public static synchronized void clearIconMapCache() {
        sIconMap.clear();
    }

    private synchronized Image getImage(String string) {
        if (sIconMap.containsKey(string) && this.mIconConfig == null) {
            return sIconMap.get(string);
        }
        Image image = GUIUtil.getImage(IconManager.getIconByPackageName(string));
        image = ImageData.imageDataToBitmap(ImageData.bitmapToImageData(image));
        if (this.mIconConfig != null) {
            ImageData imageData = this.mIconConfig.mIconFilters.processAll((Bitmap)image);
            image = ImageData.imageDataToBitmap(imageData);
        }
        image = image.getScaledInstance(50, 50, 4);
        if (this.mIconConfig == null) {
            sIconMap.put(string, image);
        }
        return image;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.mLauncher != null) {
            graphics2D.drawImage((Image)this.mLauncher, 0, 0, null);
        }
        if (this.mCurrentIconIndex != -1) {
            Rectangle rectangle = this.getRectangle(this.mCurrentIconIndex);
            int n = 2;
            rectangle = new Rectangle(rectangle.x - n, rectangle.y - n, rectangle.width + 2 * n, rectangle.height + 2 * n);
            this.drawOneSelected(rectangle, graphics2D);
        }
    }

    protected void drawOneSelected(Rectangle rectangle, Graphics2D graphics2D) {
        graphics2D.setPaint(Color.WHITE);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{5.0f}, 0.0f));
        graphics2D.draw(rectangle);
    }

    public static BufferedImage getLoadingImage(int n, int n2) {
        BufferedImage bufferedImage = ResourceFactory.getInstance().getImage("review/loading.png");
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.fillRect(0, 0, 280, 500);
        graphics2D.drawImage((Image)bufferedImage, (bufferedImage2.getWidth() - bufferedImage.getWidth()) / 2, (bufferedImage2.getHeight() - bufferedImage.getHeight()) / 2, null);
        return bufferedImage2;
    }

    static {
        MockLauncher.loadOnlineMap();
        sIconMap = new HashMap();
    }
}

