/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icon;

import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.gui.ResourceReplacePanel;
import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.icon.IconManager;
import com.miui.theme.tool.icon.IconResourceReplacePanel;
import com.miui.theme.tool.util.GUIUtil;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JLabel;

public class IconRightPanel
extends TransparentPanel {
    public static ArrayList<String> mResolutions = new ArrayList();
    public static ArrayList<String> mResolutionSizes = new ArrayList();
    public static ArrayList<String> mResolutionPath = new ArrayList();
    public static NinePatch sSubset = GUIUtil.getNinePatch("icon/subset_bg.9.png");
    public static final int TOP_PADDING = 68;
    public static final int LEFT_RIGHT_PADDING = 14;
    public static final int REPLACE_CELL_HEIGHT = 161;
    public static final int LABEL_WIDTH = 90;
    public static Color sFontColor = GUIUtil.hex2color("#65676d");
    public static Color sSubsetDevideColor = GUIUtil.hex2color("#d9dadc");
    public static Color sSubsetDevideColor2 = GUIUtil.hex2color("#fcfcfc");
    private JLabel mEditIconLabel;
    private File mCatalogFile;
    private BufferedImage mIcon;
    private ResourceReplacePanel.ReplaceActionListener mReplaceActionListener = new ResourceReplacePanel.ReplaceActionListener(){

        @Override
        public void onRefresh() {
            IconRightPanel.this.initPanel();
        }

        @Override
        public void onWait() {
        }
    };

    public void setIconFile(File file) {
        this.mCatalogFile = file;
        this.mIcon = GUIUtil.getImage(this.mCatalogFile);
        this.initPanel();
    }

    public void initPanel() {
        int n;
        this.removeAll();
        double[] dArray = new double[mResolutions.size() + 2];
        dArray[0] = 68.0;
        for (n = 0; n < mResolutions.size(); ++n) {
            dArray[1 + n] = 161.0;
        }
        dArray[dArray.length - 1] = -1.0;
        this.initLayout(dArray);
        for (n = 0; n < mResolutions.size(); ++n) {
            File file = new File(IconManager.getIconsFolder() + File.separator + mResolutionPath.get(n) + File.separator + this.mCatalogFile.getName());
            IconResourceReplacePanel iconResourceReplacePanel = new IconResourceReplacePanel(mResolutions.get(n), this.mCatalogFile, file, this.mReplaceActionListener);
            JLabel jLabel = new JLabel();
            jLabel.setHorizontalAlignment(0);
            jLabel.setText(mResolutions.get(n));
            jLabel.setForeground(sFontColor);
            this.add((Component)jLabel, "1, " + (n + 1));
            this.add((Component)iconResourceReplacePanel, "2, " + (n + 1));
        }
        this.validate();
        this.repaint();
    }

    public void initLayout(double[] dArray) {
        double[][] dArrayArray = new double[][]{{14.0, 90.0, -1.0, 14.0}, dArray};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.mIcon != null) {
            int n = this.getWidth() - 28;
            int n2 = 161 * mResolutions.size();
            sSubset.draw(graphics2D, 14, 68, n, n2);
            graphics2D.setColor(sSubsetDevideColor);
            graphics2D.fillRect(104, 68, 1, n2);
            for (int i = 1; i < mResolutions.size(); ++i) {
                graphics2D.setColor(sSubsetDevideColor);
                graphics2D.fillRect(14, 68 + i * 161, n, 1);
                graphics2D.setColor(sSubsetDevideColor2);
                graphics2D.fillRect(15, 68 + i * 161 + 1, n - 2, 1);
            }
        }
    }

    static {
        String string = "<html> <center> <p style='font-size:12; font-weight:bold;'>";
        String string2 = "</p><p style='font-size:10;font-weight:normal;'>";
        String string3 = "</p> </center></html>";
        mResolutions.add(string + "480P" + string2 + "(90x90px)" + string3);
        mResolutions.add(string + "720P" + string2 + "(136x136px)" + string3);
        mResolutions.add(string + "1080P" + string2 + "(192x192px)" + string3);
        mResolutionPath.add("res" + File.separator + "drawable-hdpi");
        mResolutionPath.add("res" + File.separator + "drawable-xhdpi");
        mResolutionPath.add("res" + File.separator + "drawable-xxhdpi");
    }
}

