/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icon;

import com.miui.theme.tool.gui.NinePBackgroundPanel;
import com.miui.theme.tool.gui.SetListableJList;
import com.miui.theme.tool.icon.IconFilterPanel;
import com.miui.theme.tool.icon.MockLauncher;
import com.miui.theme.tool.icon.SelectFilter;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import miui.content.res.IconConfig;
import miui.content.res.IconCustomizer;
import miui.imagefilters.TFilter;

public class FilterPanel
extends NinePBackgroundPanel
implements ListSelectionListener,
ActionListener {
    private IconConfig mIconConfig;
    private List<TFilter> mIconFilters = new ArrayList<TFilter>();
    private SetListableJList mFilterSelectList;
    private JPanel mLeftPanel = new JPanel();
    private JPanel mRightPanel = new JPanel();
    private TFilter mCurrentFilter;
    private MockLauncher mPreviewPanel;
    protected static ImageIcon sCreateNormal = ResourceFactory.getInstance().getImageIcon("icon/add_normal.png");
    protected static ImageIcon sCreateHover = ResourceFactory.getInstance().getImageIcon("icon/add_hover.png");
    protected static ImageIcon sCreatePressed = ResourceFactory.getInstance().getImageIcon("icon/add_click.png");
    protected JButton mCreateButton = GUIUtil.createTransparentButton(sCreateNormal, sCreateHover, sCreatePressed, null);
    protected static ImageIcon sDeleteNormal = ResourceFactory.getInstance().getImageIcon("icon/del_normal.png");
    protected static ImageIcon sDeleteHover = ResourceFactory.getInstance().getImageIcon("icon/del_hover.png");
    protected static ImageIcon sDeletePressed = ResourceFactory.getInstance().getImageIcon("icon/del_click.png");
    protected JButton mDeleteButton = GUIUtil.createTransparentButton(sDeleteNormal, sDeleteHover, sDeletePressed, null);
    protected static ImageIcon sUpNormal = ResourceFactory.getInstance().getImageIcon("icon/up_normal.png");
    protected static ImageIcon sUpHover = ResourceFactory.getInstance().getImageIcon("icon/up_hover.png");
    protected static ImageIcon sUpPressed = ResourceFactory.getInstance().getImageIcon("icon/up_click.png");
    protected JButton mUpButton = GUIUtil.createTransparentButton(sUpNormal, sUpHover, sUpPressed, null);
    protected static ImageIcon sDownNormal = ResourceFactory.getInstance().getImageIcon("icon/down_normal.png");
    protected static ImageIcon sDownHover = ResourceFactory.getInstance().getImageIcon("icon/down_hover.png");
    protected static ImageIcon sDownPressed = ResourceFactory.getInstance().getImageIcon("icon/down_click.png");
    protected JButton mDownButton = GUIUtil.createTransparentButton(sDownNormal, sDownHover, sDownPressed, null);

    public FilterPanel(IconConfig iconConfig, MockLauncher mockLauncher) {
        this.mIconConfig = iconConfig;
        this.mPreviewPanel = mockLauncher;
        if (this.mIconConfig.mFilterList != null) {
            this.mIconFilters = this.mIconConfig.mFilterList;
        }
        this.setNinePBackground("icon/config_bg.9.png");
        double[][] dArrayArray = new double[][]{{-1.0, -1.0, -1.0}, {-1.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.mLeftPanel.setOpaque(false);
        this.mRightPanel.setOpaque(false);
        this.add((Component)this.mLeftPanel, "0, 0");
        this.add((Component)this.mRightPanel, "1, 0, 2, 0");
        this.initLeftPanel();
    }

    private void initLeftPanel() {
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        this.mLeftPanel.setLayout(new GridBagLayout());
        this.mFilterSelectList = new SetListableJList();
        this.mFilterSelectList.getSelectionModel().setSelectionMode(0);
        this.mFilterSelectList.setList(this.mIconFilters);
        this.mFilterSelectList.addListSelectionListener(this);
        this.mFilterSelectList.setFixedCellHeight(36);
        this.mFilterSelectList.setFixedCellWidth(139);
        this.mFilterSelectList.setOpaque(false);
        this.mFilterSelectList.setBackground(new Color(0, 0, 0, 0));
        this.mFilterSelectList.setBorder(BorderFactory.createLineBorder(new Color(208, 208, 210)));
        this.mCreateButton.addActionListener(this);
        this.mDeleteButton.addActionListener(this);
        this.mDeleteButton.setEnabled(false);
        this.mUpButton.addActionListener(this);
        this.mUpButton.setEnabled(false);
        this.mDownButton.addActionListener(this);
        this.mDownButton.setEnabled(false);
        n = 0;
        GridBagHelper.addComponent(this.mLeftPanel, this.mFilterSelectList, n, ++n2, 4, 1, 0, 0, n3, n3, 1.0, 1.0, 1, 10);
        n = 0;
        GridBagHelper.addComponent(this.mLeftPanel, this.mCreateButton, n, ++n2, 1, 1, 0, 0, n3, n3, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mLeftPanel, this.mDeleteButton, ++n, n2, 1, 1, 0, 0, n3, n3, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mLeftPanel, this.mUpButton, ++n, n2, 1, 1, 0, 0, n3, n3, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mLeftPanel, this.mDownButton, ++n, n2, 1, 1, 0, 0, n3, n3, 1.0, 0.0, 1, 10);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (-1 == this.mFilterSelectList.getSelectedIndex()) {
            this.mDeleteButton.setEnabled(false);
            this.mUpButton.setEnabled(false);
            this.mDownButton.setEnabled(false);
            return;
        }
        if (this.mFilterSelectList.getSelectedIndex() == 0) {
            this.mDeleteButton.setEnabled(true);
            this.mUpButton.setEnabled(false);
            if (this.mIconFilters.size() > 1) {
                this.mDownButton.setEnabled(true);
            } else {
                this.mDownButton.setEnabled(false);
            }
        } else if (this.mFilterSelectList.getSelectedIndex() == this.mIconFilters.size() - 1) {
            this.mDeleteButton.setEnabled(true);
            this.mUpButton.setEnabled(true);
            this.mDownButton.setEnabled(false);
        } else {
            this.mDeleteButton.setEnabled(true);
            this.mUpButton.setEnabled(true);
            this.mDownButton.setEnabled(true);
        }
        this.initRightPanel();
    }

    private void initRightPanel() {
        this.mCurrentFilter = this.mIconFilters.size() == 0 ? null : (TFilter)this.mFilterSelectList.getSelectedValue();
        this.mRightPanel.removeAll();
        this.mRightPanel.setLayout(new BorderLayout());
        if (this.mCurrentFilter != null) {
            if (this.mCurrentFilter.mName.equals("Hsl")) {
                this.mRightPanel.add((Component)new HSLEditPanel(this.mCurrentFilter), "Center");
            } else if (!this.mCurrentFilter.mName.equals("Edges")) {
                if (this.mCurrentFilter.mName.equals("Levels")) {
                    this.mRightPanel.add((Component)new LevelsEditPanel(this.mCurrentFilter), "Center");
                } else if (this.mCurrentFilter.mName.equals("GrayScale")) {
                    this.mRightPanel.add((Component)new GrayScaleEditPanel(this.mCurrentFilter), "Center");
                }
            }
        }
        this.mRightPanel.invalidate();
        this.mRightPanel.validate();
        this.mRightPanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n = this.mFilterSelectList.getSelectedIndex();
        if (actionEvent.getSource().equals(this.mCreateButton)) {
            object = new SelectFilter();
            ((Dialog)object).setVisible(true);
            if (((SelectFilter)object).mFilterResult != null) {
                this.mIconFilters.add(((SelectFilter)object).mFilterResult);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FilterPanel.this.mFilterSelectList.setSelectedIndex(FilterPanel.this.mFilterSelectList.getModel().getSize() - 1);
                        FilterPanel.this.initRightPanel();
                    }
                });
            }
        }
        if (actionEvent.getSource().equals(this.mDeleteButton)) {
            if (n == -1) {
                return;
            }
            this.mIconFilters.remove(n);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (FilterPanel.this.mFilterSelectList.getModel().getSize() <= 0) {
                        FilterPanel.this.mFilterSelectList.setSelectedIndex(-1);
                    } else {
                        FilterPanel.this.mFilterSelectList.setSelectedIndex(0);
                    }
                    FilterPanel.this.initRightPanel();
                }
            });
        }
        if (actionEvent.getSource().equals(this.mUpButton)) {
            if (n <= 0) {
                return;
            }
            object = this.mIconFilters.get(n);
            this.mIconFilters.set(n, this.mIconFilters.get(n - 1));
            this.mIconFilters.set(n - 1, (TFilter)object);
            this.mFilterSelectList.setSelectedIndex(n - 1);
        }
        if (actionEvent.getSource().equals(this.mDownButton)) {
            if (n >= this.mIconFilters.size() - 1) {
                return;
            }
            object = this.mIconFilters.get(n);
            this.mIconFilters.set(n, this.mIconFilters.get(n + 1));
            this.mIconFilters.set(n + 1, (TFilter)object);
            this.mFilterSelectList.setSelectedIndex(n + 1);
        }
        this.mIconConfig.mIconFilters = IconCustomizer.tFilterListToImageFilterGroup(this.mIconFilters);
        IconFilterPanel.refreshPreviewPanel(this.mPreviewPanel, this.mIconConfig);
        this.mFilterSelectList.updateUI();
    }

    class GrayScaleEditPanel
    extends FilterEditPanel {
        public GrayScaleEditPanel(TFilter tFilter) {
            super(tFilter);
        }

        @Override
        void initKeyList() {
            this.mKeyList = new ArrayList();
            this.mKeyList.add("BlackColor");
            this.mKeyList.add("WhiteColor");
        }
    }

    class LevelsEditPanel
    extends FilterEditPanel {
        public LevelsEditPanel(TFilter tFilter) {
            super(tFilter);
        }

        @Override
        void initKeyList() {
            this.mKeyList = new ArrayList();
            this.mKeyList.add("InputMin");
            this.mKeyList.add("InputMiddle");
            this.mKeyList.add("InputMax");
            this.mKeyList.add("OutputMin");
            this.mKeyList.add("OutputMax");
        }
    }

    class HSLEditPanel
    extends FilterEditPanel {
        public HSLEditPanel(TFilter tFilter) {
            super(tFilter);
        }

        @Override
        void initKeyList() {
            this.mKeyList = new ArrayList();
            this.mKeyList.add("HueModify");
            this.mKeyList.add("HueAdjust");
            this.mKeyList.add("SaturationModify");
            this.mKeyList.add("SaturationAdjust");
            this.mKeyList.add("LightnessModify");
            this.mKeyList.add("LightnessAdjust");
        }
    }

    abstract class FilterEditPanel
    extends JPanel
    implements KeyListener {
        protected TFilter mTFilter;
        protected HashMap<String, JLabel> mLabelMap;
        protected HashMap<String, JTextField> mTextField;
        public ArrayList<String> mKeyList;

        public FilterEditPanel(TFilter tFilter) {
            this.mTFilter = tFilter;
            this.initKeyList();
            this.init();
        }

        abstract void initKeyList();

        /*
         * WARNING - void declaration
         */
        public void init() {
            this.mLabelMap = new HashMap();
            this.mTextField = new HashMap();
            for (String object : this.mKeyList) {
                this.mLabelMap.put(object, new JLabel(ResourceFactory.getString("filter." + object)));
            }
            for (String string : this.mKeyList) {
                this.mTextField.put(string, new JTextField());
                this.mTextField.get(string).addKeyListener(this);
            }
            if (this.mTFilter.mParamEntrys != null) {
                for (int i = 0; i < this.mTFilter.mParamEntrys.size(); ++i) {
                    Map.Entry<String, String> entry = this.mTFilter.mParamEntrys.get(i);
                    for (String string : this.mKeyList) {
                        if (!entry.getKey().equals(string)) continue;
                        this.mTextField.get(string).setText(entry.getValue());
                    }
                }
            }
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            int n = 0;
            boolean bl = false;
            int n2 = 2;
            for (String string : this.mKeyList) {
                void var2_10;
                GridBagHelper.addComponent(this, this.mLabelMap.get(string), n, (int)var2_10, 1, 1, 0, 0, n2, n2, 1.0, 0.0, 1, 10);
                GridBagHelper.addComponent(this, this.mTextField.get(string), ++n, (int)var2_10, 1, 1, 0, 0, n2, n2, 1.0, 0.0, 1, 10);
                n = 0;
                ++var2_10;
            }
        }

        public void refresh() {
            ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>();
            for (String string : this.mKeyList) {
                String string2 = this.mTextField.get(string).getText();
                if (string2.isEmpty()) continue;
                AbstractMap.SimpleEntry<String, String> simpleEntry = new AbstractMap.SimpleEntry<String, String>(string, string2);
                arrayList.add(simpleEntry);
            }
            this.mTFilter.mParamEntrys = arrayList;
            ((FilterPanel)FilterPanel.this).mIconConfig.mIconFilters = IconCustomizer.tFilterListToImageFilterGroup(FilterPanel.this.mIconFilters);
            IconFilterPanel.refreshPreviewPanel(FilterPanel.this.mPreviewPanel, FilterPanel.this.mIconConfig);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.refresh();
        }
    }
}

