/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icon;

import com.miui.theme.tool.gui.CommonRightPanel;
import com.miui.theme.tool.gui.main.ModuleRightPanel;
import com.miui.theme.tool.gui.skin.ThemeScrollPane;
import com.miui.theme.tool.icon.IconPageList;
import com.miui.theme.tool.icon.IconRightPanel;
import com.miui.theme.tool.icon.IconSelectListener;
import com.miui.theme.tool.icon.MockLauncher;
import com.miui.theme.tool.icon.PageClickListener;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class BaseIconPanel
extends ModuleRightPanel {
    public static final int ICON_PER_PAGE = 20;
    public static final int ICON_PER_LINE = 4;
    protected Vector<String> mIcons = new Vector();
    protected Vector<MockLauncher> mMockLaunchers = new Vector();
    protected static String sSubsetDevide = "icon/subset_devide.9.png";
    protected JPanel mIconPanel;
    protected ImageIcon mLeftIcon = ResourceFactory.getInstance().getImageIcon("icon/arrow_left_n.png");
    protected ImageIcon mLeftIconHover = ResourceFactory.getInstance().getImageIcon("icon/arrow_left_h.png");
    protected ImageIcon mLeftIconPressed = ResourceFactory.getInstance().getImageIcon("icon/arrow_left_p.png");
    protected ImageIcon mLeftIconDisabled = ResourceFactory.getInstance().getImageIcon("icon/arrow_left_d.png");
    protected JButton mLeftButton = GUIUtil.createTransparentButton(this.mLeftIcon, this.mLeftIconHover, this.mLeftIconPressed, this.mLeftIconDisabled);
    protected ImageIcon mRightIcon = ResourceFactory.getInstance().getImageIcon("icon/arrow_right_n.png");
    protected ImageIcon mRightIconHover = ResourceFactory.getInstance().getImageIcon("icon/arrow_right_h.png");
    protected ImageIcon mRightIconPressed = ResourceFactory.getInstance().getImageIcon("icon/arrow_right_p.png");
    protected ImageIcon mRightIconDisabled = ResourceFactory.getInstance().getImageIcon("icon/arrow_right_d.png");
    protected JButton mRightButton = GUIUtil.createTransparentButton(this.mRightIcon, this.mRightIconHover, this.mRightIconPressed, this.mRightIconDisabled);
    protected int mCurrentPage = 0;
    protected File mCurrentIcon;
    protected IconSelectListener mIconSelectListener = new IconSelectListener(){

        @Override
        public void onIconSelected(MockLauncher mockLauncher, File file) {
            for (int i = 0; i < BaseIconPanel.this.mMockLaunchers.size(); ++i) {
                if (BaseIconPanel.this.mMockLaunchers.get(i).equals(mockLauncher)) continue;
                BaseIconPanel.this.mMockLaunchers.get((int)i).mCurrentIconIndex = -1;
            }
            BaseIconPanel.this.mCurrentIcon = file;
            BaseIconPanel.this.refreshIconRightPanel();
        }
    };
    protected ActionListener mLeftButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseIconPanel.this.switchPage(BaseIconPanel.this.mCurrentPage - 1);
        }
    };
    protected ActionListener mRightButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseIconPanel.this.switchPage(BaseIconPanel.this.mCurrentPage + 1);
        }
    };
    protected IconRightPanel mIconRightPanel;
    private IconPageList mIconPageList;
    private JScrollPane mIconPageScroll;

    public BaseIconPanel() {
        this.initIcons();
        this.initMockLauncher();
        this.initLayout();
    }

    private void initLayout() {
        double[][] dArrayArray = new double[][]{{470.0, 1.0, -1.0}, {568.0, -1.0, 200.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.initIconPageList();
        this.initIconLeftPanel();
        this.initIconRightPanel();
        this.add((Component)this.mIconPanel, "0, 0");
        this.mIconPageScroll = new ThemeScrollPane(this.mIconPageList);
        this.mIconPageScroll.getHorizontalScrollBar().setUnitIncrement(20);
        this.mIconPageScroll.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                BaseIconPanel.this.repaint();
            }
        });
        this.mIconPageScroll.setVerticalScrollBarPolicy(21);
        this.add((Component)this.mIconPageScroll, "0, 2");
        this.add((Component)this.getSepPanel(), "1, 0, 1, 2");
    }

    protected void initIconPageList() {
        this.mIconPageList = new IconPageList(this.mMockLaunchers);
        this.mIconPageList.setPageClickListener(new PageClickListener(){

            @Override
            public void onClick(int n) {
                BaseIconPanel.this.switchPage(n);
            }
        });
    }

    protected void initIconRightPanel() {
        this.mIconRightPanel = new IconRightPanel();
        this.add((Component)this.mIconRightPanel, "2, 0, 2, 2");
    }

    protected void refreshIconRightPanel() {
        new Thread(){

            @Override
            public void run() {
                BaseIconPanel.this.mIconRightPanel.setIconFile(BaseIconPanel.this.mCurrentIcon);
            }
        }.start();
    }

    protected void initIconLeftPanel() {
        this.mIconPanel = new CommonRightPanel();
        double[][] dArrayArray = new double[][]{{-1.0, 39.0, 20.0, 280.0, 20.0, 39.0, -1.0}, {47.0, 11.0, 10.0, -1.0, 37.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mIconPanel.setLayout(tableLayout);
        this.mLeftButton.addActionListener(this.mLeftButtonListener);
        this.mRightButton.addActionListener(this.mRightButtonListener);
        this.mIconPanel.add((Component)this.mLeftButton, "1, 3");
        this.mIconPanel.add((Component)this.mRightButton, "5, 3");
        if (this.mMockLaunchers.size() > 0) {
            this.switchPage(0);
        }
    }

    protected void switchPage(int n) {
        this.mIconPanel.remove(this.mMockLaunchers.get(this.mCurrentPage));
        this.mCurrentPage = n;
        this.mIconPageList.refresh(this.mCurrentPage);
        this.resetButton();
        this.mIconPanel.add((Component)this.mMockLaunchers.get(this.mCurrentPage), "3, 3");
        this.mIconPanel.revalidate();
        this.mIconPanel.repaint();
    }

    protected void resetButton() {
        if (this.mMockLaunchers.size() == 1) {
            this.mLeftButton.setEnabled(false);
            this.mRightButton.setEnabled(false);
        }
        if (this.mCurrentPage == 0) {
            this.mLeftButton.setEnabled(false);
            this.mRightButton.setEnabled(true);
        } else if (this.mCurrentPage == this.mMockLaunchers.size() - 1) {
            this.mLeftButton.setEnabled(true);
            this.mRightButton.setEnabled(false);
        } else {
            this.mLeftButton.setEnabled(true);
            this.mRightButton.setEnabled(true);
        }
    }

    protected void initMockLauncher() {
        Vector<String> vector = null;
        for (int i = 0; i < this.mIcons.size(); ++i) {
            if (i % 20 == 0) {
                vector = new Vector<String>();
                this.mMockLaunchers.add(new MockLauncher(vector));
            }
            vector.add(this.mIcons.get(i));
        }
        new Thread(){

            @Override
            public void run() {
                for (MockLauncher mockLauncher : BaseIconPanel.this.mMockLaunchers) {
                    mockLauncher.refresh();
                    mockLauncher.setIconSelectListener(BaseIconPanel.this.mIconSelectListener);
                    BaseIconPanel.this.mIconPageList.refresh(BaseIconPanel.this.mCurrentPage);
                    BaseIconPanel.this.mIconPanel.revalidate();
                    BaseIconPanel.this.mIconPanel.repaint();
                }
            }
        }.start();
    }

    protected abstract void initIcons();
}

