/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.skin;

import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.util.GUIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ScrollBarUI
extends BasicScrollBarUI {
    private static Color mTackerColor = GUIUtil.hex2color("#d6d6d7");
    private static NinePatch mThumbPatchNormal = GUIUtil.getNinePatch("icon/slider_normal.9.png");
    private static NinePatch mThumbPatchHover = GUIUtil.getNinePatch("icon/slider_hover.9.png");
    protected static int sMinSize = 13;

    public static ComponentUI createUI(JComponent jComponent) {
        return new ScrollBarUI();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.scrollbar.remove(this.incrButton);
        this.scrollbar.remove(this.decrButton);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        graphics.setColor(GUIUtil.COMMON_RIGHT_BACKGROUND_COLOR);
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        super.paint(graphics, jComponent);
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(mTackerColor);
        if (rectangle.width > rectangle.height) {
            graphics.fillRect(rectangle.x, rectangle.y + rectangle.height / 2 - 2, rectangle.width, 1);
        } else {
            graphics.fillRect(rectangle.x + rectangle.width / 2 - 2, rectangle.y, 1, rectangle.height);
        }
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (rectangle.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                n = sMinSize;
                break;
            }
            case 0: {
                n2 = sMinSize;
            }
        }
        if (this.isThumbRollover()) {
            mThumbPatchHover.draw((Graphics2D)graphics, rectangle.x, rectangle.y, n, n2);
        } else {
            mThumbPatchNormal.draw((Graphics2D)graphics, rectangle.x, rectangle.y, n, n2);
        }
    }

    @Override
    protected void paintDecreaseHighlight(Graphics graphics) {
    }

    @Override
    protected void paintIncreaseHighlight(Graphics graphics) {
    }
}

