/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.skin;

import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.gui.skin.BoxPaddingMenuLayout;
import com.miui.theme.tool.resource.ResourceFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class PopupMenuUI
extends BasicPopupMenuUI {
    public static final String BACKGROUND = "main/menu_background.9.png";
    private NinePatch mPatch;

    public PopupMenuUI() {
        try {
            InputStream inputStream = ResourceFactory.getInstance().getResourceSream(BACKGROUND);
            this.mPatch = NinePatch.load(inputStream, true, false);
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new PopupMenuUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
        int[] nArray = new int[4];
        this.mPatch.getPadding(nArray);
        jComponent.setLayout(new BoxPaddingMenuLayout(nArray, (LayoutManager2)jComponent.getLayout()));
    }

    @Override
    public Popup getPopup(JPopupMenu jPopupMenu, int n, int n2) {
        Popup popup = super.getPopup(jPopupMenu, n, n2);
        JPanel jPanel = (JPanel)jPopupMenu.getParent();
        jPanel.setOpaque(false);
        return popup;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        this.mPatch.draw((Graphics2D)graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
    }
}

