/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.skin;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;

public class BoxPaddingMenuLayout
implements LayoutManager2 {
    LayoutManager2 mLayoutManager;
    protected int[] mPadding;

    public BoxPaddingMenuLayout(int[] nArray, LayoutManager2 layoutManager2) {
        this.mPadding = nArray;
        this.mLayoutManager = layoutManager2;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.mLayoutManager.addLayoutComponent(string, component);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.mLayoutManager.removeLayoutComponent(component);
    }

    public Dimension addPadding(Dimension dimension) {
        return new Dimension(dimension.width + this.mPadding[0] + this.mPadding[2], dimension.height + this.mPadding[1] + this.mPadding[3]);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.addPadding(this.mLayoutManager.preferredLayoutSize(container));
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.addPadding(this.mLayoutManager.minimumLayoutSize(container));
    }

    @Override
    public void layoutContainer(Container container) {
        this.mLayoutManager.layoutContainer(container);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Rectangle rectangle = componentArray[i].getBounds();
            rectangle.x += this.mPadding[0] / 2;
            rectangle.width -= this.mPadding[0];
            rectangle.y += this.mPadding[1];
            rectangle.y -= i * (this.mPadding[1] + this.mPadding[3]) / componentArray.length - 1;
            rectangle.height -= (this.mPadding[1] + this.mPadding[3]) / componentArray.length;
            componentArray[i].setBounds(rectangle);
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this.mLayoutManager.addLayoutComponent(component, object);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.mLayoutManager.maximumLayoutSize(container);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return this.mLayoutManager.getLayoutAlignmentX(container);
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return this.mLayoutManager.getLayoutAlignmentY(container);
    }

    @Override
    public void invalidateLayout(Container container) {
        this.mLayoutManager.invalidateLayout(container);
    }
}

