/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.outlook;

import com.miui.theme.tool.gui.NinePBackgroundPanel;
import com.miui.theme.tool.gui.outlook.OutlookList;
import com.miui.theme.tool.gui.outlook.OutlookPanel;
import com.miui.theme.tool.gui.outlook.OutlookTabData;
import com.miui.theme.tool.gui.skin.ThemeLookAndFeel;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OutlookListPanel
extends JPanel {
    public Rectangle TAB_TITLE_SIZE = new Rectangle(147, 50);
    public OutlookPanel mOutlookPanel;
    public OutlookList mOutlookPanelList;
    public OutlookTabData mData;
    private TabTitlePanel mTabTitlePanel;
    private ListSelectionListener mListSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                OutlookListPanel.this.mOutlookPanel.listSelected(OutlookListPanel.this);
            }
            OutlookListPanel.this.mOutlookPanel.repaint();
        }
    };
    public boolean mIsOpened = false;

    public OutlookListPanel(OutlookTabData outlookTabData) {
        this.mData = outlookTabData;
        this.setBackground(GUIUtil.TRANSPARENT);
        this.init();
    }

    private void init() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.mOutlookPanelList = new OutlookList(this.mData.mList);
        this.mTabTitlePanel = new TabTitlePanel(this.mData.mTitle.toString());
        this.mOutlookPanelList.setSelectionMode(0);
        this.mOutlookPanelList.addListSelectionListener(this.mListSelectionListener);
        this.setListVisible(false);
    }

    public void setAfterOpened(boolean bl) {
        this.mTabTitlePanel.setTabAfterOpened(bl);
    }

    public void setListVisible(boolean bl) {
        this.mIsOpened = bl;
        if (bl) {
            double[][] dArrayArray = new double[][]{{this.TAB_TITLE_SIZE.width}, {this.TAB_TITLE_SIZE.height, -2.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            this.add((Component)this.mTabTitlePanel, "0, 0");
            this.add((Component)this.mOutlookPanelList, "0, 1");
        } else {
            double[][] dArrayArray = new double[][]{{this.TAB_TITLE_SIZE.width}, {this.TAB_TITLE_SIZE.height}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            this.add((Component)this.mTabTitlePanel, "0, 0");
        }
    }

    public void listUnselect() {
        this.mOutlookPanelList.clearSelection();
    }

    class TabTitlePanel
    extends NinePBackgroundPanel {
        private String mTitle;
        private JLabel mLabel;
        private BufferedImage mOpenedIndicator = ResourceFactory.getInstance().getImage("outlook/arrow_opened.png");
        private BufferedImage mClosedIndicator = ResourceFactory.getInstance().getImage("outlook/arrow_closed.png");
        public MouseAdapter mMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                OutlookListPanel.this.mOutlookPanel.tabSelect(OutlookListPanel.this);
            }
        };

        public void setTabAfterOpened(boolean bl) {
            if (bl) {
                this.setNinePBackground("outlook/main_tree_middle_after_opened.9.png");
            } else {
                this.setNinePBackground("outlook/main_tree_middle.9.png");
            }
        }

        public TabTitlePanel(String string) {
            this.mTitle = string;
            this.setTabAfterOpened(false);
            this.mLabel = new JLabel(this.mTitle);
            this.mLabel.setForeground(GUIUtil.hex2color("#262626"));
            this.mLabel.setFont(ThemeLookAndFeel.getFont(13.0f));
            double[][] dArrayArray = new double[][]{{18.0, -1.0, 28.0}, {-1.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            this.add((Component)this.mLabel, "1, 0");
            this.addMouseListener(this.mMouseAdapter);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (OutlookListPanel.this.mIsOpened) {
                graphics.drawImage(this.mOpenedIndicator, this.getWidth() - 20, 23, null);
            } else {
                graphics.drawImage(this.mClosedIndicator, this.getWidth() - 20, 23, null);
            }
        }
    }
}

