/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.android.ddmlib.IDevice;
import com.miui.theme.tool.gui.CommonRightPanel;
import com.miui.theme.tool.phone.DebugBridge;
import com.miui.theme.tool.phone.tree.BasicTreeNode;
import com.miui.theme.tool.phone.tree.UiNode;
import com.miui.theme.tool.phone.uiautomator.UiAutomatorInstance;
import com.miui.theme.tool.phone.uiautomator.UiAutomatorModel;
import com.miui.theme.tool.phone.uiautomator.UiAutomatorTask;
import com.miui.theme.tool.util.GUIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PhoneSnapshotPanel
extends CommonRightPanel {
    private static final long serialVersionUID = 1L;
    private static final int IMG_BORDER_HORZONTAL = 10;
    private static final int IMG_BORDER_VERTICAL = 70;
    private SnapshotStateChangeListener mStateChangeListener;
    private UiAutomatorModel mSnapshotModel = null;
    private BufferedImage mSnapshotImage = null;
    private List<String> mSnapshotTextList = new ArrayList<String>();
    private String mSnapshotPkgName = null;
    private int mDx;
    private int mDy;
    private float mScale;

    public PhoneSnapshotPanel() {
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                String string;
                BasicTreeNode basicTreeNode;
                if (PhoneSnapshotPanel.this.mSnapshotModel != null && PhoneSnapshotPanel.this.mSnapshotModel.isExploreMode() && (basicTreeNode = PhoneSnapshotPanel.this.mSnapshotModel.updateSelectionForCoordinates(PhoneSnapshotPanel.this.getInverseScaledSize(mouseEvent.getX() - PhoneSnapshotPanel.this.mDx), PhoneSnapshotPanel.this.getInverseScaledSize(mouseEvent.getY() - PhoneSnapshotPanel.this.mDy))) instanceof UiNode && (string = ((UiNode)basicTreeNode).getTextContent("").trim()).length() > 0) {
                    if (PhoneSnapshotPanel.this.mStateChangeListener != null) {
                        PhoneSnapshotPanel.this.mStateChangeListener.onTextSelected(string);
                    }
                    PhoneSnapshotPanel.this.setSelectNode(basicTreeNode);
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }
        });
    }

    public void setSnapshotStateChangeListener(SnapshotStateChangeListener snapshotStateChangeListener) {
        this.mStateChangeListener = snapshotStateChangeListener;
    }

    public void refreshSnapshot() {
        if (!DebugBridge.isInitialized()) {
            System.err.println("Error obtaining Device ScreenshotUnable to connect to adb. Check if adb is installed correctly.");
            return;
        }
        IDevice iDevice = this.pickDevice();
        if (iDevice == null) {
            GUIUtil.alert("No Android devices were detected by adb.");
            return;
        }
        if (UiAutomatorInstance.getInstance().isUpdating()) {
            System.err.println("Waiting: snapshot is being obtained.");
            return;
        }
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onBeginObtainSnapshot();
        }
        new UiAutomatorTask(iDevice, true){

            @Override
            protected void done() {
                PhoneSnapshotPanel.this.updateSnapshotView(null);
            }
        }.execute();
    }

    public void updateSnapshotView(String string) {
        UiAutomatorModel uiAutomatorModel = UiAutomatorInstance.getInstance().getAutomatorModel();
        List<Object> list = new ArrayList();
        String string2 = null;
        if (uiAutomatorModel != null) {
            string2 = uiAutomatorModel.getPackageName();
            list = uiAutomatorModel.getNodesTextList();
        }
        if (string == null || string.equals(string2)) {
            this.mSnapshotModel = uiAutomatorModel;
            this.mSnapshotImage = UiAutomatorInstance.getInstance().getSnapshotImage();
            this.mSnapshotTextList = list;
            this.mSnapshotPkgName = string2;
            if (this.mStateChangeListener != null) {
                this.mStateChangeListener.onFinishObtainSnasphot(string2, this.mSnapshotTextList);
            }
            this.updateUI();
        }
    }

    public List<String> getSnapshotTextList() {
        return Collections.unmodifiableList(this.mSnapshotTextList);
    }

    public String getSnapshotPackageName() {
        return this.mSnapshotPkgName;
    }

    public void updateSelectTextArea(String string) {
        UiNode uiNode = this.mSnapshotModel.findMatchedNodeByText(string);
        this.setSelectNode(uiNode);
    }

    private void setSelectNode(BasicTreeNode basicTreeNode) {
        this.mSnapshotModel.setSelectedNode(basicTreeNode);
        this.updateUI();
    }

    private IDevice pickDevice() {
        List<IDevice> list = DebugBridge.getDevices();
        if (list.size() == 0) {
            System.err.println("Error obtaining Device ScreenshotNo Android devices were detected by adb.");
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.get(0);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.mSnapshotImage == null) {
            return;
        }
        this.updateScreenshotTransformation();
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.mDx, this.mDy);
        affineTransform.scale(this.mScale, this.mScale);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(this.mSnapshotImage, affineTransform, null);
        Rectangle rectangle = this.mSnapshotModel.getCurrentDrawingRect();
        if (rectangle != null) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect(this.mDx + this.getScaledSize(rectangle.x), this.mDy + this.getScaledSize(rectangle.y), this.getScaledSize(rectangle.width), this.getScaledSize(rectangle.height));
        }
    }

    private int getScaledSize(int n) {
        if (this.mScale == 1.0f) {
            return n;
        }
        return new Double(Math.floor((float)n * this.mScale)).intValue();
    }

    private int getInverseScaledSize(int n) {
        if (this.mScale == 1.0f) {
            return n;
        }
        return new Double(Math.floor((float)n / this.mScale)).intValue();
    }

    private void updateScreenshotTransformation() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.mSnapshotImage.getWidth(null);
        int n4 = this.mSnapshotImage.getHeight(null);
        float f = (float)(n - 20 - 1) / (float)n3;
        float f2 = (float)(n2 - 140 - 1) / (float)n4;
        this.mScale = Math.min(f, f2);
        this.mDx = (n - this.getScaledSize(n3) - 20) / 2 + 10;
        this.mDy = (n2 - this.getScaledSize(n4) - 140) / 2 + 70;
    }

    public static interface SnapshotStateChangeListener {
        public void onBeginObtainSnapshot();

        public void onFinishObtainSnasphot(String var1, List<String> var2);

        public void onTextSelected(String var1);
    }
}

