/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.miui.theme.tool.gui.NinePBackgroundPanel;
import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.gui.main.EditInfoDialog;
import com.miui.theme.tool.gui.main.ThemeInfoData;
import com.miui.theme.tool.gui.main.ThemeManager;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

public class NewThemeDialog
extends EditInfoDialog {
    public static final ImageIcon mViewPathNormal = ResourceFactory.getInstance().getImageIcon("firstpage/view_file_n.png");
    public static final ImageIcon mViewPathPressed = ResourceFactory.getInstance().getImageIcon("firstpage/view_file_p.png");
    protected JButton mViewPathButton = GUIUtil.createTransparentButton(mViewPathNormal, mViewPathPressed, mViewPathPressed, null);
    private EditInfoDialog.Label mSavePathLabel;
    private TransparentPanel mSavePathPanel;
    private NinePBackgroundPanel mSaveTextFieldPanel;
    private JTextField mSaveTextField;
    private ActionListener mViewPathListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setVisible(true);
            jFileChooser.setCurrentDirectory(new File(NewThemeDialog.this.mSaveTextField.toString()));
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(NewThemeDialog.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                String string = file.getAbsolutePath().trim();
                NewThemeDialog.this.mSaveTextField.setText(string);
            }
        }
    };

    public NewThemeDialog() {
        this.initNewThemeFolder();
        this.initThemeInfo();
    }

    private void initThemeInfo() {
        this.mThemeTitleTextField.setText(ResourceFactory.getString("MyTheme"));
        this.mThemeDesignerTextField.setText(ResourceFactory.getString("Default"));
        this.mThemeAuthorTextField.setText(ResourceFactory.getString("Default"));
        this.mThemeVersionTextField.setText("1.0");
        JFileChooser jFileChooser = new JFileChooser();
        this.mSaveTextField.setText(jFileChooser.getCurrentDirectory().getAbsolutePath());
    }

    private void initNewThemeFolder() {
        double[][] dArrayArray = new double[][]{{16.0, 80.0, -1.0, 16.0}, {-1.0, 27.0, 8.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mSavePathPanel = new TransparentPanel();
        this.mSavePathPanel.setLayout(tableLayout);
        this.mSavePathLabel = new EditInfoDialog.Label(ResourceFactory.getString("SavePath"));
        this.mSavePathPanel.add((Component)this.mSavePathLabel, "1, 1");
        this.initSaveTextField();
        this.mMainPanel.add((Component)this.mSavePathPanel, "0, 4, 1, 4");
    }

    private void initSaveTextField() {
        double[][] dArrayArray = new double[][]{{-1.0, 50.0}, {-1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mSaveTextFieldPanel = new NinePBackgroundPanel();
        this.mSaveTextFieldPanel.setNinePBackground("editinfo/dialog_input.9.png");
        this.mSaveTextFieldPanel.setLayout(tableLayout);
        this.mSaveTextField = new EditInfoDialog.TextField();
        this.mSaveTextField.setHorizontalAlignment(0);
        this.mSaveTextFieldPanel.add((Component)this.mSaveTextField, "0, 0");
        this.mViewPathButton.setText(ResourceFactory.getString("ViewPath"));
        this.mViewPathButton.addActionListener(this.mViewPathListener);
        this.adjustButton(this.mViewPathButton);
        this.mSaveTextFieldPanel.add((Component)this.mViewPathButton, "1, 0");
        this.mSavePathPanel.add((Component)this.mSaveTextFieldPanel, "2, 1");
    }

    @Override
    public void initTitleLabel() {
        super.initTitleLabel();
        this.mDialogTitleLabel.setText(ResourceFactory.getString("NewTheme"));
    }

    @Override
    public void initConfirmPanel() {
        this.mMainPanel.add((Component)this.mConfirmButton, "2, 4, 3, 4");
        this.mConfirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = NewThemeDialog.this.mSaveTextField.getText() + File.separator + NewThemeDialog.this.mThemeTitleTextField.getText();
                File file = new File(string);
                file.mkdirs();
                ThemeInfoData themeInfoData = new ThemeInfoData(file);
                ThemeManager.getInstance().setThemeInfoData(themeInfoData);
                NewThemeDialog.this.mEditInfoListener.actionPerformed(actionEvent);
                ThemeManager.openTheme(file);
            }
        });
    }
}

