/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.miui.theme.tool.catalog.StringsManager;
import com.miui.theme.tool.compressor.MtzCompressor;
import com.miui.theme.tool.gui.NinePBackgroundPanel;
import com.miui.theme.tool.gui.main.EditInfoDialog;
import com.miui.theme.tool.gui.main.MenuDialog;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.gui.main.NewThemeDialog;
import com.miui.theme.tool.gui.main.ThemeManager;
import com.miui.theme.tool.icon.IconSync;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.review.ReviewConfig;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.FullResolutionMatchManager;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.Screenshot;
import com.miui.theme.tool.util.ShortcutManager;
import com.miui.theme.tool.util.ThemeHelper;
import com.miui.theme.tool.util.ToastPanel;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class MenuPanel
extends NinePBackgroundPanel {
    public MenuDialog mMenuDialog;
    private MouseAdapter mHideMenuListenerAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MenuPanel.this.mMenuDialog.setVisible(false);
        }
    };
    public static final String MENU_FILE = "File";
    public static final String MENU_EDIT = "Edit";
    public static final String MENU_ABOUT = "About";
    public static final String MENU_ITEM_NEW = "New";
    public static final String MENU_ITEM_OPEN = "Open";
    public static final String MENU_ITEM_OPENLAST = "OpenLast";
    public static final String MENU_ITEM_EDITINFO = "EditInfo";
    public static final String MENU_ITEM_TRANSFORMTHEME = "TransformTheme";
    public static final String MENU_ITEM_EXPORTMTZ = "ExportMtz";
    public static final String MENU_ITEM_EXPORTSTRINGS = "ExportStrings";
    public static final String MENU_ITEM_OPENFOLDER = "OpenFolder";
    public static final String MENU_ITEM_EXIT = "Exit";
    public static final String MENU_ITEM_APPLYTOPHONE = "ApplyToPhone";
    public static final String MENU_ITEM_FULLRESOLUTIONADAPT = "FullResolutionAdapt";
    public static final String MENU_ITEM_RELOAD = "Reload";
    public static final String MENU_ITEM_CAPTURE = "Capture";
    public static final String MENU_ITEM_SYNCICON = "SyncIcon";
    public static final String MENU_ITEM_SYNCMODULE = "SyncModule";
    public static final String MENU_ITEM_CLEAN_TMP = "CleanTmp";
    public static final String MENU_ITEM_CLEAN_MEM = "CleanMem";
    public static final String MENU_ITEM_CHECKUPDATE = "CheckUpdate";
    public static final String MENU_ITEM_LANGENGLISH = "LangEnglish";
    public static final String Menu_ITEM_LANGCHINESE = "LangChinese";
    public static final String MENU_ITEM_GUIDE = "Guide";
    public static final String MENU_ITEM_ABOUT = "About";
    public static final String MENU_ITEM_FIXADB = "FixADB";
    public static String[] mMenus = new String[]{"File", "Edit", "About"};
    public static String[] mRviewMenus = new String[]{"Edit"};
    public static HashMap<String, String[]> mMenuItems = new HashMap();
    Vector<Vector<MenuItemPanel>> mMenuBar = new Vector();
    public static Color sMenuItemBackgroundColor;
    public static Color sShortcutForground;
    public static Color mLineColor;

    public MenuPanel(MenuDialog menuDialog) {
        this.mMenuDialog = menuDialog;
        if (ThemeHelper.isReviewMode()) {
            this.setNinePBackground("review/logo_menu.9.png");
        } else {
            this.setNinePBackground("main/logo_menu.9.png");
        }
        double[][] dArrayArray = new double[][]{{2.0, -1.0, 2.0}, {75.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.initMenu();
        int n = 1;
        int n2 = 22;
        for (Vector<MenuItemPanel> vector : this.mMenuBar) {
            for (MenuItemPanel menuItemPanel : vector) {
                tableLayout.insertRow(n, n2);
                this.add((Component)menuItemPanel, "1, " + n);
                ++n;
            }
            if (vector.equals(this.mMenuBar.lastElement())) continue;
            tableLayout.insertRow(n, 14.0);
            this.add((Component)new SeparatorPanel(), "1, " + n);
            ++n;
        }
        this.addMouseListener(this.mHideMenuListenerAdapter);
    }

    private void initMenu() {
        ShortcutManager shortcutManager = ShortcutManager.getInstance();
        for (String string : mMenus) {
            Vector<MenuItemPanel> vector = new Vector<MenuItemPanel>();
            for (String string2 : mMenuItems.get(string)) {
                final MenuItemPanel menuItemPanel = new MenuItemPanel();
                menuItemPanel.mAction = string2;
                menuItemPanel.setText(ResourceFactory.getString(string2));
                KeyStroke keyStroke = ConfigUtil.getKey(string2);
                if (keyStroke != null) {
                    menuItemPanel.mShortcutLabel.setText(keyStroke.toString().replace("pressed ", "").replace("ctrl", "Ctrl").replace(" ", "+"));
                    shortcutManager.addShortcutListener(new ShortcutManager.ShortcutListener(){

                        @Override
                        public void handle() {
                            MenuPanel.this.doMenuAction(menuItemPanel.mAction);
                        }
                    }, keyStroke);
                }
                vector.add(menuItemPanel);
            }
            this.mMenuBar.add(vector);
        }
    }

    private void doMenuAction(String string) {
        this.mMenuDialog.setVisible(false);
        if (string.equals(MENU_ITEM_OPEN)) {
            ThemeManager.getInstance();
            ThemeManager.selectTheme();
        } else if (string.equals(MENU_ITEM_NEW)) {
            new NewThemeDialog().setVisible(true);
        } else if (string.equals(MENU_ITEM_EXIT)) {
            NewMainFrame.getInstance().exit();
        } else if (string.equals(MENU_ITEM_OPENLAST)) {
            ThemeManager.getInstance();
            ThemeManager.openTheme(new File(ConfigUtil.getThemePath()));
        } else if (string.equals("About")) {
            GUIUtil.toastLong("MIUI Theme Edtior (2012-2015) " + ThemeHelper.getVersion());
        } else if (string.equals(MENU_ITEM_FIXADB)) {
            CmdUtils.killAdb();
        } else if (string.equals(MENU_ITEM_LANGENGLISH)) {
            ConfigUtil.put("preference", "Lang", "en_US");
            this.restartEditor();
        } else if (string.equals(Menu_ITEM_LANGCHINESE)) {
            ConfigUtil.put("preference", "Lang", "zh_CN");
            this.restartEditor();
        } else if (string.equals(MENU_ITEM_CAPTURE)) {
            this.screenCapture();
        } else if (string.equals(MENU_ITEM_GUIDE)) {
            ThemeHelper.browse(ResourceFactory.getString("GuideUrl"));
        } else if (string.equals(MENU_ITEM_SYNCICON)) {
            new Thread(){

                @Override
                public void run() {
                    GUIUtil.wait(NewMainFrame.getInstance());
                    ToastPanel toastPanel = GUIUtil.toastEver(ResourceFactory.getString(MenuPanel.MENU_ITEM_SYNCICON));
                    if (IconSync.syncIcons()) {
                        toastPanel.hideToast();
                        GUIUtil.toast(ResourceFactory.getString("Success"));
                    } else {
                        toastPanel.hideToast();
                        GUIUtil.toast(ResourceFactory.getString("Fail"));
                    }
                    GUIUtil.normal(NewMainFrame.getInstance());
                }
            }.start();
        } else if (string.equals(MENU_ITEM_CLEAN_TMP)) {
            new Thread(){

                @Override
                public void run() {
                    MenuPanel.this.cleanTmp();
                }
            }.start();
        } else if (string.equals(MENU_ITEM_CLEAN_MEM)) {
            System.gc();
        } else if (ThemeManager.isThemeLoaded()) {
            if (string.equals(MENU_ITEM_EXPORTMTZ)) {
                boolean bl = MtzCompressor.startCompress(ConfigUtil.getThemePath(), ConfigUtil.getThemePath() + ".mtz");
                GUIUtil.toastLong(ConfigUtil.getThemePath() + ".mtz");
            } else if (string.equals(MENU_ITEM_APPLYTOPHONE)) {
                ThemeManager.applyToPhone();
            } else if (string.equals(MENU_ITEM_EDITINFO)) {
                new EditInfoDialog().setVisible(true);
            } else if (!string.equals(MENU_ITEM_TRANSFORMTHEME)) {
                if (string.equals(MENU_ITEM_EXPORTSTRINGS)) {
                    StringsManager.exportStrings();
                } else if (string.equals(MENU_ITEM_RELOAD)) {
                    ThemeManager.getInstance();
                    ThemeManager.openTheme(new File(ConfigUtil.getThemePath()));
                } else if (string.equals(MENU_ITEM_SYNCMODULE)) {
                    NewMainFrame.getInstance().getMainTabPanel().trySyncModule();
                } else if (string.equals(MENU_ITEM_FULLRESOLUTIONADAPT)) {
                    this.adaptAll();
                } else {
                    GUIUtil.toastLong("Constructing...");
                }
            }
        }
    }

    private void adaptAll() {
        String string = ConfigUtil.getThemePath();
        Vector<File> vector = FullResolutionMatchManager.adaptAllXhdpi(string, "drawable-hdpi");
        Vector<File> vector2 = FullResolutionMatchManager.adaptAllXhdpi(string, "drawable-xxhdpi");
        HashSet<File> hashSet = new HashSet<File>();
        FullResolutionMatchManager.adaptAllPressed(new File(string), hashSet);
        for (File file : vector2) {
            vector.add(file);
        }
        vector.addAll(hashSet);
        FullResolutionMatchManager.showAdaptResult(vector);
    }

    private void cleanTmp() {
        GUIUtil.toast(ResourceFactory.getString("Restarting"));
        File file = ThemeHelper.getTmpFolder();
        if (ThemeHelper.isReviewMode()) {
            ReviewConfig.cleanMtzIds();
            CmdUtils.deleteDir(ReviewConfig.getReviewFolder());
        } else {
            String[] stringArray;
            for (String string : stringArray = new String[]{"compress_cache", "compress_temp", "themes", "screenshot"}) {
                CmdUtils.deleteDir(file.getAbsolutePath() + File.separator + string);
            }
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        CmdUtils.startEditor();
        NewMainFrame.getInstance().exit();
    }

    private void screenCapture() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_hh_mm_ss");
        String string = ThemeHelper.getTmpFolder() + File.separator + "screenshot";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string2 = string + File.separator + simpleDateFormat.format(calendar.getTime()) + ".png";
        try {
            Screenshot.captureScreen(string2);
            GUIUtil.toastLong(string2);
            ThemeHelper.openInExplorer(new File(string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void restartEditor() {
        CmdUtils.startEditor();
        NewMainFrame.getInstance().exit();
    }

    static {
        if (ThemeHelper.isReviewMode()) {
            mMenus = mRviewMenus;
            mMenuItems.put(MENU_EDIT, new String[]{MENU_ITEM_CLEAN_TMP, MENU_ITEM_CLEAN_MEM});
        } else {
            mMenuItems.put(MENU_FILE, new String[]{MENU_ITEM_NEW, MENU_ITEM_OPEN, MENU_ITEM_OPENLAST, MENU_ITEM_EXPORTMTZ});
            mMenuItems.put(MENU_EDIT, new String[]{MENU_ITEM_RELOAD, MENU_ITEM_CAPTURE, MENU_ITEM_SYNCICON, MENU_ITEM_SYNCMODULE, MENU_ITEM_CLEAN_TMP, MENU_ITEM_EDITINFO, MENU_ITEM_APPLYTOPHONE, MENU_ITEM_FULLRESOLUTIONADAPT, MENU_ITEM_FIXADB});
            mMenuItems.put("About", new String[]{MENU_ITEM_LANGENGLISH, MENU_ITEM_GUIDE, "About"});
            if (ResourceFactory.isLangEnUs()) {
                MenuPanel.mMenuItems.get((Object)"About")[0] = Menu_ITEM_LANGCHINESE;
            }
        }
        sMenuItemBackgroundColor = GUIUtil.hex2color("#efeff0");
        sShortcutForground = GUIUtil.hex2color("#bcbcbc");
        mLineColor = GUIUtil.hex2color("#d4d3d3");
    }

    class SeparatorPanel
    extends JPanel {
        SeparatorPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(mLineColor);
            int n = this.getHeight() / 2;
            graphics.drawLine(2, n, this.getWidth() - 3, n);
        }
    }

    class MenuItemPanel
    extends NinePBackgroundPanel {
        private JLabel mLabel;
        public JLabel mShortcutLabel;
        public String mAction;
        private MouseAdapter mHoverListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                MenuItemPanel.this.setNinePBackground("main/menu_item_p.9.png");
                MenuItemPanel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                MenuItemPanel.this.clearNinePBackground();
                MenuItemPanel.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MenuPanel.this.doMenuAction(MenuItemPanel.this.mAction);
            }
        };

        public void setText(String string) {
            this.mLabel.setText(string);
        }

        public MenuItemPanel() {
            this.setBackground(sMenuItemBackgroundColor);
            this.addMouseListener(this.mHoverListener);
            this.addMouseMotionListener(this.mHoverListener);
            double[][] dArrayArray = new double[][]{{20.0, -1.0, 70.0, 20.0}, {-1.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            this.mLabel = new JLabel();
            this.add((Component)this.mLabel, "1, 0");
            this.mShortcutLabel = new JLabel();
            this.mShortcutLabel.setForeground(sShortcutForground);
            this.mShortcutLabel.setHorizontalAlignment(4);
            this.add((Component)this.mShortcutLabel, "2, 0");
        }
    }
}

