/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.miui.theme.tool.gui.CommonRightPanel;
import com.miui.theme.tool.gui.main.ButtonPanel;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.gui.main.ThemeInfoData;
import com.miui.theme.tool.gui.main.ThemeManager;
import com.miui.theme.tool.gui.skin.ThemeLookAndFeel;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MaxMinClosePanel
extends JPanel {
    private final ButtonPanel mButtonPanel;
    private JPanel mInnerPanel;
    private final JLabel mTitleLabel;
    private final SepPanel mSepPanel;
    private final MouseListener mMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ThemeHelper.openInExplorer(new File(ConfigUtil.getThemePath()));
        }
    };
    private final JPanel mTitlePanel;

    public MaxMinClosePanel() {
        this.mButtonPanel = new ButtonPanel();
        this.mSepPanel = new SepPanel();
        this.mTitleLabel = new JLabel();
        this.mTitleLabel.setFont(ThemeLookAndFeel.FONT_MSYH_12);
        this.mTitleLabel.setHorizontalAlignment(4);
        this.mTitleLabel.setForeground(GUIUtil.hex2color("#828282"));
        this.mTitleLabel.addMouseListener(this.mMouseListener);
        GUIUtil.hand(this.mTitleLabel);
        double[][] dArrayArray = new double[][]{{-1.0, -2.0, 36.0, 90.0, 2.0}, {2.0, 30.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.mTitlePanel = new JPanel();
        this.mTitlePanel.setLayout(new BorderLayout());
        this.mTitlePanel.add((Component)this.mTitleLabel, "Center");
        this.add((Component)this.mTitlePanel, "1, 1");
        this.add((Component)this.mSepPanel, "2, 1");
        this.add((Component)this.mButtonPanel, "3, 1");
    }

    public void setTitle(String string, String string2) {
        this.mTitleLabel.setText(string);
        this.mTitleLabel.setToolTipText(string2);
    }

    public void setInnerPanel(JPanel jPanel) {
        if (this.mInnerPanel != null) {
            this.remove(this.mInnerPanel);
        }
        this.mInnerPanel = jPanel;
        this.mTitlePanel.setBackground(GUIUtil.COMMON_RIGHT_BACKGROUND_COLOR);
        this.add((Component)this.mInnerPanel, "0, 0, 4, 2");
    }

    public void refresh() {
        if (ThemeManager.isThemeLoaded()) {
            ThemeInfoData themeInfoData = ThemeManager.getInstance().getThemeInfoData();
            this.setTitle(themeInfoData.mTitle, themeInfoData.mThemeDescriptionFile.getParent());
        }
        this.mButtonPanel.setMaxEnable(NewMainFrame.getInstance().getExtendedState() != 6);
        this.mButtonPanel.repaint();
        this.mTitlePanel.repaint();
        this.mSepPanel.repaint();
    }

    class SepPanel
    extends CommonRightPanel {
        SepPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (MaxMinClosePanel.this.mTitleLabel.getText().isEmpty()) {
                return;
            }
            graphics.setColor(GUIUtil.hex2color("#a9a9a9"));
            int n = this.getWidth() / 2;
            int n2 = 10;
            graphics.drawLine(n, n2, n, n2 + 12);
        }
    }
}

