/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.catalog.CatalogManager;
import com.miui.theme.tool.catalog.Member;
import com.miui.theme.tool.gui.Animation;
import com.miui.theme.tool.gui.NinePBackgroundPanel;
import com.miui.theme.tool.gui.main.HoverSelectedPanel;
import com.miui.theme.tool.gui.main.MainFirstPage;
import com.miui.theme.tool.gui.main.MaxMinClosePanel;
import com.miui.theme.tool.gui.main.ThemeManager;
import com.miui.theme.tool.gui.skin.ThemeLookAndFeel;
import com.miui.theme.tool.icon.IconManager;
import com.miui.theme.tool.icon.IconTabPanel;
import com.miui.theme.tool.more.MoreModulePanel;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.ResourceEditorModulePanel;
import com.miui.theme.tool.review.ReviewWebPanel;
import com.miui.theme.tool.review.SecondReviewWebPanel;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MainTabPanel
extends JPanel {
    public static final int TOP_LOGO = 67;
    public static final int TOP_HEIGHT = 87;
    public static final int ICON_SIZE = 60;
    public static final int INDICATOR_HEIGHT = 12;
    public static final int TAB_TITLE_WIDTH = 67;
    public static ImageIcon mIndicator = ResourceFactory.getInstance().getImageIcon("main/indicator_arrow.png");
    public static final String TAB_ICON = "icon";
    public static final String TAB_CONTACTS = "com.android.contacts";
    public static final String TAB_MMS = "com.android.mms";
    public static final String TAB_SYSTEMUI = "com.android.systemui";
    public static final String TAB_FRAMEWORK_MIUI_RES = "framework-miui-res";
    public static final String TAB_HOME = "com.miui.home";
    public static final String TAB_MORE = "more";
    public String[] mPackages;
    public String[] mIconP;
    public String[] mIconN;
    public static final String[] MAINTAB_PACKAGENAMES = new String[]{"icon", "com.miui.home", "com.android.contacts", "com.android.mms", "com.android.systemui", "framework-miui-res", "more"};
    public static final String[] MAINTAB_ICONS_P = new String[]{"main/icon_p.png", "main/home_p.png", "main/contacts_p.png", "main/mms_p.png", "main/systemui_p.png", "main/framework-miui-res_p.png", "main/more_p.png"};
    public static final String[] MAINTAB_ICONS_N = new String[]{"main/icon_n.png", "main/home_n.png", "main/contacts_n.png", "main/mms_n.png", "main/systemui_n.png", "main/framework-miui-res_n.png", "main/more_n.png"};
    public static final String TAB_WEB = "web";
    public static final String TAB_SECOND_REVIEW = "second_review";
    public static final String[] REVIEW_PACKAGES = new String[]{"web", "second_review"};
    public static final String[] REVIEW_ICONS_P = new String[]{"review/view_p.png", "review/confirm_p.png"};
    public static final String[] REVIEW_ICONS_N = new String[]{"review/view_n.png", "review/confirm_n.png"};
    private TabPanel mTabPanel;
    private TabTitle mCurrentTab;
    private Vector<TabTitle> mTabTitles = new Vector();
    private MouseListener mMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TabTitle tabTitle = (TabTitle)mouseEvent.getSource();
            MainTabPanel.this.switchTab(tabTitle);
        }
    };
    private TabTitle mShortcutTitle;
    private MainFirstPage mFirstPagePanel;
    private ReviewWebPanel mReviewWebPanel;
    private Timer mTimer;
    private MaxMinClosePanel mMaxMinClosePanel;
    private SecondReviewWebPanel mSecondReviewPanel;
    private HashMap<String, JPanel> mPanels = new HashMap();
    public static BufferedImage sIconFrame = ResourceFactory.getInstance().getImage("more/more_icon_fg.png");
    public int mIndicatorPosition = Integer.MAX_VALUE;
    private static ImageIcon mApplyButtonNormal = ResourceFactory.getInstance().getImageIcon("main/apply_btn_n.png");
    private static ImageIcon mApplyButtonPressed = ResourceFactory.getInstance().getImageIcon("main/apply_btn_p.png");

    public MainTabPanel() {
        this.mTabPanel = new TabPanel();
        this.mMaxMinClosePanel = new MaxMinClosePanel();
        this.bindNewTimer();
        if (ThemeHelper.isReviewMode()) {
            this.mTabPanel.layoutTab();
            this.switchTab(0);
        } else {
            this.mFirstPagePanel = new MainFirstPage();
            this.layoutMainTab(this.mFirstPagePanel);
        }
    }

    private void layoutMainTab(JPanel jPanel) {
        this.setBackground(GUIUtil.TRANSPARENT);
        this.removeAll();
        double[][] dArrayArray = new double[][]{{67.0, -1.0}, {-1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.add((Component)this.mTabPanel, "0, 0");
        this.mMaxMinClosePanel.setInnerPanel(jPanel);
        this.add((Component)this.mMaxMinClosePanel, "1, 0");
        this.validate();
        this.repaint();
    }

    private void bindNewTimer() {
        this.mTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainTabPanel.this.mMaxMinClosePanel.refresh();
            }
        });
        this.mTimer.start();
    }

    private JPanel getPanel(String string) {
        JPanel jPanel;
        if (this.mPanels.containsKey(string)) {
            return this.mPanels.get(string);
        }
        if (string.equals(TAB_ICON)) {
            jPanel = new IconTabPanel();
        } else if (string.equals(TAB_MORE)) {
            jPanel = new MoreModulePanel();
        } else if (string.equals(TAB_WEB)) {
            if (this.mReviewWebPanel == null) {
                this.mReviewWebPanel = new ReviewWebPanel();
            }
            this.mReviewWebPanel.processDeleteQueue();
            jPanel = this.mReviewWebPanel;
        } else if (string.equals(TAB_SECOND_REVIEW)) {
            if (this.mSecondReviewPanel == null) {
                this.mSecondReviewPanel = new SecondReviewWebPanel();
            }
            this.mSecondReviewPanel.resetNavigate();
            jPanel = this.mSecondReviewPanel;
        } else {
            jPanel = new ResourceEditorModulePanel(string);
        }
        GUIUtil.moveable(jPanel);
        if (!string.equals(TAB_MORE) && !ThemeHelper.isReviewMode()) {
            this.mPanels.put(string, jPanel);
        }
        return jPanel;
    }

    public void switchTab(JPanel jPanel) {
        GUIUtil.moveable(jPanel);
        this.layoutMainTab(jPanel);
    }

    protected void switchTab(TabTitle tabTitle) {
        if (this.mCurrentTab != null) {
            this.mCurrentTab.setSelected(false);
        }
        this.mCurrentTab = tabTitle;
        this.mCurrentTab.setSelected(true);
        this.adjustIndicator();
        this.layoutMainTab(this.getPanel(this.mCurrentTab.getTitlePackageName()));
    }

    public void switchTab(String string) {
        for (int i = 0; i <= this.mPackages.length - 1; ++i) {
            if (!this.mPackages[i].equals(string)) continue;
            this.switchTab(i);
            return;
        }
        this.mShortcutTitle = new TabTitle(string);
        Member member = CatalogManager.getMemberByPackageName(string);
        if (member == null) {
            GUIUtil.toastLong(ResourceFactory.getString("Error"));
        }
        this.mShortcutTitle.setToolTipText(member.mAppName);
        ImageIcon imageIcon = IconManager.getScaledAndRoundedIcon(IconManager.getIcon(string), 28, sIconFrame);
        this.mShortcutTitle.setIcon(imageIcon);
        this.mShortcutTitle.setHoverIcon(imageIcon);
        this.mShortcutTitle.setSelectedIcon(imageIcon);
        this.mShortcutTitle.setCursor(Cursor.getPredefinedCursor(12));
        this.mShortcutTitle.addMouseListener(this.mMouseAdapter);
        this.mTabPanel.layoutTab();
        this.switchTab(this.mShortcutTitle);
    }

    protected void switchTab(int n) {
        this.switchTab(this.mTabTitles.get(n));
    }

    private int getCurrentIndex() {
        if (this.mCurrentTab.equals(this.mShortcutTitle)) {
            return this.mTabTitles.size();
        }
        for (int i = 0; i < this.mTabTitles.size(); ++i) {
            if (!this.mTabTitles.get(i).equals(this.mCurrentTab)) continue;
            return i;
        }
        return -1;
    }

    private void adjustIndicator() {
        int n = this.getCurrentIndex();
        if (n != -1) {
            int n2 = 87 + n * 67 + 27;
            Animation animation = new Animation(this.mIndicatorPosition, n2, 200){

                @Override
                public void onAnimate() {
                    MainTabPanel.this.mIndicatorPosition = (int)this.mCurrent;
                    MainTabPanel.this.mTabPanel.repaint();
                }
            };
            animation.start();
        }
    }

    public void afterOpenTheme() {
        this.mPanels.clear();
        this.mTabPanel.layoutTab();
        this.switchTab(0);
    }

    public void trySyncModule() {
        String string = this.mCurrentTab.getTitlePackageName();
        if (string.equals(TAB_ICON) || string.equals(TAB_MORE)) {
            return;
        }
        try {
            if (CatalogManager.doImportCatalog(string)) {
                this.mPanels.remove(this.mCurrentTab.mPackageName);
                this.switchTab(this.mCurrentTab);
            } else {
                GUIUtil.showFail();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ ImageIcon access$200() {
        return mApplyButtonNormal;
    }

    static /* synthetic */ ImageIcon access$300() {
        return mApplyButtonPressed;
    }

    class TabTitle
    extends HoverSelectedPanel {
        protected String mPackageName;

        public TabTitle(String string) {
            this.mPackageName = string;
        }

        public String getTitlePackageName() {
            return this.mPackageName;
        }

        @Override
        public void refresh() {
            MainTabPanel.this.mTabPanel.repaint();
        }
    }

    class TabPanel
    extends NinePBackgroundPanel {
        private TabTitle mMoreTabTitle;
        private JButton mAppyButton = GUIUtil.createTransparentButton(MainTabPanel.access$200(), null, MainTabPanel.access$300(), null);
        NinePatch mMoreIconFrame = GUIUtil.getNinePatch("more/more_icon_frame.9.png");

        public TabPanel() {
            this.setNinePBackground("main/left_bg.9.png");
            this.initTab();
        }

        public void layoutTab() {
            int n;
            double[] dArray = new double[MainTabPanel.this.mPackages.length + 2];
            dArray[0] = 87.0;
            for (int i = 1; i <= MainTabPanel.this.mPackages.length; ++i) {
                dArray[i] = 67.0;
            }
            double[][] dArrayArray = new double[][]{{67.0}, dArray};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            for (n = 0; n < MainTabPanel.this.mPackages.length; ++n) {
                this.add((Component)MainTabPanel.this.mTabTitles.get(n), "0, " + (n + 1));
            }
            ++n;
            if (MainTabPanel.this.mShortcutTitle != null) {
                tableLayout.insertRow(n, 67.0);
                this.add((Component)MainTabPanel.this.mShortcutTitle, "0, " + n);
            }
            tableLayout.insertRow(++n, -1.0);
            if (!ThemeHelper.isReviewMode()) {
                tableLayout.insertRow(++n, 37.0);
                this.add((Component)this.mAppyButton, "0, " + n);
            }
            this.revalidate();
            this.repaint();
        }

        public void initTab() {
            if (ThemeHelper.isReviewMode()) {
                MainTabPanel.this.mPackages = REVIEW_PACKAGES;
                MainTabPanel.this.mIconP = REVIEW_ICONS_P;
                MainTabPanel.this.mIconN = REVIEW_ICONS_N;
            } else {
                MainTabPanel.this.mPackages = MAINTAB_PACKAGENAMES;
                MainTabPanel.this.mIconP = MAINTAB_ICONS_P;
                MainTabPanel.this.mIconN = MAINTAB_ICONS_N;
            }
            for (int i = 0; i < MainTabPanel.this.mPackages.length; ++i) {
                TabTitle tabTitle = new TabTitle(MainTabPanel.this.mPackages[i]);
                tabTitle.setIcon(ResourceFactory.getInstance().getImageIcon(MainTabPanel.this.mIconN[i]));
                ImageIcon imageIcon = ResourceFactory.getInstance().getImageIcon(MainTabPanel.this.mIconP[i]);
                tabTitle.setHoverIcon(imageIcon);
                tabTitle.setSelectedIcon(imageIcon);
                tabTitle.setCursor(Cursor.getPredefinedCursor(12));
                tabTitle.addMouseListener(MainTabPanel.this.mMouseAdapter);
                MainTabPanel.this.mTabTitles.add(i, tabTitle);
            }
            this.mMoreTabTitle = (TabTitle)MainTabPanel.this.mTabTitles.get(MainTabPanel.this.mTabTitles.size() - 1);
            this.initAppyButton();
        }

        private void initAppyButton() {
            this.mAppyButton.setText(ResourceFactory.getString("ApplyTheme"));
            this.mAppyButton.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
            GUIUtil.hand(this.mAppyButton);
            this.mAppyButton.setHorizontalTextPosition(0);
            this.mAppyButton.setFont(ThemeLookAndFeel.getFont(12.0f));
            this.mAppyButton.setForeground(GUIUtil.hex2color("#6c6d70"));
            this.mAppyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ThemeManager.applyToPhone();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.mPatch != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                this.mPatch.draw(graphics2D, 0, 67, this.getWidth(), this.getHeight() - 67);
            }
            if (MainTabPanel.this.mIndicatorPosition != -1) {
                mIndicator.paintIcon(this, graphics, 61, MainTabPanel.this.mIndicatorPosition);
            }
        }

        @Override
        protected void paintChildren(Graphics graphics) {
            super.paintChildren(graphics);
            if (MainTabPanel.this.mShortcutTitle != null) {
                int n = 50;
                int n2 = 120;
                int n3 = (67 - n) / 2;
                int n4 = 496;
                this.mMoreIconFrame.draw((Graphics2D)graphics, n3, n4, n, n2);
            }
        }
    }
}

